/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.plug;

import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.navigation.InboundPlug;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.webdynpro.controllereditor.IDialogWithButtonAccess;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParametersWizardPage;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParametersWizardTableModel;
import com.sap.ide.webdynpro.controllereditor.wizards.plug.CreateInboundPlugWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.plug.CreateInboundPlugWizardPropertiesPage;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterPlaceholder;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterService;
import com.sap.ide.webdynpro.service.controllereditor.plug.PlugService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateInboundPlugWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String TITLE = mTextPool.getText(505);
    private IDialogWithButtonAccess mDialog = null;
    private CreateInboundPlugWizardData mData = null;
    private CreateInboundPlugWizardPropertiesPage mPropertiesPage = null;
    private CreateParametersWizardPage mParametersPage = null;
    private Controller mController = null;
    private AbstractView mView = null;

    public CreateInboundPlugWizard(Controller controller, AbstractView view) {
        this(controller, view, new CreateInboundPlugWizardData(controller));
    }

    public CreateInboundPlugWizard(Controller controller, AbstractView view, CreateInboundPlugWizardData data) {
        this.mData = data;
        this.mController = controller;
        this.mView = view;
        this.setWindowTitle(mTextPool.getText(603));
    }

    public void setWizardDialog(IDialogWithButtonAccess dialog) {
        this.mDialog = dialog;
    }

    public boolean performFinish() {
        String error = PlugService.isNewInboundPlugNameValid((String)this.mData.getName(), (AbstractView)this.mView, (Controller)this.mController);
        if (error != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        error = PlugService.createInboundPlugInternal((AbstractView)this.mView, (String)this.mData.getName(), (String)this.mData.getEventHandlerName(), (boolean)this.mData.getStartup());
        if (error != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        InboundPlug plug = this.mView.getInboundPlug(this.mData.getName());
        if (plug != null && (error = ParameterService.createParameters((ParameterizedFeature)plug, (ParameterPlaceholder[])this.mParametersPage.getParameters())) != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        if (plug.hasEventHandler() && this.mParametersPage.getAddParametersAlsoToEventHandler() && (error = ParameterService.createParameters((ParameterizedFeature)plug.getEventHandler(), (ParameterPlaceholder[])this.mParametersPage.getParameters())) != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(TITLE);
    }

    public void addPages() {
        this.mPropertiesPage = new CreateInboundPlugWizardPropertiesPage(this.mData, this.mView, this.mController, this.mDialog);
        this.addPage((IWizardPage)this.mPropertiesPage);
        CreateParametersWizardTableModel parametersTableModel = new CreateParametersWizardTableModel(this.mController, null, true);
        this.mParametersPage = new CreateParametersWizardPage(parametersTableModel, this.mController, null);
        this.mParametersPage.setShowAddParametersAlsoToEventHandler(true);
        this.addPage((IWizardPage)this.mParametersPage);
    }

    public CreateInboundPlugWizardData getData() {
        return this.mData;
    }
}

