/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.parameter;

import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.controllereditor.parameters.ParameterEditDialog;
import com.sap.ide.webdynpro.controllereditor.parameters.ParametersTableModel;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParameterWizardDialog;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterPlaceholder;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.UIHelper;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;

public class CreateParametersWizardTableModel
extends ParametersTableModel {
    private ParameterizedFeature mFeature = null;
    private ParameterPlaceholder[] mParameters = null;
    private boolean mAddParametersAlsoToEventHandler = true;
    private boolean mSupportsArrays = false;

    public CreateParametersWizardTableModel(Controller controller, ParameterizedFeature feature, boolean supportsArrays) {
        super(controller);
        this.mFeature = feature;
        if (this.mFeature != null) {
            this.mParameters = new ParameterPlaceholder[this.mFeature.getParameters().length];
            int i = 0;
            while (i < this.mParameters.length) {
                MetamodelServices.CompoundType type = new MetamodelServices.CompoundType(this.mFeature.getParameter(i).getType());
                this.mParameters[i] = new ParameterPlaceholder(this.mFeature, this.mFeature.getParameter(i).getName(), type);
                ++i;
            }
        } else {
            this.mParameters = new ParameterPlaceholder[0];
        }
        this.mSupportsArrays = supportsArrays;
    }

    protected boolean isModifiedParentObjectRelevant(DevelopmentObject object) {
        return true;
    }

    protected void doNew() {
        CreateParameterWizardDialog dialog = null;
        if (this.mFeature != null) {
            dialog = new CreateParameterWizardDialog(this.mFeature, this.getController(), this.mParameters);
        } else {
            IProject project = ServicesEclipse.getEclipseProject((DevelopmentObject)this.getController());
            dialog = new CreateParameterWizardDialog(project.getName(), this.getController(), this.mParameters);
        }
        dialog.open();
        dialog.close();
        if (dialog.isNewParameterValid()) {
            MetamodelServices.CompoundType compoundType = dialog.getData().getSelectedTypeAsCompoundType();
            if (compoundType == null) {
                compoundType = new MetamodelServices.CompoundType(dialog.getData().getSelectedType());
            }
            ParameterPlaceholder placeholder = new ParameterPlaceholder(this.mFeature, dialog.getData().getName(), compoundType);
            placeholder.setArrayDimension(dialog.getData().getArrayDimension());
            this.addParameter(placeholder);
        }
    }

    protected boolean isReadOnly() {
        boolean readOnly = false;
        if (this.mFeature != null) {
            readOnly = this.mFeature.isReadOnly();
        }
        return readOnly;
    }

    protected void doDelete(int[] indexes) {
        ParameterPlaceholder[] parameters = this.getIndexesParameterPlaceholders(indexes);
        int i = 0;
        while (i < indexes.length) {
            ParameterPlaceholder parameter = parameters[i];
            if (UIHelper.askUserToDelete((String)parameter.getName(), (String)AbstractControllerTableModel.mTextPool.getText(19))) {
                this.deleteParameter(parameter);
            }
            ++i;
        }
    }

    public void doDown(int index) {
        ParameterPlaceholder parameter = this.mParameters[index];
        this.moveParameterDown(parameter);
    }

    protected void doEdit(int[] indexes) {
        ParameterPlaceholder[] parameters = this.getIndexesParameterPlaceholders(indexes);
        int i = 0;
        while (i < indexes.length) {
            ParameterPlaceholder parameter = parameters[i];
            ParameterEditDialog dialog = new ParameterEditDialog(parameter, this.getController(), 1, null, this.mSupportsArrays);
            if (dialog.open() == 0) {
                this.editParameter(parameter, dialog.getNewParameterType(), dialog.getNewParameterTypeAsCompoundType(), dialog.getNewParameterTypeArrayDimension());
            }
            ++i;
        }
    }

    public void doUp(int index) {
        ParameterPlaceholder parameter = this.mParameters[index];
        this.moveParameterUp(parameter);
    }

    public DevelopmentObject getDataTableEntry(int index) {
        return null;
    }

    public int getRowCount() {
        if (this.mParameters == null) {
            return 0;
        }
        return this.mParameters.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mParameters == null) {
            return AbstractControllerTableModel.ERROR;
        }
        if (rowIndex >= this.mParameters.length) {
            return AbstractControllerTableModel.ERROR;
        }
        ParameterPlaceholder parameter = this.mParameters[rowIndex];
        if (parameter == null) {
            return AbstractControllerTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                return parameter.getName();
            }
            case 1: {
                if (parameter.getType() == null) {
                    return AbstractControllerTableModel.ERROR;
                }
                return this.addDimensionString(parameter.getType().isJavaNativeType() ? parameter.getType().getQualifiedName() : parameter.getType().getName(), parameter.getArrayDimension());
            }
        }
        return AbstractControllerTableModel.ERROR;
    }

    protected void updateDataTable() {
    }

    public boolean isCopyable(int[] indexes) {
        return false;
    }

    public ParameterPlaceholder[] getParameters() {
        return this.mParameters;
    }

    public boolean getAddParametersAlsoToEventHandler() {
        return this.mAddParametersAlsoToEventHandler;
    }

    public void setAddParametersAlsoToEventHandler(boolean value) {
        this.mAddParametersAlsoToEventHandler = value;
    }

    private void addParameter(ParameterPlaceholder placeholder) {
        ArrayList<ParameterPlaceholder> list = new ArrayList<ParameterPlaceholder>();
        int i = 0;
        while (i < this.mParameters.length) {
            list.add(this.mParameters[i]);
            ++i;
        }
        list.add(placeholder);
        this.mParameters = new ParameterPlaceholder[list.size()];
        this.mParameters = list.toArray(this.mParameters);
        this.fireTableDataChanged();
    }

    private void editParameter(ParameterPlaceholder placeholder, DevelopmentObject newParameterType, MetamodelServices.CompoundType newParameterCompoundType, int arrayDimension) {
        MetamodelServices.CompoundType compoundType = newParameterCompoundType;
        if (compoundType == null) {
            compoundType = new MetamodelServices.CompoundType(newParameterType);
        }
        placeholder.setType(compoundType);
        placeholder.setArrayDimension(arrayDimension);
        this.fireTableDataChanged();
    }

    private void deleteParameter(ParameterPlaceholder placeholder) {
        ArrayList<ParameterPlaceholder> list = new ArrayList<ParameterPlaceholder>();
        int i = 0;
        while (i < this.mParameters.length) {
            if (!placeholder.getName().equals(this.mParameters[i].getName())) {
                list.add(this.mParameters[i]);
            }
            ++i;
        }
        this.mParameters = new ParameterPlaceholder[list.size()];
        this.mParameters = list.toArray(this.mParameters);
        this.fireTableDataChanged();
    }

    private void moveParameterUp(ParameterPlaceholder placeholder) {
        int i = 0;
        while (i < this.mParameters.length) {
            if (this.mParameters[i].getName().equals(placeholder.getName()) && i > 0) {
                this.mParameters[i] = this.mParameters[i - 1];
                this.mParameters[i - 1] = placeholder;
                break;
            }
            ++i;
        }
        this.fireTableDataChanged();
    }

    private void moveParameterDown(ParameterPlaceholder placeholder) {
        int i = 0;
        while (i < this.mParameters.length) {
            if (this.mParameters[i].getName().equals(placeholder.getName()) && i < this.mParameters.length - 1) {
                this.mParameters[i] = this.mParameters[i + 1];
                this.mParameters[i + 1] = placeholder;
                break;
            }
            ++i;
        }
        this.fireTableDataChanged();
    }

    protected ParameterPlaceholder[] getIndexesParameterPlaceholders(int[] indexes) {
        ParameterPlaceholder[] parameters = new ParameterPlaceholder[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            parameters[i] = this.mParameters[indexes[i]];
            ++i;
        }
        return parameters;
    }
}

