/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.parameter;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParameterWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParameterWizardPropertiesPage;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParametersWizardTableModel;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterPlaceholder;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterService;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateParameterWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String TITLE = mTextPool.getText(79);
    protected CreateParameterWizardData mData = null;
    protected CreateParameterWizardPropertiesPage mPropertiesPage = null;
    private Controller mController = null;
    protected ParameterizedFeature mObject = null;
    private String mAdaptSubObjectText = null;
    private ParameterPlaceholder[] mAdditionalParameters = null;
    private boolean mSupportsArrays = false;
    private CreateParametersWizardTableModel mParametersWizardTableModel = null;
    private boolean mParameterValid = false;

    public CreateParameterWizard(ParameterizedFeature object, Controller controller, CreateParameterWizardData data, String adaptSubObjectText, ParameterPlaceholder[] additionalParameters, boolean supportsArrays) {
        this.mData = data;
        this.mController = controller;
        this.mObject = object;
        this.mAdaptSubObjectText = adaptSubObjectText;
        this.mAdditionalParameters = additionalParameters;
        this.mSupportsArrays = supportsArrays;
        this.setWindowTitle(mTextPool.getText(602));
    }

    public void setParametersWizardTableModel(CreateParametersWizardTableModel tableModel) {
        this.mParametersWizardTableModel = tableModel;
    }

    public boolean performFinish() {
        String error = ParameterService.isNewParameterNameValid((String)this.mData.getName(), (ParameterizedFeature)this.mObject, null);
        if (error != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        if (this.mObject != null) {
            error = ParameterService.createParameter((ParameterizedFeature)this.mObject, (String)this.mData.getName(), (DevelopmentObject)this.mData.getSelectedType(), (MetamodelServices.CompoundType)this.mData.getSelectedTypeAsCompoundType(), (boolean)true, (int)this.mData.getArrayDimension());
            if (error != null) {
                this.mPropertiesPage.setErrorMessage(error);
                this.mParameterValid = false;
                return false;
            }
            this.mParameterValid = true;
        } else {
            this.mParameterValid = true;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(TITLE);
    }

    public void addPages() {
        this.mPropertiesPage = new CreateParameterWizardPropertiesPage(this.mData, this.mObject, this.mController, this.mAdaptSubObjectText, this.mAdditionalParameters, this.mSupportsArrays);
        this.addPage((IWizardPage)this.mPropertiesPage);
    }

    public CreateParameterWizardData getData() {
        return this.mData;
    }

    public boolean isNewParameterValid() {
        return this.mParameterValid;
    }
}

