/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.method;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.ErrorHandler;
import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.enum.VisibilityEnum;
import com.sap.ide.metamodel.webdynpro.event.Event;
import com.sap.ide.metamodel.webdynpro.event.EventSource;
import com.sap.ide.webdynpro.controllereditor.wizards.method.CreateMethodWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.method.CreateMethodWizardPropertiesPage;
import com.sap.ide.webdynpro.controllereditor.wizards.method.CreateMethodWizardTypeSelectionPage;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParametersWizardPage;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParametersWizardTableModel;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.method.MethodService;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterPlaceholder;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterService;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateMethodWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String TITLE = mTextPool.getText(521);
    private CreateMethodWizardData mData = null;
    private CreateMethodWizardTypeSelectionPage mTypeSelectionPage = null;
    private CreateMethodWizardPropertiesPage mPropertiesPage = null;
    private CreateParametersWizardPage mParametersPage = null;
    private Controller mController = null;
    private boolean mMethodTypeSet = false;

    public CreateMethodWizard(Controller controller) {
        this(controller, new CreateMethodWizardData(controller));
    }

    public CreateMethodWizard(Controller controller, CreateMethodWizardData data) {
        this.mData = data;
        this.mController = controller;
        this.setWindowTitle(mTextPool.getText(601));
    }

    public boolean performFinish() {
        MetamodelServices.CompoundType compoundType;
        String error = MethodService.isNewMethodNameValid((String)this.mData.getName(), (Controller)this.mController);
        if (error != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        if (MethodService.methodExists((Controller)this.mController, (String)this.mData.getName())) {
            this.mPropertiesPage.setErrorMessage(mTextPool.getText(1024, (Object)mTextPool.getText(902), (Object)this.mData.getName()));
            return false;
        }
        EventHandler procedure = null;
        if (this.mData.getType() == 0) {
            compoundType = null;
            compoundType = this.mData.getSelectedCompoundReturnType() != null ? this.mData.getSelectedCompoundReturnType() : this.mData.getSelectedReturnTypeAsCompoundType();
            error = MethodService.createEventHandler((Controller)this.mController, (String)this.mData.getName(), (VisibilityEnum)VisibilityEnum.PUBLIC, (ErrorHandler)this.mData.getSelectedErrorHandler(), (EventSource)this.mData.getSelectedEventSource(), (Event)this.mData.getSelectedSubscribedEvent(), (boolean)this.mData.isCreateParameters(), (MetamodelServices.CompoundType)compoundType);
            if (error != null) {
                this.mPropertiesPage.setErrorMessage(error);
                return false;
            }
            procedure = this.mController.getEventHandler(this.mData.getName());
        }
        if (this.mData.getType() == 3) {
            compoundType = null;
            compoundType = this.mData.getSelectedCompoundReturnType() != null ? this.mData.getSelectedCompoundReturnType() : this.mData.getSelectedReturnTypeAsCompoundType();
            error = MethodService.createMethod((Controller)this.mController, (String)this.mData.getName(), (VisibilityEnum)this.mData.getSelectedVisibility(), (DevelopmentObject)this.mData.getSelectedReturnType(), (MetamodelServices.CompoundType)compoundType, (int)this.mData.getArrayDimension());
            if (error != null) {
                this.mPropertiesPage.setErrorMessage(error);
                return false;
            }
            procedure = this.mController.getMethod(this.mData.getName());
        }
        if (procedure != null && (error = ParameterService.createParameters(procedure, (ParameterPlaceholder[])this.mParametersPage.getParameters())) != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(TITLE);
    }

    public void addPages() {
        this.mTypeSelectionPage = new CreateMethodWizardTypeSelectionPage(this.mData);
        if (!this.mMethodTypeSet) {
            this.addPage((IWizardPage)this.mTypeSelectionPage);
        }
        this.mPropertiesPage = new CreateMethodWizardPropertiesPage(this.mData, this.mController);
        this.addPage((IWizardPage)this.mPropertiesPage);
        CreateParametersWizardTableModel parametersTableModel = new CreateParametersWizardTableModel(this.mController, null, true);
        this.mParametersPage = new CreateParametersWizardPage(parametersTableModel, this.mController, null);
        this.addPage((IWizardPage)this.mParametersPage);
    }

    public boolean canFinish() {
        if (this.mTypeSelectionPage.isActivePage()) {
            return false;
        }
        return super.canFinish();
    }

    public CreateMethodWizardData getData() {
        return this.mData;
    }

    public void setMethodType(int type) {
        this.mData.setType(type);
        this.mMethodTypeSet = true;
    }
}

