/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.fieldgroup;

import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.Validator;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.FieldGroup;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.wizards.fieldgroup.CreateFieldWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.fieldgroup.CreateFieldWizardPropertiesPage;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateFieldWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String TITLE = mTextPool.getText(95);
    private CreateFieldWizardData mData = new CreateFieldWizardData();
    private CreateFieldWizardPropertiesPage mPropertiesPage = null;
    private FieldGroup mFieldGroup = null;
    private Controller mController = null;

    public CreateFieldWizard(FieldGroup fieldGroup, Controller controller) {
        this.mFieldGroup = fieldGroup;
        this.mController = controller;
        this.setWindowTitle(mTextPool.getText(600));
    }

    public boolean performFinish() {
        int attributeCount = this.mFieldGroup.getAttributeCount();
        ContextElement element = this.mData.getContextAttribute();
        if (element == null) {
            this.mPropertiesPage.setErrorMessage(mTextPool.getText(1020, (Object)this.mData.getContextAttributeName()));
            return false;
        }
        if (!(element instanceof ContextAttribute)) {
            this.mPropertiesPage.setErrorMessage(mTextPool.getText(1029, (Object)this.mData.getContextAttributeName()));
            return false;
        }
        ContextAttribute attribute = (ContextAttribute)element;
        ControllerUsage[] controllerUsages = CheckLayerHelper.getOutgoingControllerUsages((ContextElement)attribute);
        Validator validator = this.mFieldGroup.getValidator();
        if (validator == null) {
            this.mPropertiesPage.setErrorMessage(mTextPool.getText(1025));
            return false;
        }
        this.mFieldGroup.addAttribute(attribute, attributeCount);
        Parameter parameter = null;
        try {
            parameter = validator.createParameter(this.mData.getParameterName(), attributeCount);
        }
        catch (CreateException e) {
            Plugin.internalError(((Object)((Object)this)).getClass(), "performFinish()", e.getMessage(), e, true);
            this.mPropertiesPage.setErrorMessage(mTextPool.getText(1031, (Object)e.getMessage()));
            return false;
        }
        parameter.setType(CheckLayerHelper.getType((ContextAttribute)attribute));
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(TITLE);
    }

    public void addPages() {
        this.mPropertiesPage = new CreateFieldWizardPropertiesPage(this.mData, this.mController);
        this.addPage((IWizardPage)this.mPropertiesPage);
    }
}

