/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.fieldgroup;

import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.wizards.fieldgroup.CreateFieldGroupWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.fieldgroup.CreateFieldGroupWizardPropertiesPage;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.fieldgroup.FieldGroupService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateFieldGroupWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String TITLE = mTextPool.getText(85);
    private CreateFieldGroupWizardData mData = null;
    private CreateFieldGroupWizardPropertiesPage mPropertiesPage = null;
    private Controller mController = null;

    public CreateFieldGroupWizard(Controller controller) {
        this(controller, new CreateFieldGroupWizardData(controller));
    }

    public CreateFieldGroupWizard(Controller controller, CreateFieldGroupWizardData data) {
        this.mData = data;
        this.mController = controller;
        this.setWindowTitle(mTextPool.getText(599));
    }

    public boolean performFinish() {
        String error = FieldGroupService.isNewFieldGroupNameValid((String)this.mData.getName(), (Controller)this.mController);
        if (error != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        error = FieldGroupService.createFieldGroup((Controller)this.mController, (String)this.mData.getName(), (String)this.mData.getValidatorName());
        if (error != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(TITLE);
    }

    public void addPages() {
        this.mPropertiesPage = new CreateFieldGroupWizardPropertiesPage(this.mData, this.mController);
        this.addPage((IWizardPage)this.mPropertiesPage);
    }

    public CreateFieldGroupWizardData getData() {
        return this.mData;
    }
}

