/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.event;

import com.sap.ide.metamodel.webdynpro.base.CustomEvent;
import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.wizards.event.CreateEventWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.event.CreateEventWizardPropertiesPage;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParametersWizardPage;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParametersWizardTableModel;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.event.EventService;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterPlaceholder;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateEventWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String TITLE = mTextPool.getText(76);
    private CreateEventWizardData mData = null;
    private CreateEventWizardPropertiesPage mPropertiesPage = null;
    private CreateParametersWizardPage mParametersPage = null;
    private Controller mController = null;

    public CreateEventWizard(Controller controller) {
        this(controller, new CreateEventWizardData());
    }

    public CreateEventWizard(Controller controller, CreateEventWizardData data) {
        this.mData = data;
        this.mController = controller;
        this.setWindowTitle(mTextPool.getText(598));
    }

    public boolean performFinish() {
        String error = EventService.isNewEventNameValid((String)this.mData.getName(), (Controller)this.mController);
        if (error != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        error = EventService.createEvent((Controller)this.mController, (String)this.mData.getName());
        if (error != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        CustomEvent event = this.mController.getEvent(this.mData.getName());
        if (event != null && (error = ParameterService.createParameters((ParameterizedFeature)event, (ParameterPlaceholder[])this.mParametersPage.getParameters())) != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(TITLE);
    }

    public void addPages() {
        this.mPropertiesPage = new CreateEventWizardPropertiesPage(this.mData, this.mController);
        this.addPage((IWizardPage)this.mPropertiesPage);
        CreateParametersWizardTableModel parametersTableModel = new CreateParametersWizardTableModel(this.mController, null, true);
        this.mParametersPage = new CreateParametersWizardPage(parametersTableModel, this.mController, null);
        this.addPage((IWizardPage)this.mParametersPage);
    }

    public CreateEventWizardData getData() {
        return this.mData;
    }
}

