/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.modelbinding;

import com.sap.ide.generationfwk.eclipse.progressmonitor.StatusLineProgressMonitor;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.webdynpro.controllereditor.context.ContextContentProvider;
import com.sap.ide.webdynpro.controllereditor.context.ContextLabelProvider;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelClassTreeProxy;
import com.sap.ide.webdynpro.controllereditor.wizards.ControllerWizardPage;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.CheckboxTreeAndList;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericListContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericListLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericTreeContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericTreeLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemCellModifier;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemCellValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemSorter;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListValidationService;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.DataLinkDisabledTreeNodeImageProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.DataLinkTreeNodeSorter;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.WizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.modelbinding.DataLinkBindingContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.modelbinding.DataLinkBindingMergeLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.modelbinding.DataLinkBindingPropertyProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.modelbinding.DataLinkBindingValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.provider.DataLinkLabelProvider;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class PageDataLinkModelBinding
extends ControllerWizardPage {
    private static final String PAGE_NAME;
    private static final String TITLE;
    public static final String COLUMN_NAME = "Name";
    public static final String COLUMN_MODEL_REFERENCE = "Model class/property";
    public static final String COLUMN_MODEL_RELATION = "Model relation";
    private static final String[] mColumns;
    private WizardData mData;
    private DataLinkBindingMergeLabelProvider mMergeLabelProvider;
    private DataLinkDisabledTreeNodeImageProvider mDisabledStateLabelProvider;
    private DataLinkBindingPropertyProvider mPropertyProvider;
    private TreeListItemHelper mHelper = new TreeListItemHelper();
    private CheckboxTreeAndList mTreeList;
    private CellEditor mTextCellEditor;
    private TreeListItemCellValidator mRenameCellEditorValidator;
    private TreeListItemCellModifier mRenameCellModifier;
    private DataLinkBindingValidator mBindingWizardValidator;
    private DataLinkBindingContentProvider mMergeBindingTreeContentProvider;
    private ViewerSorter mTreeSorter;
    private ViewerSorter mListSorter = this.mTreeSorter = new DataLinkTreeNodeSorter();
    private ContextLabelProvider mTargetLabelProvider;
    private DataLinkLabelProvider mTreeNodeLabelProvider;
    private ContextValueNode mSourceContext;
    private ContextContentProvider.ContextRoot mSourceContextRoot;
    private TreeListValidationService mValidation;
    private boolean mControlCreated = false;

    public PageDataLinkModelBinding(WizardData data) {
        super(PAGE_NAME, TITLE, null);
        this.setDescription(TextPool.getInstance().getText(2510));
        this.mData = data;
        if (data.leftToRight()) {
            data.setIsMergeMode(true);
        } else {
            data.setIsMergeMode(false);
        }
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite rootControl = new Composite(parent, 0);
        rootControl.setLayout((Layout)new GridLayout(1, false));
        this.createProviders();
        this.createValidators();
        Composite bindingTreeListControl = new Composite(rootControl, 0);
        bindingTreeListControl.setLayout((Layout)new FillLayout());
        this.mTreeList = new CheckboxTreeAndList(bindingTreeListControl, this.mSourceContext, new GenericTreeContentProvider(this.mHelper, this.mMergeBindingTreeContentProvider), (ILabelProvider)new GenericTreeLabelProvider(this.mHelper, (ILabelProvider)this.mMergeLabelProvider, (ILabelProvider)this.mDisabledStateLabelProvider, this.mPropertyProvider, this.mValidation), new GenericListContentProvider(this.mHelper, (IStructuredContentProvider)this.mMergeBindingTreeContentProvider), (ILabelProvider)new GenericListLabelProvider(this.mHelper, (ILabelProvider)this.mMergeLabelProvider, (ILabelProvider)this.mDisabledStateLabelProvider, this.mPropertyProvider, this.mValidation), new TreeListItemSorter(this.mTreeSorter), new TreeListItemSorter(this.mListSorter), mColumns, 0, -1, -1);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        bindingTreeListControl.setLayoutData((Object)gridData);
        if (this.mData.leftToRight()) {
            Button mergeCheckBox = new Button(rootControl, 32);
            mergeCheckBox.setSelection(this.mData.isMergeMode());
            GridData checkBoxGridData = new GridData();
            checkBoxGridData.heightHint = 35;
            checkBoxGridData.horizontalIndent = 5;
            mergeCheckBox.setLayoutData((Object)checkBoxGridData);
            mergeCheckBox.setText(TextPool.getInstance().getText(2221));
            mergeCheckBox.addSelectionListener((SelectionListener)new MergeCheckBoxSelectionListener());
        }
        Table table = this.mTreeList.getListTable();
        table.getColumn(0).setWidth(90);
        table.getColumn(1).setWidth(120);
        table.getColumn(2).setWidth(70);
        table.getColumn(0).setText(TextPool.getInstance().getText(2212));
        table.getColumn(1).setText(TextPool.getInstance().getText(2215));
        table.getColumn(2).setText(TextPool.getInstance().getText(2216));
        this.mTextCellEditor = new TextCellEditor((Composite)this.mTreeList.getListViewer().getTable());
        this.setControl((Control)rootControl);
        this.mControlCreated = true;
    }

    private void createProviders() {
        this.mSourceContext = this.mData.getSourceController().getContext();
        this.mSourceContextRoot = new ContextContentProvider.ContextRoot((ContextElement)this.mSourceContext);
        this.mMergeLabelProvider = new DataLinkBindingMergeLabelProvider((ILabelProvider)new DataLinkLabelProvider(this.mData.getControllerUsages(), false, false));
        this.mMergeBindingTreeContentProvider = new DataLinkBindingContentProvider(this.mSourceContext, this.mData.getSourceNode(), this.mData.getTargetObject(), this.mData.getContentProvider(), this.mData.getDirection());
        this.mDisabledStateLabelProvider = new DataLinkDisabledTreeNodeImageProvider();
        this.mPropertyProvider = new DataLinkBindingPropertyProvider(this.mSourceContext, this.mData.getSourceNode(), this.mData.getTargetObject(), this.mData.getDirection());
    }

    private void createValidators() {
        this.mRenameCellEditorValidator = new TreeListItemCellValidator();
        this.mRenameCellModifier = new DataLinkMappingCellModifier();
        this.mBindingWizardValidator = new DataLinkBindingValidator(this.mData);
        this.mValidation = new TreeListValidationService(this.mBindingWizardValidator, this.mHelper);
    }

    private void setTarget() {
        this.mMergeBindingTreeContentProvider.setMergeMode(this.mData.isMergeMode());
    }

    public boolean isPageComplete() {
        return this.mValidation != null && this.mValidation.validateForWizardPageCompleteness();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initializeWithProgress();
        }
        super.setVisible(visible);
    }

    private void initializeWithProgress() {
        BusyIndicator.showWhile((Display)this.mTreeList.getTreeViewer().getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IProgressMonitor monitor = StatusLineProgressMonitor.getStatusLineProgressMonitor((boolean)true);
                try {
                    PageDataLinkModelBinding.this.initializeItems(monitor);
                    PageDataLinkModelBinding.this.initializeUI(monitor);
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        });
    }

    public void initializeItems(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask(TextPool.getInstance().getText(2227), -1);
        }
        this.mHelper.clearData();
        if (this.mData.getHelper() == null) {
            this.mData.setHelper(this.mHelper);
        }
        this.buildTreeListItems(monitor);
        if (monitor != null) {
            monitor.done();
        }
    }

    private void initializeUI(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask(TextPool.getInstance().getText(2228), this.mHelper.getItems().size());
        }
        this.mHelper.setTreeListEditable(this, new CellEditor[]{this.mTextCellEditor, this.mTextCellEditor, this.mTextCellEditor}, this.mRenameCellModifier, this.mRenameCellEditorValidator);
        this.mData.getHelper().initializeTreeList(this, this.mData.getHelper().getTopLevelItems(), this.mData.getSourceNode(), 2, monitor);
        if (monitor != null) {
            monitor.done();
        }
        this.setPageComplete(this.isPageComplete());
    }

    private void buildTreeListItems(IProgressMonitor monitor) {
        this.createProviders();
        this.setTarget();
        this.createValidators();
        this.mHelper.buildTreeListItems(this.mTreeList, this.mMergeBindingTreeContentProvider, mColumns, this.mPropertyProvider, this.mSourceContextRoot, this.mValidation, monitor);
    }

    static {
        TITLE = PAGE_NAME = TextPool.getInstance().getText(2311);
        mColumns = new String[]{COLUMN_NAME, COLUMN_MODEL_REFERENCE, COLUMN_MODEL_RELATION};
    }

    private class MergeCheckBoxSelectionListener
    implements SelectionListener {
        private MergeCheckBoxSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            PageDataLinkModelBinding.this.mData.setIsMergeMode(((Button)e.getSource()).getSelection());
            BusyIndicator.showWhile((Display)PageDataLinkModelBinding.this.mTreeList.getTreeViewer().getControl().getDisplay(), (Runnable)new Runnable(this){
                private final /* synthetic */ MergeCheckBoxSelectionListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    MergeCheckBoxSelectionListener.access$500(this.this$1).initializeItems(null);
                    PageDataLinkModelBinding.access$200(MergeCheckBoxSelectionListener.access$500(this.this$1), null);
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        static /* synthetic */ PageDataLinkModelBinding access$500(MergeCheckBoxSelectionListener x0) {
            return x0.PageDataLinkModelBinding.this;
        }
    }

    private class DataLinkMappingCellModifier
    extends TreeListItemCellModifier {
        private DataLinkMappingCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (property != PageDataLinkModelBinding.COLUMN_NAME) {
                return false;
            }
            if (element instanceof TreeListItem) {
                TreeListItem item = (TreeListItem)element;
                if (item.isTopLevelItem()) {
                    return false;
                }
                if (PageDataLinkModelBinding.this.mData.leftToRight() && ((TreeListItem)element).getElement() == PageDataLinkModelBinding.this.mData.getSourceNode()) {
                    return false;
                }
                if (item.getElement() instanceof ModelClassTreeProxy && ((ModelClassTreeProxy)item.getElement()).getModelClass().equals(PageDataLinkModelBinding.this.mData.getTargetObject())) {
                    return false;
                }
                if (item.getElement() instanceof ModelClassTreeProxy && ((ModelClassTreeProxy)item.getElement()).getParent().equals(PageDataLinkModelBinding.this.mData.getTargetObject())) {
                    return false;
                }
            }
            return super.canModify(element, property);
        }
    }
}

