/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.modelbinding;

import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelClassTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelPropertyTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelRelationRoleTreeProxy;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.IItemValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListValidationService;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.ValidationResult;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.TreeNode;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.WizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.modelbinding.DataLinkBindingHelper;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import org.eclipse.core.runtime.IStatus;

public class DataLinkBindingValidator
implements IItemValidator {
    private WizardData mData;

    public DataLinkBindingValidator(WizardData data) {
        this.mData = data;
    }

    public IStatus validateItem(TreeListItem item, TreeListItemHelper helper, String columnProperty, Object value) {
        TreeNode node;
        String CONTEXT_NAME = "Context";
        Object element = item.getElement();
        String message = null;
        TextPool textPool = TextPool.getInstance();
        TreeListItem parentItem = helper.get(item.getParent());
        ContextValueNode sourceContext = this.mData.getSourceController().getContext();
        String name = null;
        if (columnProperty == null && value == null && item.getProperties().isEmpty()) {
            return null;
        }
        if (columnProperty == null && value == null && !item.getProperties().isEmpty()) {
            columnProperty = "Name";
            name = (String)item.getProperties().getValue("Name");
        } else if (columnProperty == "Name") {
            name = (String)value;
        } else {
            return null;
        }
        if ((element instanceof ModelPropertyTreeProxy || element instanceof TreeNode && this.representsAttribute((TreeNode)element)) && this.hasStructureBinding(item) && !name.equals((String)item.getProperties().getValue("Name"))) {
            message = textPool.getText(2017);
            return new ValidationResult(message, 4);
        }
        if (value != null && !CheckServices.isValidIdentifier((String)name)) {
            message = CoreTextPool.getInstance().getText(2, value);
            return new ValidationResult(message, 4);
        }
        if (this.mData.leftToRight()) {
            if (element.equals(this.mData.getTargetObject())) {
                return null;
            }
        } else if (this.mData.rightToLeft() && element instanceof TreeNode && (node = (TreeNode)element) == this.mData.getSourceNode()) {
            element = this.mData.getTargetObject();
        }
        boolean isDuplicate = false;
        if (item.isEnabled() && item.isChecked()) {
            if (name.equalsIgnoreCase("Context") && element instanceof ContextValueNode && !item.isTopLevelItem()) {
                isDuplicate = true;
            } else if (element instanceof ModelClassTreeProxy) {
                if (TreeListValidationService.isDuplicateName(item, helper, columnProperty, name)) {
                    isDuplicate = true;
                }
            } else if (element instanceof ModelPropertyTreeProxy) {
                if (TreeListValidationService.isDuplicateName(item, parentItem, helper, columnProperty, name)) {
                    isDuplicate = true;
                }
            } else if (element instanceof ModelClass && TreeListValidationService.isDuplicateName(item, helper, columnProperty, name)) {
                isDuplicate = true;
            }
        }
        if (isDuplicate) {
            message = textPool.getText(2007, (Object)name);
            return new ValidationResult(message, 4);
        }
        if ((element instanceof ModelClassTreeProxy || element instanceof ModelRelationRoleTreeProxy || element instanceof ModelClass || element instanceof ModelRelationRole) && !item.isTopLevelItem() && item.isChecked() && item.isEnabled() && ContextService.isUniqueNodeWithinContext((String)name, (ContextNode)sourceContext) != null) {
            message = textPool.getText(2003, (Object)name);
            return new ValidationResult(message, 4);
        }
        return TreeListValidationService.OK_RESULT;
    }

    public boolean isEnabled(TreeListItem item, TreeListItemHelper helper) {
        TreeListItem sourceElementItem = helper.get(this.mData.getSourceNode());
        if (item.isTopLevelItem()) {
            return false;
        }
        if (item.getElement() == this.mData.getSourceNode()) {
            return true;
        }
        return !(this.mData.isMergeMode() ? item.getProperties().getValue("Model class/property") == null : item.getElement() instanceof TreeNode);
    }

    public boolean isNode(TreeListItem item, TreeListItemHelper helper) {
        if (item.getElement() instanceof TreeNode) {
            TreeNode node = (TreeNode)item.getElement();
            return DataLinkBindingHelper.representsContextNode(node);
        }
        return item.getElement() instanceof ModelClassTreeProxy || item.getElement() instanceof ModelRelationRoleTreeProxy;
    }

    public boolean isChecked(TreeListItem item, TreeListItemHelper helper) {
        Object element = item.getElement();
        if (element instanceof TreeNode) {
            TreeNode node = (TreeNode)element;
            return node.getMappedObject() != null && !node.isMappingDeleted();
        }
        return false;
    }

    private boolean hasStructureBinding(TreeListItem item) {
        Object itemElement = item.getElement();
        if (itemElement instanceof ModelClassTreeProxy) {
            ModelClassTreeProxy classProxy = (ModelClassTreeProxy)itemElement;
            return classProxy.getModelClass().hasStructure();
        }
        if (itemElement instanceof ModelPropertyTreeProxy) {
            ModelPropertyTreeProxy propertyProxy = (ModelPropertyTreeProxy)itemElement;
            ModelClassProperty property = (ModelClassProperty)propertyProxy.getModelProperty();
            return property.hasStructureElement();
        }
        if (itemElement instanceof TreeNode) {
            Object candidate = item.getProperties().getValue("Model class/property");
            if (candidate instanceof ModelClass) {
                return ((ModelClass)candidate).hasStructure();
            }
            if (candidate instanceof ModelClassProperty) {
                return ((ModelClassProperty)candidate).hasStructureElement();
            }
        }
        return false;
    }

    private boolean representsAttribute(TreeNode node) {
        return node.getData() instanceof ContextAttribute;
    }
}

