/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.modelbinding;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelEntityTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelRelationRoleTreeProxy;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.IPropertyProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.TreeNode;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.modelbinding.DataLinkBindingHelper;
import java.util.Hashtable;
import java.util.Map;

public class DataLinkBindingPropertyProvider
implements IPropertyProvider {
    private ContextValueNode mSourceContext;
    private TreeNode mSourceNode;
    private DevelopmentObject mTargetModelEntity;
    private boolean mIsReverseMapping;
    private int mDirection;
    private Map mFoundCandidatesForElement = new Hashtable();

    public DataLinkBindingPropertyProvider(ContextValueNode sourceContext, TreeNode sourceNode, DevelopmentObject targetModelEntity, int direction) {
        this.mSourceContext = sourceContext;
        this.mSourceNode = sourceNode;
        this.mTargetModelEntity = targetModelEntity;
        this.mDirection = direction;
    }

    public Object getValue(Object element, String name) {
        int index = -1;
        if (name == "Name") {
            index = 0;
        } else if (name == "Model class/property") {
            index = 1;
        } else if (name == "Model relation") {
            index = 2;
        }
        if (index > -1) {
            return this.getColumnValue(element, index);
        }
        return null;
    }

    public String getLabel(Object element, String name) {
        return this.getColumnText(this.getValue(element, name));
    }

    private Object getColumnValue(Object element, int columnIndex) {
        if (element instanceof TreeListItem) {
            TreeListItem item = (TreeListItem)element;
            return item.getProperties().getValue(columnIndex);
        }
        if (element instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)element;
            DevelopmentObject mappedObject = treeNode.getMappedObject();
            switch (columnIndex) {
                case 0: {
                    return treeNode.getName();
                }
                case 1: {
                    return this.resolveModelBinding(treeNode, columnIndex);
                }
                case 2: {
                    return this.resolveModelBinding(treeNode, columnIndex);
                }
            }
            return null;
        }
        if (element instanceof ModelEntityTreeProxy) {
            ModelEntityTreeProxy treeProxy = (ModelEntityTreeProxy)element;
            switch (columnIndex) {
                case 0: {
                    if (treeProxy.getParentProxy() instanceof ModelRelationRoleTreeProxy) {
                        return treeProxy.getParentProxy().getModelEntity().getName();
                    }
                    return treeProxy.getModelEntity().getName();
                }
                case 1: {
                    return this.resolveModelBinding(treeProxy, columnIndex);
                }
                case 2: {
                    return this.resolveModelBinding(treeProxy, columnIndex);
                }
            }
            return null;
        }
        return null;
    }

    private String getColumnText(Object value) {
        if (value instanceof DevelopmentObject) {
            return ((DevelopmentObject)value).getName();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    private DevelopmentObject resolveModelBinding(TreeNode treeNode, int propertyIndex) {
        DevelopmentObject modelReference = null;
        if (treeNode == this.mSourceNode && this.mTargetModelEntity != null) {
            modelReference = this.mTargetModelEntity;
        }
        if (modelReference == null) {
            DevelopmentObject target = this.getParentsCandidate(treeNode);
            modelReference = DataLinkBindingHelper.findBindingCandidate(treeNode, this.mSourceNode, target);
        }
        if (propertyIndex == 1 && modelReference instanceof ModelRelationRole) {
            modelReference = ((ModelRelationRole)modelReference).getModelClass();
        } else if (propertyIndex == 2 && !(modelReference instanceof ModelRelationRole)) {
            modelReference = null;
        }
        if (modelReference != null) {
            this.mFoundCandidatesForElement.put(treeNode, modelReference);
        }
        return modelReference;
    }

    private DevelopmentObject resolveModelBinding(ModelEntityTreeProxy treeProxy, int propertyIndex) {
        DevelopmentObject modelReference = null;
        if (propertyIndex == 1) {
            modelReference = treeProxy.getModelEntity();
        } else if (propertyIndex == 2 && treeProxy.getParentProxy() instanceof ModelRelationRoleTreeProxy) {
            modelReference = treeProxy.getParentProxy().getModelEntity();
        }
        return modelReference;
    }

    private DevelopmentObject getParentsCandidate(TreeNode treeNode) {
        Object candidate = null;
        Object parent = treeNode.getParent();
        if (parent == null) {
            return null;
        }
        if (!(parent instanceof TreeNode)) {
            return null;
        }
        if (parent == this.mSourceNode) {
            return this.mTargetModelEntity;
        }
        candidate = this.mFoundCandidatesForElement.get(parent);
        if (candidate instanceof DevelopmentObject) {
            return candidate;
        }
        return null;
    }
}

