/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.modelbinding;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.checklayer.model.ModelClassHelper;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelClassTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelEntityTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelPropertyTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelRelationRoleTreeProxy;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.TreeNode;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.modelbinding.DataLinkBindingHelper;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DataLinkBindingContentProvider
implements ITreeContentProvider {
    private ContextValueNode mSourceContext;
    private TreeNode mSourceNode;
    private DevelopmentObject mTargetModelEntity;
    private ITreeContentProvider mSourceContentProvider;
    private Map mFoundCandidates = new Hashtable();
    private int mDirection;
    private boolean mIsMergeMode;

    public DataLinkBindingContentProvider(ContextValueNode sourceContext, TreeNode sourceNode, DevelopmentObject targetModelEntity, ITreeContentProvider sourceContentProvider, int direction) {
        this.mSourceContext = sourceContext;
        this.mSourceNode = sourceNode;
        this.mTargetModelEntity = targetModelEntity;
        this.mSourceContentProvider = sourceContentProvider;
        this.mDirection = direction;
    }

    public Object[] getChildren(Object parentElement) {
        Vector<Object> children = new Vector<Object>();
        Object parent = parentElement;
        if (this.mIsMergeMode) {
            children.addAll(this.doMerge(parent));
        } else {
            if (parentElement instanceof TreeNode) {
                children.addAll(Arrays.asList(this.mSourceContentProvider.getChildren(parentElement)));
                if (parentElement.equals(this.mSourceNode)) {
                    parent = this.proxyForModelEntity(this.mTargetModelEntity);
                }
            }
            if (parent instanceof ModelEntityTreeProxy) {
                children.addAll(this.childrenForProxy((ModelEntityTreeProxy)parent));
            }
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        ModelEntityTreeProxy proxy;
        Object parent = null;
        if (element instanceof ModelClassTreeProxy) {
            ModelRelationRoleTreeProxy roleProxy = ((ModelClassTreeProxy)element).getParent();
            if (roleProxy != null) {
                parent = roleProxy.getParent();
            }
        } else if (element instanceof ModelPropertyTreeProxy) {
            parent = ((ModelPropertyTreeProxy)element).getParent();
        } else if (element instanceof TreeNode) {
            parent = this.mSourceContentProvider.getParent(element);
        }
        if (element instanceof ModelEntityTreeProxy && (proxy = (ModelEntityTreeProxy)element).getForeignParent() != null) {
            parent = proxy.getForeignParent();
        }
        if (parent != null && parent instanceof ModelEntityTreeProxy) {
            if (((ModelEntityTreeProxy)parent).getModelEntity().equals(this.mTargetModelEntity)) {
                parent = this.mSourceNode;
            } else if (this.mTargetModelEntity instanceof ModelRelationRole) {
                ModelRelationRole targetRole = (ModelRelationRole)this.mTargetModelEntity;
                if (((ModelEntityTreeProxy)parent).getModelEntity().equals(targetRole.getModelClass())) {
                    parent = this.mSourceNode;
                }
            }
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        Vector<Object> elements = new Vector<Object>();
        Object treeProxy = null;
        elements.addAll(Arrays.asList(this.mSourceContentProvider.getElements((Object)this.mSourceContext)));
        return elements.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setMergeMode(boolean mergeMode) {
        this.mIsMergeMode = mergeMode;
    }

    private ModelEntityTreeProxy proxyForModelEntity(DevelopmentObject modelEntity) {
        ModelEntityTreeProxy proxy = null;
        if (modelEntity instanceof ModelClass) {
            proxy = new ModelClassTreeProxy((ModelClass)modelEntity, null, null);
        } else if (modelEntity instanceof ModelRelationRole) {
            ModelRelationRole role = (ModelRelationRole)modelEntity;
            ModelRelationRoleTreeProxy roleProxy = new ModelRelationRoleTreeProxy(role, null, null);
            proxy = new ModelClassTreeProxy(role.getModelClass(), roleProxy, null);
        } else if (modelEntity instanceof ModelClassProperty) {
            ModelClassProperty property = (ModelClassProperty)modelEntity;
            ModelClass modelClass = (ModelClass)property.getAppClass();
            proxy = new ModelPropertyTreeProxy((Property)property, null);
        }
        return proxy;
    }

    private List childrenForProxy(ModelEntityTreeProxy parent) {
        Vector<ModelEntityTreeProxy> children = new Vector<ModelEntityTreeProxy>();
        if (parent instanceof ModelClassTreeProxy) {
            ModelClassTreeProxy classProxy = (ModelClassTreeProxy)parent;
            ModelClassProperty[] properties = ModelClassHelper.getProperties((ModelClass)classProxy.getModelClass());
            int i = 0;
            while (i < properties.length) {
                ModelPropertyTreeProxy childProperty = new ModelPropertyTreeProxy((Property)properties[i], classProxy);
                children.add(childProperty);
                ++i;
            }
            ModelRelationRole[] targetRoles = ModelClassHelper.getNavigableTargetModelRelationRoles((ModelClass)classProxy.getModelClass());
            int i2 = 0;
            while (i2 < targetRoles.length) {
                ModelRelationRoleTreeProxy roleProxy = new ModelRelationRoleTreeProxy(targetRoles[i2], classProxy, null);
                ModelClassTreeProxy childClassProxy = new ModelClassTreeProxy(targetRoles[i2].getModelClass(), roleProxy, null);
                if (!this.isRecursiveEntity(childClassProxy)) {
                    Vector<ModelClassTreeProxy> child = new Vector<ModelClassTreeProxy>();
                    child.add(childClassProxy);
                    roleProxy.setChildren(child);
                    children.add(childClassProxy);
                }
                ++i2;
            }
            classProxy.setChildren(children);
        }
        return children;
    }

    protected boolean isRecursiveEntity(ModelClassTreeProxy classProxy) {
        ModelEntityTreeProxy parent = classProxy.getParent();
        ModelClass parentModelEntity = null;
        while (parent != null) {
            if (parent instanceof ModelClassTreeProxy) {
                ModelClassTreeProxy parentClassProxy = (ModelClassTreeProxy)parent;
                parentModelEntity = parentClassProxy.getModelClass();
            } else if (parent instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)((Object)parent);
                parentModelEntity = treeNode.getMappedObject();
            }
            ModelClass elementModelEntity = classProxy.getModelClass();
            if (parentModelEntity != null && parentModelEntity == elementModelEntity) {
                return true;
            }
            if (!(parent instanceof ModelEntityTreeProxy)) continue;
            parent = ((ModelEntityTreeProxy)parent).getParentProxy();
        }
        return false;
    }

    private List doMerge(Object parent) {
        Vector<Object> results = new Vector<Object>();
        DevelopmentObject targetParent = null;
        if (parent instanceof TreeNode) {
            DevelopmentObject target;
            TreeNode parentNode;
            Object[] sourceChildren = this.mSourceContentProvider.getChildren(parent);
            results.addAll(Arrays.asList(sourceChildren));
            if (this.isDescendantOfSourceNode((TreeNode)parent) && (targetParent = DataLinkBindingHelper.findBindingCandidate(parentNode = (TreeNode)parent, this.mSourceNode, target = this.getParentsCandidate(parentNode))) != null) {
                this.mFoundCandidates.put(parentNode, targetParent);
                ModelEntityTreeProxy parentProxy = this.proxyForModelEntity(targetParent);
                List targetChildren = this.childrenForProxy(parentProxy);
                Iterator iter = targetChildren.iterator();
                while (iter.hasNext()) {
                    boolean foundInSource;
                    ModelEntityTreeProxy targetChildProxy = (ModelEntityTreeProxy)iter.next();
                    DevelopmentObject targetChild = targetChildProxy.getModelEntity();
                    boolean bl = foundInSource = DataLinkBindingHelper.findBindingCandidate(targetChildProxy, targetParent, parentNode) != null;
                    if (foundInSource || !this.isHierarchyCorrect(parentNode, targetChild)) continue;
                    results.add(targetChildProxy);
                    targetChildProxy.setForeignParent(parentNode);
                }
            }
        } else if (parent instanceof ModelEntityTreeProxy) {
            results.addAll(this.childrenForProxy((ModelEntityTreeProxy)parent));
        }
        return results;
    }

    private boolean isHierarchyCorrect(TreeNode sourceParentNode, DevelopmentObject target) {
        if (sourceParentNode != this.mSourceNode && !(target.getParent() instanceof Model) && target.getParent() != null) {
            Object sourceParentObject = this.mSourceContentProvider.getParent((Object)sourceParentNode);
            DevelopmentObject targetParent = target.getParent();
            if (targetParent != null && sourceParentObject instanceof TreeNode && !this.isHierarchyCorrect((TreeNode)sourceParentObject, targetParent)) {
                return false;
            }
        }
        return true;
    }

    private boolean isDescendantOfSourceNode(TreeNode treeNode) {
        if (treeNode == this.mSourceNode) {
            return true;
        }
        Object parent = this.getParent(treeNode);
        if (parent instanceof TreeNode) {
            return this.isDescendantOfSourceNode((TreeNode)parent);
        }
        return false;
    }

    private DevelopmentObject getParentsCandidate(TreeNode node) {
        Object candidate = null;
        Object parent = node.getParent();
        if (parent == null) {
            return null;
        }
        if (!(parent instanceof TreeNode)) {
            return null;
        }
        if (parent == this.mSourceNode) {
            return this.mTargetModelEntity;
        }
        if (node == this.mSourceNode) {
            return this.mTargetModelEntity;
        }
        candidate = this.mFoundCandidates.get(parent);
        if (candidate instanceof DevelopmentObject) {
            return candidate;
        }
        return null;
    }
}

