/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.contextmapping;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextRecursionNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.IItemValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListValidationService;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.ValidationResult;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.TreeNode;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.WizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.contextmapping.DataLinkMappingHelper;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import org.eclipse.core.runtime.IStatus;

public class DataLinkMappingValidator
implements IItemValidator {
    private WizardData mData;

    public DataLinkMappingValidator(WizardData data) {
        this.mData = data;
    }

    public IStatus validateItem(TreeListItem item, TreeListItemHelper helper, String columnProperty, Object value) {
        TreeNode node;
        String CONTEXT_NAME = "Context";
        Object element = item.getElement();
        String message = null;
        TextPool textPool = TextPool.getInstance();
        TreeListItem parentItem = helper.get(item.getParent());
        String name = null;
        if (columnProperty == null && value == null && item.getProperties().isEmpty()) {
            return null;
        }
        if (columnProperty == null && value == null && !item.getProperties().isEmpty()) {
            columnProperty = "Name";
            name = (String)item.getProperties().getValue("Name");
        } else if (columnProperty == "Name") {
            name = (String)value;
        } else {
            return null;
        }
        if ((element instanceof ContextAttribute || element instanceof TreeNode && DataLinkMappingHelper.representsContextAttribute((TreeNode)element)) && this.hasStructureBinding(item) && !name.equals((String)item.getProperties().getValue("Name"))) {
            message = textPool.getText(2017);
            return new ValidationResult(message, 4);
        }
        if (value != null && !CheckServices.isValidIdentifier((String)name)) {
            message = CoreTextPool.getInstance().getText(2, (Object)name);
            return new ValidationResult(message, 4);
        }
        if (this.mData.getIsReverseMappingMode() && item.isEnabled() && item.isChecked()) {
            DevelopmentObject targetType;
            DevelopmentObject sourceType;
            String typeMessage;
            Object candidate = item.getProperties().getValue("Mapped element");
            if (candidate == null) {
                message = textPool.getText(2014, (Object)name);
                return new ValidationResult(message, 4);
            }
            if (candidate instanceof ContextValueAttribute && (element instanceof ContextValueAttribute || element instanceof TreeNode && DataLinkMappingHelper.representsContextValueAttribute((TreeNode)element)) && (typeMessage = CheckLayerHelper.isValidType((DevelopmentObject)(sourceType = DataLinkMappingHelper.getType(element)), (DevelopmentObject)(targetType = CheckLayerHelper.getType((ContextAttribute)((ContextValueAttribute)candidate), (boolean)false)))) != null) {
                return new ValidationResult(typeMessage, 4);
            }
        }
        if (this.mData.leftToRight()) {
            if (element.equals(this.mData.getTargetObject())) {
                return null;
            }
        } else if (this.mData.rightToLeft() && element instanceof TreeNode && (node = (TreeNode)element) == this.mData.getSourceNode()) {
            element = this.mData.getTargetObject();
        }
        boolean isDuplicate = false;
        if (item.isEnabled() && item.isChecked()) {
            if (name.equalsIgnoreCase("Context") && element instanceof ContextValueNode && !item.isTopLevelItem()) {
                isDuplicate = true;
            } else if (element instanceof ContextNode || element instanceof TreeNode && DataLinkMappingHelper.resolve((TreeNode)element) instanceof ContextNode) {
                if (TreeListValidationService.isDuplicateName(item, helper, columnProperty, name)) {
                    isDuplicate = true;
                }
            } else if ((element instanceof ContextAttribute || element instanceof TreeNode && DataLinkMappingHelper.resolve((TreeNode)element) instanceof ContextAttribute) && TreeListValidationService.isDuplicateName(item, parentItem, helper, columnProperty, name)) {
                isDuplicate = true;
            }
        }
        if (isDuplicate) {
            message = textPool.getText(2007, (Object)name);
            return new ValidationResult(message, 4);
        }
        if (element instanceof ContextNode && !item.isTopLevelItem() && item.isChecked() && item.isEnabled() && ContextService.isUniqueNodeWithinContext((String)name, (ContextNode)this.mData.getSourceController().getContext()) != null) {
            message = textPool.getText(2003, (Object)name);
            return new ValidationResult(message, 4);
        }
        return TreeListValidationService.OK_RESULT;
    }

    public boolean isEnabled(TreeListItem item, TreeListItemHelper helper) {
        Object element = item.getElement();
        TreeListItem sourceElementItem = helper.get(this.mData.getSourceNode());
        if (item.isTopLevelItem()) {
            return false;
        }
        if (element instanceof ContextRecursionNode) {
            return false;
        }
        if (element == this.mData.getSourceNode()) {
            return true;
        }
        if (this.mData.getIsReverseMappingMode()) {
            if (element instanceof TreeNode) {
                TreeNode node = (TreeNode)element;
                if (node.getData() != null && !((ContextElement)node.getData()).getIsInputElement()) {
                    return false;
                }
                if (node.getData() == null && node.getMappedObject() != null && !((ContextElement)node.getMappedObject()).getIsInputElement()) {
                    return false;
                }
                if (item.getProperties().getValue("Mapped element") == null) {
                    return false;
                }
                if (!helper.isDescendant(item, sourceElementItem)) {
                    return false;
                }
            }
        } else if (this.mData.isMergeMode()) {
            if (item.getProperties().getValue("Mapped element") == null) {
                return false;
            }
            if (!helper.isDescendant(item, sourceElementItem)) {
                return false;
            }
        } else if (element instanceof TreeNode) {
            return false;
        }
        return true;
    }

    private boolean hasStructureBinding(TreeListItem item) {
        Object candidate;
        Object itemElement = item.getElement();
        if (itemElement instanceof ContextElement) {
            ContextElement element = (ContextElement)itemElement;
            return CheckLayerHelper.hasStructureBinding((ContextElement)element);
        }
        if (itemElement instanceof TreeNode && (candidate = item.getProperties().getValue("Mapped element")) instanceof ContextElement) {
            return CheckLayerHelper.hasStructureBinding((ContextElement)((ContextElement)candidate));
        }
        return false;
    }

    public boolean isNode(TreeListItem item, TreeListItemHelper helper) {
        if (item.getElement() instanceof TreeNode) {
            TreeNode node = (TreeNode)item.getElement();
            return DataLinkMappingHelper.representsContextNode(node);
        }
        return item.getElement() instanceof AbstractContextNode;
    }

    public boolean isChecked(TreeListItem item, TreeListItemHelper helper) {
        Object element = item.getElement();
        if (element instanceof TreeNode) {
            TreeNode node = (TreeNode)element;
            return node.getMappedObject() != null && !node.isMappingDeleted();
        }
        return false;
    }
}

