/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.contextmapping;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.IPropertyProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.TreeNode;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.contextmapping.DataLinkMappingHelper;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;

public class DataLinkMappingPropertyProvider
implements IPropertyProvider {
    private ContextValueNode mSourceRoot;
    private TreeNode mSourceNode;
    private ContextElement mSourceElement;
    private ContextElement mTargetElement;
    private boolean mIsReverseMapping;
    private int mDirection;

    public DataLinkMappingPropertyProvider(ContextValueNode sourceRoot, TreeNode sourceNode, ContextElement targetElement, boolean isReverseMapping, int direction) {
        this.mSourceRoot = sourceRoot;
        this.mSourceNode = sourceNode;
        this.mTargetElement = targetElement;
        this.mIsReverseMapping = isReverseMapping;
        this.mDirection = direction;
        if (this.mSourceNode.getData() != null) {
            this.mSourceElement = (ContextElement)sourceNode.getData();
        }
    }

    public Object getValue(Object element, String name) {
        int index = -1;
        if (name == "Name") {
            index = 0;
        } else if (name == "Mapped element") {
            index = 1;
        }
        if (index > -1) {
            return this.getColumnValue(element, index);
        }
        return null;
    }

    public String getLabel(Object element, String name) {
        return this.getColumnText(this.getValue(element, name));
    }

    private Object getColumnValue(Object element, int columnIndex) {
        if (element instanceof TreeListItem) {
            TreeListItem item = (TreeListItem)element;
            return item.getProperties().getValue(columnIndex);
        }
        if (element instanceof TreeNode) {
            TreeNode node = (TreeNode)element;
            ContextElement contextElement = DataLinkMappingHelper.resolve(node);
            switch (columnIndex) {
                case 0: {
                    return node.getName();
                }
                case 1: {
                    if (this.mIsReverseMapping) {
                        return this.findMappingCandidate(node);
                    }
                    if (node == this.mSourceNode && this.mTargetElement != null) {
                        return this.mTargetElement;
                    }
                    return this.findMappingCandidate(node);
                }
            }
            return null;
        }
        if (element instanceof ContextElement) {
            ContextElement contextElement = (ContextElement)element;
            switch (columnIndex) {
                case 0: {
                    return contextElement.getName();
                }
                case 1: {
                    return contextElement;
                }
            }
            return null;
        }
        return null;
    }

    private String getColumnText(Object value) {
        if (value instanceof DevelopmentObject) {
            return ((DevelopmentObject)value).getName();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    private ContextElement findMappingCandidate(TreeNode sourceNode) {
        ContextElement candidate = null;
        ContextElement sourceElement = DataLinkMappingHelper.resolve(sourceNode);
        String name = sourceNode.getName();
        ContextValueNode targetContext = ((Controller)this.mTargetElement.getMDO()).getContext();
        if (sourceElement != null && sourceElement.equals(this.mSourceElement)) {
            candidate = this.mTargetElement;
        } else if (sourceNode != null && sourceNode == this.mSourceNode) {
            candidate = this.mTargetElement;
        } else if (sourceElement instanceof ContextNode || DataLinkMappingHelper.representsContextNode(sourceNode)) {
            candidate = ContextService.findContextNodeByName((String)name, (AbstractContextNode)targetContext);
        } else if (sourceElement instanceof ContextAttribute || DataLinkMappingHelper.representsContextAttribute(sourceNode)) {
            TreeNode sourceParentNode;
            Object targetParent = null;
            targetParent = sourceElement != null && sourceElement.getParent() != null && !sourceElement.getParent().isMDO() ? (sourceElement.getParent() == this.mSourceElement && this.mTargetElement instanceof ContextNode ? (ContextNode)this.mTargetElement : (ContextNode)ContextService.findContextNodeByName((String)sourceElement.getParent().getName(), (AbstractContextNode)targetContext)) : (sourceElement == null ? ((sourceParentNode = (TreeNode)sourceNode.getParent()) == this.mSourceNode ? (ContextNode)this.mTargetElement : (ContextNode)ContextService.findContextNodeByName((String)sourceParentNode.getName(), (AbstractContextNode)targetContext)) : targetContext);
            if (targetParent != null) {
                candidate = ContextService.findContextAttributeByName((String)name, (ContextNode)targetParent);
            }
        }
        return DataLinkMappingHelper.checkElementType(sourceElement, candidate);
    }
}

