/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.contextmapping;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.TreeNode;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.contextmapping.DataLinkMappingHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DataLinkMappingContentProvider
implements ITreeContentProvider {
    private ContextValueNode mSourceContext;
    private TreeNode mSourceNode;
    private ContextElement mTargetObject;
    private ITreeContentProvider mSourceContentProvider;
    private ITreeContentProvider mTargetContentProvider;
    private boolean mIsReverseMapping;
    private boolean mIsMergeMode = false;
    private int mDirection;
    private Map mForeignParents = new HashMap();

    public DataLinkMappingContentProvider(ContextValueNode sourceContext, TreeNode sourceNode, ContextElement targetElement, ITreeContentProvider sourceContentProvider, ITreeContentProvider targetContentProvider, boolean isReverseMapping, int direction) {
        this.mSourceContext = sourceContext;
        this.mSourceNode = sourceNode;
        this.mTargetObject = targetElement;
        this.mSourceContentProvider = sourceContentProvider;
        this.mTargetContentProvider = targetContentProvider;
        this.mIsReverseMapping = isReverseMapping;
        this.mDirection = direction;
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.mIsMergeMode && !this.mIsReverseMapping) {
            children.addAll(this.doMerge(parentElement));
        } else {
            if (!this.mIsReverseMapping && parentElement == this.mSourceNode) {
                children.addAll(Arrays.asList(this.mTargetContentProvider.getChildren((Object)this.mTargetObject)));
            }
            if (parentElement instanceof TreeNode) {
                children.addAll(Arrays.asList(this.mSourceContentProvider.getChildren(parentElement)));
            } else if (parentElement instanceof ContextElement) {
                children.addAll(Arrays.asList(this.mTargetContentProvider.getChildren(parentElement)));
            }
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        Object parent = null;
        if (element instanceof TreeNode) {
            parent = this.mSourceContentProvider.getParent(element);
        } else if (!this.mIsReverseMapping) {
            parent = this.mTargetContentProvider.getParent(element);
        }
        if (parent == this.mTargetObject) {
            parent = this.mSourceNode;
        }
        if (this.mForeignParents.containsKey(element)) {
            parent = this.mForeignParents.get(element);
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.addAll(Arrays.asList(this.mSourceContentProvider.getElements((Object)this.mSourceContext)));
        if (!this.mIsReverseMapping && elements.contains(this.mSourceNode)) {
            if (this.mDirection == 1) {
                elements.addAll(Arrays.asList(this.mTargetContentProvider.getChildren((Object)this.mTargetObject)));
            } else if (this.mDirection == 2) {
                elements.add(this.mTargetObject);
            }
        }
        return elements.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.mForeignParents.clear();
    }

    public void setMergeMode(boolean mergeMode) {
        this.mIsMergeMode = mergeMode;
    }

    private List doMerge(Object parent) {
        ArrayList<Object> results = new ArrayList<Object>();
        ContextElement targetParent = null;
        if (parent instanceof TreeNode) {
            TreeNode parentNode = (TreeNode)parent;
            Object[] sourceChildren = this.mSourceContentProvider.getChildren(parent);
            results.addAll(Arrays.asList(sourceChildren));
            if (this.isDescendantOfSourceNode(parentNode) && (targetParent = DataLinkMappingHelper.findMappingCandidate(parentNode, this.mSourceNode, this.mTargetObject)) != null) {
                Object[] targetChildren = this.mTargetContentProvider.getChildren((Object)targetParent);
                int i = 0;
                while (i < targetChildren.length) {
                    boolean foundInSource;
                    ContextElement element = (ContextElement)targetChildren[i];
                    boolean foundInTarget = DataLinkMappingHelper.findMappingCandidate(element, parentNode, targetParent) != null;
                    boolean bl = foundInSource = DataLinkMappingHelper.findInSource(element, targetParent, parentNode) != null;
                    if (foundInTarget && !foundInSource && this.isHierarchyCorrect(parentNode, element)) {
                        results.add(element);
                        this.mForeignParents.put(element, parentNode);
                    }
                    ++i;
                }
            }
        } else {
            Object[] targetChildren = this.mTargetContentProvider.getChildren(parent);
            results.addAll(Arrays.asList(targetChildren));
        }
        return results;
    }

    private boolean isHierarchyCorrect(TreeNode sourceParentNode, ContextElement target) {
        if (sourceParentNode != this.mSourceNode && target.getParent() != null) {
            if (!sourceParentNode.getName().equalsIgnoreCase(target.getParent().getName())) {
                return false;
            }
            Object sourceParentObject = sourceParentNode.getParent();
            DevelopmentObject targetParent = target.getParent();
            if (sourceParentObject != null && targetParent != null && sourceParentObject instanceof TreeNode && targetParent instanceof ContextElement && !this.isHierarchyCorrect((TreeNode)sourceParentObject, (ContextElement)targetParent)) {
                return false;
            }
        }
        return true;
    }

    private boolean isDescendantOfSourceNode(TreeNode node) {
        if (node == this.mSourceNode) {
            return true;
        }
        Object parent = this.getParent(node);
        if (parent instanceof TreeNode) {
            return this.isDescendantOfSourceNode((TreeNode)parent);
        }
        return false;
    }
}

