/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.IContextNodeValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.TreeNode;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.WizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.contextmapping.DataLinkMappingHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.contextmapping.PageDataLinkContextMapping;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.modelbinding.DataLinkBindingHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.modelbinding.PageDataLinkModelBinding;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.provider.DataLinkContentProvider;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class DataLinkMappingWizard
extends Wizard
implements IContextNodeValidator {
    private WizardData mData;
    private IWizardPage mPage;

    public DataLinkMappingWizard(IWizardContainer hostContainer) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(TextPool.getInstance().getText(2307));
        this.setDefaultPageImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_CONTEXT_MAPPING_BANNER));
        this.mData = new WizardData();
        this.mData.setHostContainer(hostContainer);
    }

    public void addPages() {
        this.mPage = this.mData.getTargetObject() instanceof ContextElement ? new PageDataLinkContextMapping(this.mData) : new PageDataLinkModelBinding(this.mData);
        this.addPage(this.mPage);
    }

    public boolean performFinish() {
        if (this.mPage instanceof PageDataLinkContextMapping) {
            DataLinkMappingHelper.getInstance(this.mData).convertToTreeNodes();
        } else if (this.mPage instanceof PageDataLinkModelBinding) {
            DataLinkBindingHelper.getInstance(this.mData).convertToTreeNodes();
        }
        return true;
    }

    public void initialize(DataLinkContentProvider contentProvider, TreeNode sourceNode, DevelopmentObject targetObject, int direction, boolean isReverseMapping) {
        this.mData.setContentProvider(contentProvider);
        this.mData.setSourceNode(sourceNode);
        this.mData.setTargetObject(targetObject);
        this.mData.setDirection(direction);
        this.mData.setIsReverseMappingMode(isReverseMapping);
        Controller sourceController = this.getController(sourceNode, contentProvider);
        if (sourceController != null) {
            this.mData.setSourceController(sourceController);
            this.mData.setControllerUsages(sourceController.getOutgoingControllerUsages());
        }
    }

    public DataLinkContentProvider getTree() {
        return this.mData.getContentProvider();
    }

    private Controller getController(TreeNode sourceNode, ITreeContentProvider treeNodeProvider) {
        Object parent = sourceNode;
        while (parent != null && treeNodeProvider != null) {
            DevelopmentObject data = ((TreeNode)parent).getData();
            if (data != null && data.getMDO() instanceof Controller) {
                return (Controller)data.getMDO();
            }
            parent = treeNodeProvider.getParent(parent);
        }
        return null;
    }
}

