/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.datalink;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElementMapping;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.tools.core.treemappingcomponent.MappingObject;
import com.sap.ide.tools.core.treemappingcomponent.TreeMappingValidator;
import com.sap.ide.tools.core.treemappingcomponent.decorator.LinkDecorator;
import com.sap.ide.tools.core.treemappingcomponent.filter.DrawingAreaFilter;
import com.sap.ide.tools.core.treemappingcomponent.filter.TreeMappingFilter;
import com.sap.ide.tools.core.treemappingcomponent.listener.DragDropListener;
import com.sap.ide.tools.core.treemappingcomponent.listener.DragDropValidator;
import com.sap.ide.tools.core.treemappingcomponent.listener.TreeMappingListener;
import com.sap.ide.tools.core.treemappingcomponent.tree.TreeMappingComposite;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.context.ContextContentProvider;
import com.sap.ide.webdynpro.controllereditor.context.ContextElementSorter;
import com.sap.ide.webdynpro.controllereditor.context.ContextLabelProvider;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelContentProvider;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.DataLinkDecorator;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.DataLinkFilter;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.DataLinkMappingListener;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.DataLinkValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.TreeDragDropListener;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.TreeNode;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.TreeNodeModelSorter;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.TreeNodeRFCModelSorter;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.TreeNodeSorter;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.createdialog.CreateElementWizard;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.createdialog.CreateElementWizardDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.filter.DeletedNodeFilter;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.provider.DataLinkContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.provider.DataLinkLabelProvider;
import com.sap.ide.webdynpro.service.controllereditor.ComponentAndControllerStorage;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.context.ServicesCreation;
import com.sap.ide.webdynpro.service.controllereditor.context.ServicesDeletion;
import com.sap.ide.webdynpro.service.controllereditor.usage.ControllerUsageService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class DataLinkWizardPage
extends WizardPage {
    private DevelopmentObject mSource;
    private DevelopmentObject mTarget;
    private TreeMappingComposite mTreeMappingComposite;
    private Controller mSourceController;
    private DataLinkContentProvider mSourceTreeContentProvider = null;
    private ControllerUsage mControllerUsage = null;
    private ComponentUsage mComponentUsage = null;
    private Controller mTargetController = null;
    private boolean mIsReverseMapping = false;
    private IAction mAddValueNodeAction;
    private IAction mAddValueAttributeAction;
    private IAction mAddModelNodeAction;
    private IAction mAddModelAttributeAction;
    private IAction mAddRecursionNodeAction;
    private IAction mDeleteAction;
    boolean mIsNew = false;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueNode;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelNode;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute;

    public DataLinkWizardPage(DevelopmentObject source, DevelopmentObject target) {
        super("DataLinkWizardPage");
        this.mSource = source;
        this.mTarget = target;
        if (source instanceof ComponentControllerUsage) {
            this.mIsReverseMapping = true;
        }
        if (this.mTarget instanceof Model) {
            this.setTitle(TextPool.getInstance().getText(2311));
            this.setDescription(TextPool.getInstance().getText(2522));
        } else {
            this.setTitle(TextPool.getInstance().getText(2308));
            if (this.mIsReverseMapping) {
                this.setDescription(TextPool.getInstance().getText(2523));
            } else if (source instanceof Controller) {
                ControllerTypeEnum type = ((Controller)source).getType();
                if (type == ControllerTypeEnum.COMPONENT_INTERFACE || type == ControllerTypeEnum.COMPONENT_CONFIGURATION) {
                    this.setDescription(TextPool.getInstance().getText(2524));
                } else {
                    this.setDescription(TextPool.getInstance().getText(2521));
                }
            } else if (source instanceof View) {
                this.setDescription(TextPool.getInstance().getText(2521));
            }
        }
    }

    private void setTargetUsage() {
        block6: {
            block7: {
                block5: {
                    if (this.mTargetController == null) {
                        return;
                    }
                    if (!this.mIsReverseMapping) break block5;
                    ComponentControllerUsage compControllerUsage = (ComponentControllerUsage)this.mSource;
                    ControllerUsage[] usages = compControllerUsage.getOutgoingControllerUsages();
                    int i = 0;
                    while (i < usages.length) {
                        ControllerUsage usage = usages[i];
                        if (usage.hasUsedController() && usage.getUsedController().equals(this.mTargetController)) {
                            this.mComponentUsage = compControllerUsage.getComponentUsage();
                            this.mControllerUsage = usage;
                        }
                        ++i;
                    }
                    break block6;
                }
                if (!(this.mTarget instanceof ControllerUsage)) break block7;
                this.mControllerUsage = (ControllerUsage)this.mTarget;
                if (!this.mControllerUsage.hasComponentUsage()) break block6;
                this.mComponentUsage = this.mControllerUsage.getComponentUsage();
                break block6;
            }
            ControllerUsage[] usages = this.mSourceController.getOutgoingControllerUsages();
            int i = 0;
            while (i < usages.length) {
                Controller controller;
                ControllerUsage usage = usages[i];
                if (usage.hasUsedController() && (controller = usage.getUsedController()).equals(this.mTargetController)) {
                    this.mControllerUsage = usage;
                }
                ++i;
            }
        }
    }

    public void createControl(Composite parent) {
        try {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new FillLayout());
            this.mTargetController = null;
            Model targetModel = null;
            boolean isTargetModel = false;
            DataLinkLabelProvider sourceLabelProvider = null;
            LabelProvider targetLabelProvider = null;
            ContextElementSorter contextElementSorter = new ContextElementSorter();
            TreeNodeSorter treeNodeSorter = new TreeNodeSorter(contextElementSorter);
            this.mSourceController = this.getController(this.mSource, true);
            this.mSourceTreeContentProvider = new DataLinkContentProvider();
            sourceLabelProvider = new DataLinkLabelProvider(this.getSourceUsages(), this.mIsReverseMapping, true);
            if (this.mTarget instanceof Model) {
                targetModel = (Model)this.mTarget;
                isTargetModel = true;
                targetLabelProvider = new ModelLabelProvider();
            } else {
                this.mTargetController = this.getController(this.mTarget, false);
                this.checkControllerUsage();
                targetLabelProvider = new ContextLabelProvider(this.mTargetController.getOutgoingControllerUsages(), false, true, false);
            }
            DataLinkMappingListener mappingListener = new DataLinkMappingListener(this, this.mSourceTreeContentProvider, this.mIsReverseMapping, 0x2000000, this.mSourceController, this.mTargetController, this.mSource);
            DataLinkMappingListener reverseMappingListener = new DataLinkMappingListener(this, this.mSourceTreeContentProvider, this.mIsReverseMapping, 0x4000000, this.mSourceController, this.mTargetController, this.mSource);
            this.mSourceTreeContentProvider.setControllerUsages(this.getSourceUsages());
            this.mTreeMappingComposite = new TreeMappingComposite(composite, 0);
            this.mTreeMappingComposite.setLayout((Layout)new FillLayout());
            this.mTreeMappingComposite.setLabelProvider((ILabelProvider)sourceLabelProvider, (ILabelProvider)targetLabelProvider);
            this.mTreeMappingComposite.setValidator((TreeMappingValidator)new DataLinkValidator(this));
            this.mTreeMappingComposite.setLeftTreeHeader(this.mSourceController.getName() + " - " + this.mSourceController.getPackage(), 0x1000000);
            this.mTreeMappingComposite.addMappingListener((TreeMappingListener)mappingListener);
            this.mTreeMappingComposite.setDragDropValidator(0x2000000, (DragDropValidator)mappingListener);
            this.mTreeMappingComposite.setExpandLevel(2, 2);
            this.setDragDropStyles();
            this.mTreeMappingComposite.setEnableDragDrop(true);
            if (!this.mIsReverseMapping) {
                this.mTreeMappingComposite.setEnableDragDrop(0x4000000, true);
                this.mTreeMappingComposite.setDragDropValidator(0x4000000, (DragDropValidator)reverseMappingListener);
            }
            this.mTreeMappingComposite.setLinkDecorator((LinkDecorator)new DataLinkDecorator());
            this.mTreeMappingComposite.setContentProvider((ITreeContentProvider)this.mSourceTreeContentProvider, null);
            this.mTreeMappingComposite.setSorter((ViewerSorter)treeNodeSorter, null);
            this.mTreeMappingComposite.addDragDropListener((DragDropListener)new TreeDragDropListener(this));
            this.mTreeMappingComposite.setFilter((TreeMappingFilter)new DeletedNodeFilter(), null);
            if (isTargetModel) {
                this.mTreeMappingComposite.setContentProvider(null, (ITreeContentProvider)new ModelContentProvider());
                if (MetamodelServices.hasModelTypeRfcAdapter((Model)targetModel)) {
                    this.mTreeMappingComposite.setSorter(null, (ViewerSorter)new TreeNodeRFCModelSorter(targetModel));
                } else {
                    this.mTreeMappingComposite.setSorter(null, (ViewerSorter)new TreeNodeModelSorter(targetModel));
                }
                this.mTreeMappingComposite.setInput((Object)this.mSourceController.getContext(), (Object)new ModelContentProvider.ModelRoot((DevelopmentObject)targetModel));
                this.mTreeMappingComposite.setRightTreeHeader(targetModel.getName(), 0x1000000);
                this.mTreeMappingComposite.setEnableMappingContextMenu(false);
            } else {
                this.mTreeMappingComposite.setContentProvider(null, (ITreeContentProvider)new ContextContentProvider());
                this.mTreeMappingComposite.setSorter(null, (ViewerSorter)treeNodeSorter);
                this.mTreeMappingComposite.setInput((Object)this.mSourceController.getContext(), (Object)new ContextContentProvider.ContextRoot((ContextElement)this.mTargetController.getContext()));
                this.mTreeMappingComposite.setRightTreeHeader(this.mTargetController.getName() + " - " + this.mTargetController.getPackage(), 0x1000000);
                this.mTreeMappingComposite.setEnableMappingContextMenu(true);
            }
            this.mTreeMappingComposite.setDrawingAreaFilter((DrawingAreaFilter)new DataLinkFilter());
            this.setTargetUsage();
            this.createExistingDataLinks();
            this.expandVisibleLinks();
            Object[] elements = this.mSourceTreeContentProvider.getElements(null);
            mappingListener.setRoot((TreeNode)elements[0]);
            this.mTreeMappingComposite.setVisibleExtensionLine(true);
            composite.setSize(350, 1000);
            this.createActions();
            this.addContextMenu();
            this.setControl((Control)composite);
        }
        catch (Exception e) {
            Plugin.internalError(((Object)((Object)this)).getClass(), "createControl", "Exception while creating mapping control", e, false);
        }
    }

    private void setDragDropStyles() {
        this.mTreeMappingComposite.setDragCursorType(0x2000000, 4);
        this.mTreeMappingComposite.setDragCursorType(0x4000000, 1);
    }

    private void addContextMenu() {
        if (this.mIsReverseMapping) {
            return;
        }
        this.mTreeMappingComposite.addMenuListener(new IMenuListener(){
            static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute;
            static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute;

            public void menuAboutToShow(IMenuManager manager) {
                Object[] items = DataLinkWizardPage.this.mTreeMappingComposite.getSelectedItems(16384);
                if (items.length != 1) {
                    return;
                }
                TreeNode selectedNode = (TreeNode)items[0];
                Class data = selectedNode.getNodeType();
                if (data == null) {
                    return;
                }
                if (data.equals(class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute == null ? (class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute = 1.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute")) : class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute) || data.equals(class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute == null ? (class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute = 1.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute")) : class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute)) {
                    manager.add(DataLinkWizardPage.this.mDeleteAction);
                    return;
                }
                MenuManager subManager = new MenuManager(CoreTextPool.getInstance().getText(152));
                manager.add((IContributionItem)subManager);
                subManager.add(DataLinkWizardPage.this.mAddValueNodeAction);
                subManager.add(DataLinkWizardPage.this.mAddValueAttributeAction);
                subManager.add(DataLinkWizardPage.this.mAddModelNodeAction);
                subManager.add(DataLinkWizardPage.this.mAddModelAttributeAction);
                manager.add((IContributionItem)new Separator());
                manager.add(DataLinkWizardPage.this.mDeleteAction);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }, 16384);
    }

    private void expandVisibleLinks() {
        if (null == this.mSourceController) {
            return;
        }
        if (null == this.mSourceController.getContext()) {
            return;
        }
    }

    private void expandVisibleLinks(Object[] childNodes) {
        int i = 0;
        while (i < childNodes.length) {
            Object[] mappingObjects = this.mTreeMappingComposite.getMappings(childNodes[i]);
            int j = 0;
            while (j < mappingObjects.length) {
                Object target = mappingObjects[j];
                if (target instanceof DevelopmentObject) {
                    target = ((DevelopmentObject)target).getParent();
                }
                if (null != target) {
                    this.mTreeMappingComposite.expand(131072, target);
                }
                ++j;
            }
            if (childNodes[i] instanceof TreeNode) {
                TreeNode node = (TreeNode)childNodes[i];
                this.expandVisibleLinks(node.getChildren());
            }
            ++i;
        }
    }

    private void createExistingDataLinks() {
        if (null == this.mSourceController || null == this.mSourceController.getContext()) {
            return;
        }
        ContextValueNode context = this.mSourceController.getContext();
        ControllerUsage[] usages = null;
        usages = this.getSourceUsages();
        this.drawLinks(this.mSourceTreeContentProvider.getElements(context), this.mControllerUsage);
    }

    private void drawLinks(Object[] childNodes, ControllerUsage controllerUsage) {
        int i = 0;
        while (i < childNodes.length) {
            ContextModelAttribute modelAttribute;
            ModelClassProperty property;
            TreeNode treeNode = (TreeNode)childNodes[i];
            ContextElement node = (ContextElement)treeNode.getData();
            if (node instanceof ContextModelNode) {
                ContextModelNode modelNode = (ContextModelNode)node;
                if (modelNode.hasModelClass()) {
                    ModelClass modelClass = modelNode.getModelClass();
                    ModelRelationRole role = modelNode.getSupplyingRelationRole();
                    if (null != role) {
                        this.mTreeMappingComposite.createLink((Object)treeNode, (Object)modelNode.getSupplyingRelationRole());
                    } else {
                        this.mTreeMappingComposite.createLink((Object)treeNode, (Object)modelClass);
                    }
                }
            } else if (node instanceof ContextModelAttribute && (property = CheckLayerHelper.getReferencedProperty((ContextModelAttribute)(modelAttribute = (ContextModelAttribute)node), (boolean)true)) != null) {
                this.mTreeMappingComposite.createLink((Object)treeNode, (Object)property);
            }
            if (controllerUsage != null) {
                ControllerUsage[] controllerUsages = new ControllerUsage[]{controllerUsage};
                ContextElementMapping mapping = CheckLayerHelper.getMapping((ContextElement)node, (ControllerUsage[])controllerUsages);
                ContextElement ele = CheckLayerHelper.getMappedElement((ContextElement)node, (ControllerUsage[])controllerUsages);
                if (null != mapping && mapping.hasMappedElement()) {
                    ContextElement mappedElement = mapping.getMappedElement();
                    this.mTreeMappingComposite.createLink((Object)treeNode, (Object)mappedElement);
                }
            }
            if (treeNode.hasChildren()) {
                this.drawLinks(treeNode.getChildren(), controllerUsage);
            }
            ++i;
        }
    }

    private Controller getController(DevelopmentObject devObj, boolean isSource) {
        if (devObj instanceof View) {
            return ((View)devObj).getViewController();
        }
        if (devObj instanceof Controller) {
            return (Controller)devObj;
        }
        if (devObj instanceof ControllerUsage) {
            return ((ControllerUsage)devObj).getUsedController();
        }
        if (devObj instanceof ComponentControllerUsage) {
            if (isSource) {
                this.mIsReverseMapping = true;
            }
            return ((ComponentControllerUsage)devObj).getUsedComponentController();
        }
        return null;
    }

    public void clearErrorMessage() {
        this.setErrorMessage(null);
    }

    public boolean finish() {
        TreeNode root = this.mSourceTreeContentProvider.getRoot();
        this.commit(root);
        return true;
    }

    private void checkControllerUsage() {
        block13: {
            try {
                if (this.mIsReverseMapping) {
                    if (null != this.mComponentUsage) break block13;
                    ComponentControllerUsage componentControllerUsage = (ComponentControllerUsage)this.mSource;
                    ControllerUsage[] usages = componentControllerUsage.getOutgoingControllerUsages();
                    ComponentUsage componentUsage = componentControllerUsage.getComponentUsage();
                    int i = 0;
                    while (i < usages.length) {
                        ControllerUsage usage = usages[i];
                        if (usage.getUsedController().equals(this.mTargetController)) {
                            this.mComponentUsage = componentUsage;
                            return;
                        }
                        ++i;
                    }
                    WebDynproRoot webDynproRoot = null;
                    webDynproRoot = (WebDynproRoot)this.mTargetController.getRoot();
                    try {
                        webDynproRoot.disableAutoNotify();
                        ComponentAndControllerStorage storage = this.mTarget instanceof ComponentControllerUsage ? new ComponentAndControllerStorage(((ComponentControllerUsage)this.mTarget).getComponentUsage(), this.mTargetController) : new ComponentAndControllerStorage(this.mTargetController);
                        ControllerUsageService.createControllerUsage((ComponentAndControllerStorage)storage, (ComponentControllerUsage)componentControllerUsage);
                        this.mIsNew = true;
                        Object var8_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_14 = null;
                        webDynproRoot.notifyObservers();
                        webDynproRoot.enableAutoNotify();
                        throw throwable;
                    }
                    webDynproRoot.notifyObservers();
                    webDynproRoot.enableAutoNotify();
                    {
                        break block13;
                    }
                }
                if (null != this.mControllerUsage) break block13;
                ControllerUsage[] usages = this.mSourceController.getOutgoingControllerUsages();
                int i = 0;
                while (i < usages.length) {
                    ControllerUsage usage = usages[i];
                    if (usage.hasUsedController() && usage.getUsedController().equals(this.mTargetController)) {
                        return;
                    }
                    ++i;
                }
                WebDynproRoot webDynproRoot = null;
                webDynproRoot = (WebDynproRoot)this.mTargetController.getRoot();
                try {
                    webDynproRoot.disableAutoNotify();
                    ComponentAndControllerStorage storage = null;
                    if (this.mTarget instanceof ComponentControllerUsage) {
                        ComponentControllerUsage compContUsage = (ComponentControllerUsage)this.mTarget;
                        storage = new ComponentAndControllerStorage(compContUsage.getComponentUsage(), this.mTargetController);
                    } else {
                        storage = new ComponentAndControllerStorage(this.mTargetController);
                    }
                    ControllerUsageService.createControllerUsage((ComponentAndControllerStorage)storage, (Controller)this.mSourceController);
                    this.mIsNew = true;
                    Object var10_16 = null;
                }
                catch (Throwable throwable) {
                    Object var10_17 = null;
                    webDynproRoot.notifyObservers();
                    webDynproRoot.enableAutoNotify();
                    throw throwable;
                }
                webDynproRoot.notifyObservers();
                webDynproRoot.enableAutoNotify();
                {
                }
            }
            catch (Exception ex) {
                Plugin.internalError(((Object)((Object)this)).getClass(), "checkControllerUsage", ex.getMessage(), ex, true);
            }
        }
    }

    public void reloadSourceTree() {
        Object[] expandedNodes = this.mTreeMappingComposite.getExpandedElements(16384);
        this.mTreeMappingComposite.reloadTree(16384);
        int i = 0;
        while (i < expandedNodes.length) {
            this.mTreeMappingComposite.expand(16384, expandedNodes[i]);
            ++i;
        }
    }

    public void deleteLink(MappingObject mappingObject) {
        this.mTreeMappingComposite.deleteLink(mappingObject);
    }

    private void commit(TreeNode root) {
        Object[] children = root.getAllChildren();
        int i = 0;
        while (i < children.length) {
            block30: {
                TreeNode child;
                block33: {
                    DevelopmentObject mappedObject;
                    block31: {
                        ContextValueNode newNode;
                        block42: {
                            block41: {
                                block40: {
                                    block39: {
                                        ContextValueAttribute element;
                                        block38: {
                                            block37: {
                                                block36: {
                                                    block35: {
                                                        block34: {
                                                            block32: {
                                                                block29: {
                                                                    child = (TreeNode)children[i];
                                                                    if (!child.isDeleted()) break block29;
                                                                    this.deleteNode(child);
                                                                    break block30;
                                                                }
                                                                if (!child.isIsNew()) break block31;
                                                                mappedObject = child.getMappedObject();
                                                                if (!(mappedObject instanceof ContextValueAttribute)) break block32;
                                                                element = ServicesCreation.createAttributeAsContextValueAttribute((ContextNode)((ContextNode)root.getData()), (String)child.getName());
                                                                child.setData((DevelopmentObject)element);
                                                                if (!child.isMappingDeleted()) {
                                                                    ServicesCreation.createContextValueAttributeMapping((ContextValueAttribute)element, (ControllerUsage[])this.getSourceUsages(), (ContextValueAttribute)((ContextValueAttribute)child.getMappedObject()), (ControllerUsage)this.mControllerUsage, (boolean)this.mIsReverseMapping);
                                                                }
                                                                break block33;
                                                            }
                                                            if (!(mappedObject instanceof ContextValueNode)) break block34;
                                                            element = ServicesCreation.createChildNodeAsContextValueNode((ContextNode)((ContextNode)root.getData()), (String)child.getName());
                                                            child.setData((DevelopmentObject)element);
                                                            if (!child.isMappingDeleted()) {
                                                                ServicesCreation.createContextValueNodeMapping((ContextValueNode)((ContextValueNode)element), (ControllerUsage[])this.getSourceUsages(), (ContextValueNode)((ContextValueNode)child.getMappedObject()), (ControllerUsage)this.mControllerUsage, (boolean)this.mIsReverseMapping);
                                                            }
                                                            if (child.isIsNew()) {
                                                                child.setData((DevelopmentObject)element);
                                                            }
                                                            break block33;
                                                        }
                                                        if (!(mappedObject instanceof ContextModelAttribute)) break block35;
                                                        element = ServicesCreation.createAttributeAsContextModelAttribute((ContextNode)((ContextNode)root.getData()), (String)child.getName());
                                                        child.setData((DevelopmentObject)element);
                                                        if (!child.isMappingDeleted()) {
                                                            if (this.mIsReverseMapping) {
                                                                ServicesCreation.createContextModelAttributeMapping((ContextModelAttribute)((ContextModelAttribute)element), (ControllerUsage[])this.mSourceController.getOutgoingControllerUsages(), (ContextModelAttribute)((ContextModelAttribute)child.getMappedObject()), (ControllerUsage)this.mControllerUsage, (boolean)this.mIsReverseMapping);
                                                            } else {
                                                                ServicesCreation.createContextModelAttributeMapping((ContextModelAttribute)((ContextModelAttribute)element), (ControllerUsage[])this.mSourceController.getOutgoingControllerUsages(), (ContextModelAttribute)((ContextModelAttribute)child.getMappedObject()), (ControllerUsage)this.mControllerUsage, (boolean)this.mIsReverseMapping);
                                                            }
                                                        }
                                                        break block33;
                                                    }
                                                    if (!(mappedObject instanceof ContextModelNode)) break block36;
                                                    element = ServicesCreation.createChildNodeAsContextModelNode((ContextNode)((ContextNode)root.getData()), (String)child.getName());
                                                    child.setData((DevelopmentObject)element);
                                                    if (!child.isMappingDeleted()) {
                                                        ServicesCreation.createContextModelNodeMapping((ContextModelNode)((ContextModelNode)element), (ControllerUsage[])this.getSourceUsages(), (ContextModelNode)((ContextModelNode)child.getMappedObject()), (ControllerUsage)this.mControllerUsage, (boolean)this.mIsReverseMapping);
                                                    }
                                                    if (child.isIsNew()) {
                                                        child.setData((DevelopmentObject)element);
                                                    }
                                                    break block33;
                                                }
                                                if (!(mappedObject instanceof ModelRelationRole)) break block37;
                                                element = ServicesCreation.createChildNodeAsContextModelNode((ContextNode)((ContextNode)root.getData()), (String)child.getName());
                                                child.setData((DevelopmentObject)element);
                                                if (!child.isMappingDeleted()) {
                                                    ServicesCreation.createModelBinding((ContextModelNode)((ContextModelNode)element), (ModelRelationRole)((ModelRelationRole)mappedObject));
                                                }
                                                break block33;
                                            }
                                            if (!(mappedObject instanceof ModelClass)) break block38;
                                            element = ServicesCreation.createChildNodeAsContextModelNode((ContextNode)((ContextNode)root.getData()), (String)child.getName());
                                            child.setData((DevelopmentObject)element);
                                            if (!child.isMappingDeleted()) {
                                                ServicesCreation.createModelBinding((ContextModelNode)((ContextModelNode)element), (ModelClass)((ModelClass)mappedObject));
                                            }
                                            break block33;
                                        }
                                        if (!(mappedObject instanceof ModelClassProperty)) break block39;
                                        element = ServicesCreation.createAttributeAsContextModelAttribute((ContextNode)((ContextNode)root.getData()), (String)child.getName());
                                        child.setData(mappedObject);
                                        if (!child.isMappingDeleted()) {
                                            ServicesCreation.createModelBinding((ContextModelAttribute)((ContextModelAttribute)element), (Property)((ModelClassProperty)mappedObject));
                                        }
                                        break block33;
                                    }
                                    if (mappedObject != null) break block33;
                                    newNode = null;
                                    if (!child.getNodeType().equals(class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueNode == null ? DataLinkWizardPage.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode") : class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueNode)) break block40;
                                    newNode = ServicesCreation.createChildNodeAsContextValueNode((ContextNode)((ContextNode)root.getData()), (String)child.getName());
                                    child.setData((DevelopmentObject)newNode);
                                    break block33;
                                }
                                if (!child.getNodeType().equals(class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute == null ? DataLinkWizardPage.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute") : class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute)) break block41;
                                newNode = ServicesCreation.createAttributeAsContextValueAttribute((ContextNode)((ContextNode)root.getData()), (String)child.getName());
                                child.setData((DevelopmentObject)newNode);
                                break block33;
                            }
                            if (!child.getNodeType().equals(class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelNode == null ? DataLinkWizardPage.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode") : class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelNode)) break block42;
                            newNode = ServicesCreation.createChildNodeAsContextModelNode((ContextNode)((ContextNode)root.getData()), (String)child.getName());
                            child.setData((DevelopmentObject)newNode);
                            break block33;
                        }
                        if (!child.getNodeType().equals(class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute == null ? DataLinkWizardPage.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute") : class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute)) break block33;
                        newNode = ServicesCreation.createAttributeAsContextModelAttribute((ContextNode)((ContextNode)root.getData()), (String)child.getName());
                        child.setData((DevelopmentObject)newNode);
                        break block33;
                    }
                    if (!child.isIsNew() && child.isDirty()) {
                        mappedObject = child.getMappedObject();
                        DevelopmentObject devObj = child.getData();
                        ContextElement element = (ContextElement)devObj;
                        ServicesDeletion.deleteMapping((ContextElement)element, (ControllerUsage[])this.getSourceUsages(), (!this.mIsReverseMapping ? 1 : 0) != 0, (boolean)false);
                        if (!child.isMappingDeleted()) {
                            if (mappedObject instanceof ContextValueAttribute) {
                                ServicesCreation.createContextMapping((ContextElement)((ContextValueAttribute)element), (ControllerUsage[])this.getSourceUsages(), (ContextElement)((ContextValueAttribute)child.getMappedObject()), (ControllerUsage)this.mControllerUsage, (boolean)this.mIsReverseMapping);
                            } else if (mappedObject instanceof ContextValueNode) {
                                ServicesCreation.createContextValueNodeMapping((ContextValueNode)((ContextValueNode)element), (ControllerUsage[])this.getSourceUsages(), (ContextValueNode)((ContextValueNode)child.getMappedObject()), (ControllerUsage)this.mControllerUsage, (boolean)this.mIsReverseMapping);
                            } else if (mappedObject instanceof ContextModelNode) {
                                ServicesCreation.createContextModelNodeMapping((ContextModelNode)((ContextModelNode)element), (ControllerUsage[])this.getSourceUsages(), (ContextModelNode)((ContextModelNode)child.getMappedObject()), (ControllerUsage)this.mControllerUsage, (boolean)this.mIsReverseMapping);
                            } else if (mappedObject instanceof ContextModelAttribute) {
                                ServicesCreation.createContextModelAttributeMapping((ContextModelAttribute)((ContextModelAttribute)element), (ControllerUsage[])this.getSourceUsages(), (ContextModelAttribute)((ContextModelAttribute)child.getMappedObject()), (ControllerUsage)this.mControllerUsage, (boolean)this.mIsReverseMapping);
                            } else if (mappedObject instanceof ModelClass) {
                                ServicesCreation.createModelBinding((ContextModelNode)((ContextModelNode)element), (ModelClass)((ModelClass)mappedObject));
                            } else if (mappedObject instanceof ModelClassProperty) {
                                ServicesCreation.createModelBinding((ContextModelAttribute)((ContextModelAttribute)element), (Property)((ModelClassProperty)mappedObject));
                            } else if (mappedObject instanceof ModelRelationRole) {
                                ServicesCreation.createModelBinding((ContextModelNode)((ContextModelNode)element), (ModelRelationRole)((ModelRelationRole)mappedObject));
                                ModelRelationRole[] roles = CheckLayerHelper.getValidSupplyingRelationRoles((ContextModelNode)((ContextModelNode)element), (boolean)true);
                                int j = 0;
                                while (j < roles.length) {
                                    ModelRelationRole role = roles[j];
                                    String name = role.getName();
                                    ++j;
                                }
                            }
                        }
                    }
                }
                if (child.hasChildren()) {
                    this.commit(child);
                }
            }
            ++i;
        }
    }

    private void deleteNode(TreeNode child) {
        if (child.isIsNew()) {
            return;
        }
        DevelopmentObject data = child.getData();
        if (null == data) {
            return;
        }
        if (data instanceof ContextAttribute) {
            ServicesDeletion.deleteAttribute((ContextAttribute)((ContextAttribute)data), (ControllerUsage[])this.getSourceUsages());
        } else if (data instanceof ContextNode) {
            ServicesDeletion.deleteNode((AbstractContextNode)((AbstractContextNode)data), (ControllerUsage[])this.getSourceUsages());
        }
    }

    public void createMapping(TreeNode source, DevelopmentObject target) {
        this.mTreeMappingComposite.createLink((Object)source, (Object)target);
    }

    public void deleteLink(TreeNode source, Object target) {
        this.mTreeMappingComposite.deleteLink((Object)source, target, false);
    }

    public boolean performCancel() {
        if (this.mIsNew && this.mControllerUsage != null) {
            if (this.mIsReverseMapping) {
                ControllerUsageService.deleteControllerUsage((ControllerUsage)this.mControllerUsage);
            } else {
                ControllerUsageService.deleteControllerUsage((ControllerUsage)this.mControllerUsage);
            }
        }
        return true;
    }

    private void createActions() {
        this.mAddValueNodeAction = new Action(TextPool.getInstance().getText(2204)){
            static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueNode;

            public void run() {
                DataLinkWizardPage.this.addChildNode(2.class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueNode == null ? (2.class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueNode = 2.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode")) : 2.class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueNode);
            }

            public ImageDescriptor getImageDescriptor() {
                return SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.ICON_VALUE_NODE);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        this.mAddValueAttributeAction = new Action(TextPool.getInstance().getText(2205)){
            static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute;

            public void run() {
                DataLinkWizardPage.this.addChildNode(3.class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute == null ? (3.class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute = 3.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute")) : 3.class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute);
            }

            public ImageDescriptor getImageDescriptor() {
                return SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.ICON_VALUE_ATTRIBUTE);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        this.mAddModelNodeAction = new Action(TextPool.getInstance().getText(2206)){
            static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelNode;

            public void run() {
                DataLinkWizardPage.this.addChildNode(4.class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelNode == null ? (4.class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelNode = 4.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode")) : 4.class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelNode);
            }

            public ImageDescriptor getImageDescriptor() {
                return SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.ICON_MODEL_NODE);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        this.mAddRecursionNodeAction = new Action(TextPool.getInstance().getText(2208)){

            public void run() {
            }

            public ImageDescriptor getImageDescriptor() {
                return SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.ICON_RECURSION_NODE);
            }
        };
        this.mAddModelAttributeAction = new Action(TextPool.getInstance().getText(2207)){
            static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute;

            public void run() {
                DataLinkWizardPage.this.addChildNode(6.class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute == null ? (6.class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute = 6.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute")) : 6.class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute);
            }

            public ImageDescriptor getImageDescriptor() {
                return SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.ICON_MODEL_ATTRIBUTE);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        this.mDeleteAction = new Action(CoreTextPool.getInstance().getText(156)){

            public void run() {
                DataLinkWizardPage.this.delete();
            }
        };
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.mDeleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.mDeleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.mDeleteAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.mDeleteAction.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_HOVER"));
    }

    protected void delete() {
        if (!DataLinkValidator.checkWriteability((DevelopmentObject)(this.mIsReverseMapping ? this.mSource : this.mSourceController))) {
            return;
        }
        Object[] selectedItems = this.mTreeMappingComposite.getSelectedItems(16384);
        if (selectedItems.length != 1) {
            return;
        }
        TreeNode node = (TreeNode)selectedItems[0];
        node.delete();
        Object[] expandedElements = this.mTreeMappingComposite.getExpandedElements(16384);
        this.mTreeMappingComposite.reloadTree(16384);
        int i = 0;
        while (i < expandedElements.length) {
            this.mTreeMappingComposite.expand(16384, expandedElements[i]);
            ++i;
        }
    }

    private void addChildNode(Class type) {
        if (!DataLinkValidator.checkWriteability((DevelopmentObject)(this.mIsReverseMapping ? this.mSource : this.mSourceController))) {
            return;
        }
        Object[] selectedItems = this.mTreeMappingComposite.getSelectedItems(16384);
        if (selectedItems.length != 1) {
            return;
        }
        Object[] expandedNodes = this.mTreeMappingComposite.getExpandedElements(16384);
        TreeNode childNode = new TreeNode();
        childNode.setNodeType(type);
        TreeNode node = (TreeNode)selectedItems[0];
        CreateElementWizardDialog dialog = new CreateElementWizardDialog((IWizard)new CreateElementWizard(childNode, node, this.mSourceTreeContentProvider.getRoot()));
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            node.addChild(childNode);
        }
        this.mTreeMappingComposite.reloadTree(16384);
        int i = 0;
        while (i < expandedNodes.length) {
            this.mTreeMappingComposite.expand(16384, expandedNodes[i]);
            ++i;
        }
        this.mTreeMappingComposite.expand(16384, (Object)node);
    }

    public Object[] getSelectedItems(int tree) {
        return this.mTreeMappingComposite.getSelectedItems(131072);
    }

    public Object[] getInternalSelectedItems(int tree) {
        return this.mTreeMappingComposite.getSelectedItems(tree);
    }

    DevelopmentObject getSourceObject() {
        return this.mSource;
    }

    DevelopmentObject getSourceController() {
        return this.mSourceController;
    }

    boolean getIsReverseMappingMode() {
        return this.mIsReverseMapping;
    }

    ControllerUsage[] getSourceUsages() {
        ControllerUsage[] usages;
        if (this.mIsReverseMapping) {
            ComponentControllerUsage usage = (ComponentControllerUsage)this.mSource;
            usages = usage.getOutgoingControllerUsages();
        } else {
            usages = this.mSourceController.getOutgoingControllerUsages();
        }
        return usages;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

