/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.datalink;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.tools.core.treemappingcomponent.MappingObject;
import com.sap.ide.tools.core.treemappingcomponent.TreeMappingValidator;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.controllereditor.context.ContextMappingValidator;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelBindingValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.DataLinkWizardPage;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.TreeNode;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.validator.CachedObjectModelValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.validator.CachedObjectValidator;
import com.sap.ide.webdynpro.service.controllereditor.usage.ControllerUsageService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionValidator;

public class DataLinkValidator
implements TreeMappingValidator {
    private ISelectionValidator mContextMappingValidator;
    private DataLinkWizardPage mWizardPage;

    public DataLinkValidator(DataLinkWizardPage wizardPage) {
        this.mWizardPage = wizardPage;
    }

    public boolean allowDelete(MappingObject mappingObject) {
        DevelopmentObject src;
        TreeNode node = (TreeNode)mappingObject.getSourceNode().getData();
        Object mappedObject = mappingObject.getTargetNode().getData();
        if (mappedObject instanceof ModelClass || mappedObject instanceof ModelClassProperty || mappedObject instanceof ModelRelationRole) {
            return false;
        }
        if (node.isMappingDeleted()) {
            return true;
        }
        boolean proceed = MessageDialog.openQuestion((Shell)this.mWizardPage.getShell(), (String)"Confirm delete", (String)"Are you sure you want to delete the mapping ?");
        return proceed && (src = node.getData()) != null && DataLinkValidator.checkWriteability(this.mWizardPage.getIsReverseMappingMode() ? this.mWizardPage.getSourceObject() : this.mWizardPage.getSourceController());
    }

    static boolean checkWriteability(DevelopmentObject sourceObject) {
        MMRepositoryObject[] repositoryObjects = new MMRepositoryObject[]{};
        if (sourceObject instanceof Controller) {
            Controller sourceController = (Controller)sourceObject;
            repositoryObjects = ControllerUsageService.getRepositoryObjectsAffectedByControllerUsageCreation((Controller)sourceController);
        } else {
            if (sourceObject instanceof ControllerUsage) {
                return DataLinkValidator.checkWriteability((DevelopmentObject)((ControllerUsage)sourceObject).getUsedController());
            }
            if (sourceObject instanceof View) {
                return DataLinkValidator.checkWriteability((DevelopmentObject)((View)sourceObject).getViewController());
            }
            if (sourceObject instanceof ComponentControllerUsage) {
                ComponentControllerUsage sourceUsage = (ComponentControllerUsage)sourceObject;
                repositoryObjects = ControllerUsageService.getRepositoryObjectsAffectedByControllerUsageCreation((ComponentControllerUsage)sourceUsage);
            } else {
                throw new IllegalArgumentException("Unsupported object type: " + sourceObject);
            }
        }
        return RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean allowMapping(Object target, Object sourceNode, int direction) {
        if (direction == 0x2000000) {
            DevelopmentObject source = null;
            TreeNode srcNode = (TreeNode)sourceNode;
            source = srcNode.isIsNew() ? srcNode.getMappedObject() : srcNode.getData();
            ControllerUsage[] sourceUsages = this.mWizardPage.getSourceUsages();
            if (source instanceof ContextElement) {
                if (target instanceof ContextElement) {
                    this.mContextMappingValidator = new ContextMappingValidator((ContextElement)source, sourceUsages, this.mWizardPage.getIsReverseMappingMode());
                } else if (target instanceof ModelClass || target instanceof ModelClassProperty) {
                    this.mContextMappingValidator = new ModelBindingValidator((ContextElement)source, sourceUsages);
                } else {
                    if (!(target instanceof ModelRelationRole)) return false;
                    ModelRelationRole relationRole = (ModelRelationRole)target;
                    target = relationRole;
                    this.mContextMappingValidator = new ModelBindingValidator((ContextElement)source, sourceUsages);
                }
            } else if (source == null) {
                if (target instanceof ContextElement) {
                    this.mContextMappingValidator = new CachedObjectValidator(srcNode, sourceUsages, this.mWizardPage.getIsReverseMappingMode());
                } else if (target instanceof ModelClass || target instanceof ModelRelationRole || target instanceof ModelClassProperty) {
                    this.mContextMappingValidator = new CachedObjectModelValidator(srcNode, sourceUsages, this.mWizardPage);
                }
            }
            if (null == this.mContextMappingValidator) {
                return false;
            }
            String text = this.mContextMappingValidator.isValid(target);
            if (null == text) {
                this.mWizardPage.clearErrorMessage();
                return true;
            }
            this.mWizardPage.setErrorMessage(text);
            return false;
        } else {
            if (direction != 0x4000000) return false;
            return this.allowReverseMapping(target, sourceNode);
        }
    }

    private boolean allowReverseMapping(Object targetNode, Object sourceNode) {
        ContextValueNode cvNode;
        if (!(sourceNode instanceof DevelopmentObject) || !(targetNode instanceof TreeNode)) {
            return false;
        }
        if (sourceNode instanceof Model) {
            return false;
        }
        if (sourceNode instanceof ContextValueNode && (cvNode = (ContextValueNode)sourceNode).getParentNode() == null) {
            return false;
        }
        TreeNode treeNode = (TreeNode)targetNode;
        DevelopmentObject source = (DevelopmentObject)sourceNode;
        DevelopmentObject target = null;
        boolean isTargetRoot = false;
        if (treeNode.getParent() == null) {
            if (source instanceof ModelRelationRole) {
                this.mWizardPage.setErrorMessage("Model relations cannot be defined for context root node.");
                return false;
            }
            if (source instanceof ModelClassProperty) {
                this.mWizardPage.setErrorMessage("Context root attributes cannot be bound to the model properties.");
                return false;
            }
            this.mWizardPage.clearErrorMessage();
            return true;
        }
        target = treeNode.getData();
        if (target == null) {
            if (treeNode.isIsNew()) {
                target = treeNode.getMappedObject();
            } else {
                return false;
            }
        }
        if (source instanceof ModelClass) {
            DevelopmentObject modelParent = ((ModelClass)source).getParent();
            if (target instanceof ContextModelNode) {
                this.mWizardPage.clearErrorMessage();
                return true;
            }
            this.mWizardPage.setErrorMessage("Incompatible context element type.");
            return false;
        }
        if (source instanceof ContextValueNode) {
            if (!(target instanceof ContextValueNode)) {
                this.mWizardPage.setErrorMessage("Incompatible context element type.");
                return false;
            }
            ContextElement mappedElement = CheckLayerHelper.getMappedElement((ContextElement)((ContextElement)target), (ControllerUsage[])this.mWizardPage.getSourceUsages());
            if (null == mappedElement) {
                this.mWizardPage.setErrorMessage("Mapping of origin parent context node missing.");
                return false;
            }
            ContextNode srcParent = ((ContextValueNode)source).getParentNode();
            if (srcParent.getParentNode() == null) {
                return false;
            }
            if (mappedElement.equals(srcParent)) {
                this.mWizardPage.clearErrorMessage();
                return true;
            }
            return false;
        }
        if (source instanceof ContextModelNode) {
            if (!(target instanceof ContextModelNode)) {
                this.mWizardPage.setErrorMessage("Incompatible context element type.");
                return false;
            }
            ContextElement mappedElement = CheckLayerHelper.getMappedElement((ContextElement)((ContextElement)target), (ControllerUsage[])this.mWizardPage.getSourceUsages());
            if (null == mappedElement) {
                this.mWizardPage.setErrorMessage("Mapping of origin parent context node missing.");
                return false;
            }
            ContextNode srcParent = ((ContextModelNode)source).getParentNode();
            if (srcParent.getParentNode() == null) {
                return false;
            }
            if (mappedElement.equals(srcParent)) {
                this.mWizardPage.clearErrorMessage();
                return true;
            }
            return false;
        }
        if (source instanceof ModelRelationRole) {
            if (!(target instanceof ContextModelNode)) {
                this.mWizardPage.setErrorMessage("Incompatible context element type.");
                return false;
            }
            ModelRelationRole relationRole = (ModelRelationRole)source;
            ModelClass targetClass = relationRole.getModelClass();
            ModelClass sourceClass = null;
            ModelRelationRole[] roles = relationRole.getModelRelation().getModelRelationRoles();
            int i = 0;
            while (i < roles.length) {
                ModelRelationRole role = roles[i];
                if (!role.getModelClass().equals(targetClass)) {
                    sourceClass = role.getModelClass();
                    break;
                }
                ++i;
            }
            ContextModelNode targetContextNode = (ContextModelNode)target;
            ModelClass targetModelClass = targetContextNode.getModelClass();
            if (null == targetModelClass) {
                return false;
            }
            boolean allowMapping = targetModelClass.equals(sourceClass);
            if (!allowMapping) {
                this.mWizardPage.setErrorMessage("Invalid model relation. The corresponding model class does not match the model class associated with the parent context node.");
            } else {
                this.mWizardPage.clearErrorMessage();
            }
            return allowMapping;
        }
        if (source instanceof ModelClassProperty) {
            if (!(target instanceof ContextModelNode)) {
                this.mWizardPage.setErrorMessage("Incompatible context element type.");
                return false;
            }
            ContextModelNode targetContextNode = (ContextModelNode)target;
            ModelClassProperty modelClassProperty = (ModelClassProperty)source;
            ModelClass modelClass = (ModelClass)modelClassProperty.getParent();
            if (null == modelClass) {
                this.mWizardPage.setErrorMessage("Incompatible context element type.");
                return false;
            }
            DevelopmentObject mappedObject = treeNode.getMappedObject();
            if (null == mappedObject) {
                mappedObject = targetContextNode.getModelClass();
            }
            if (null == mappedObject) {
                this.mWizardPage.setErrorMessage("Mapping of origin parent context node missing.");
                return false;
            }
            if (mappedObject.equals(modelClass)) {
                this.mWizardPage.clearErrorMessage();
                return true;
            }
            this.mWizardPage.setErrorMessage("Mapping of origin parent context node missing.");
            return false;
        }
        if (source instanceof ContextModelAttribute) {
            if (!(target instanceof ContextModelNode)) {
                this.mWizardPage.setErrorMessage("Incompatible context element type.");
                return false;
            }
            ContextModelAttribute sourceAttribute = (ContextModelAttribute)source;
            ContextModelNode sourceModelNode = (ContextModelNode)sourceAttribute.getParent();
            if (null == sourceModelNode) {
                return false;
            }
            DevelopmentObject mappedObject = treeNode.getMappedObject();
            if (null == mappedObject) {
                this.mWizardPage.setErrorMessage("Mapping of origin parent context node missing.");
                return false;
            }
            if (mappedObject.equals(sourceModelNode)) {
                this.mWizardPage.clearErrorMessage();
                return true;
            }
            this.mWizardPage.setErrorMessage("Incompatible context element type.");
            return false;
        }
        if (source instanceof ContextValueAttribute) {
            if (!(target instanceof ContextValueNode)) {
                this.mWizardPage.setErrorMessage("Incompatible context element type.");
                return false;
            }
            ContextValueAttribute sourceAttribute = (ContextValueAttribute)source;
            ContextValueNode sourceValueNode = (ContextValueNode)sourceAttribute.getParent();
            if (null == sourceValueNode) {
                return false;
            }
            DevelopmentObject mappedObject = treeNode.getMappedObject();
            if (null == mappedObject) {
                this.mWizardPage.setErrorMessage("Mapping of origin parent context node missing.");
                return false;
            }
            if (mappedObject.equals(sourceValueNode)) {
                this.mWizardPage.clearErrorMessage();
                return true;
            }
            this.mWizardPage.setErrorMessage("Incompatible context element type.");
            return false;
        }
        this.mWizardPage.setErrorMessage("Incompatible context element type.");
        return false;
    }

    public boolean allowModify(Object oldSource, Object oldTarget, Object newSource, Object newTarget) {
        return false;
    }
}

