/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.datalink;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.tools.core.treemappingcomponent.MappingObject;
import com.sap.ide.tools.core.treemappingcomponent.listener.DragDropValidator;
import com.sap.ide.tools.core.treemappingcomponent.listener.TreeMappingListener;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.DataLinkValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.DataLinkWizardPage;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.TreeNode;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.DataLinkMappingWizard;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.DataLinkMappingWizardDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.provider.DataLinkContentProvider;

public class DataLinkMappingListener
implements TreeMappingListener,
DragDropValidator {
    private Controller mTargetController;
    private Controller mSourceController;
    private DataLinkContentProvider mContentProvider;
    private TreeNode mRoot = null;
    private DataLinkWizardPage mPage = null;
    private TreeNode mBackupRoot = null;
    private boolean mIsReverseMapping = false;
    private int mDirection;
    private DevelopmentObject mSource;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute;

    public DataLinkMappingListener(DataLinkWizardPage page, DataLinkContentProvider contentProvider, boolean isReverseMapping, int direction, Controller sourceController, Controller targetController, DevelopmentObject source) {
        this.mPage = page;
        this.mContentProvider = contentProvider;
        this.mIsReverseMapping = isReverseMapping;
        this.mDirection = direction;
        this.mSourceController = sourceController;
        this.mTargetController = targetController;
        this.mSource = source;
    }

    public void mappingCreated(MappingObject mappingObject) {
    }

    private void createDeepCopy(DataLinkContentProvider mContentProvider) {
        this.mBackupRoot = mContentProvider.getRoot().deepCopy();
        Object[] children = this.mRoot.getChildren();
        this.createDeepCopy(this.mBackupRoot, children);
    }

    private void createDeepCopy(TreeNode parent, Object[] children) {
        int i = 0;
        while (i < children.length) {
            TreeNode node = (TreeNode)children[i];
            TreeNode newNode = node.deepCopy();
            parent.addChild(newNode);
            if (node.hasChildren()) {
                this.createDeepCopy(newNode, node.getChildren());
            }
            ++i;
        }
    }

    public void mappingDeleted(MappingObject mappingObject) {
        com.sap.ide.tools.core.treemappingcomponent.tree.TreeNode srcNode = mappingObject.getSourceNode();
        TreeNode node = (TreeNode)srcNode.getData();
        node.setMappingDeleted(true);
        if (node.hasChildren()) {
            Object[] children = node.getChildren();
            this.deleteMapping(children);
        }
    }

    private void deleteMapping(Object[] children) {
        int i = 0;
        while (i < children.length) {
            TreeNode child = (TreeNode)children[i];
            child.setMappingDeleted(true);
            DevelopmentObject mappedObj = child.getMappedObject();
            if (null != mappedObj) {
                this.mPage.deleteLink(child, mappedObj);
            }
            if (child.hasChildren()) {
                this.deleteMapping(child.getChildren());
            }
            ++i;
        }
    }

    public void mappingModified(MappingObject oldMappingObject, MappingObject newMappingObject) {
    }

    public void setRoot(TreeNode root) {
        this.mRoot = root;
    }

    public boolean allowDrop(Object source, Object target) {
        boolean retValue = false;
        if (!DataLinkValidator.checkWriteability((DevelopmentObject)(this.mIsReverseMapping ? this.mSource : this.mSourceController))) {
            return false;
        }
        switch (this.mDirection) {
            case 0x2000000: {
                retValue = this.allowNormalDrop(source, target);
                break;
            }
            case 0x4000000: {
                retValue = this.allowReverseDrop(source, target);
            }
        }
        return retValue;
    }

    private boolean allowReverseDrop(Object source, Object target) {
        if (!(target instanceof TreeNode) || !(source instanceof DevelopmentObject)) {
            return false;
        }
        boolean isRoot = false;
        TreeNode targetNode = (TreeNode)target;
        DevelopmentObject srcDevObj = (DevelopmentObject)source;
        String name = srcDevObj.getName();
        if (srcDevObj instanceof ModelRelationRole) {
            ModelRelationRole relRole = (ModelRelationRole)srcDevObj;
            name = relRole.getName();
        }
        TreeNode childNode = new TreeNode(targetNode, null, null, name, true);
        childNode.setNodeType(srcDevObj.getClass());
        targetNode.addChild(childNode);
        DataLinkMappingWizard wizard = new DataLinkMappingWizard(this.mPage.getWizard().getContainer());
        wizard.initialize(this.mContentProvider, childNode, (DevelopmentObject)source, 2, this.mIsReverseMapping);
        DataLinkMappingWizardDialog dialog = new DataLinkMappingWizardDialog(wizard);
        if (dialog.open() == 0) {
            DataLinkContentProvider newTree = wizard.getTree();
            this.mPage.createMapping(childNode, childNode.getMappedObject());
            this.createChildrenMapping(childNode);
            this.mPage.reloadSourceTree();
            return true;
        }
        targetNode.forceDelete(childNode);
        return false;
    }

    private boolean allowNormalDrop(Object source, Object target) {
        try {
            TreeNode srcNode = (TreeNode)source;
            source = srcNode.isIsNew() ? srcNode.getMappedObject() : srcNode.getData();
            if ((srcNode.getNodeType().equals(class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute == null ? (class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute = DataLinkMappingListener.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute")) : class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute) || srcNode.getNodeType().equals(class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute == null ? (class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute = DataLinkMappingListener.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute")) : class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute)) && (target instanceof ContextAttribute || target instanceof ModelClassProperty)) {
                return this.mapAttribute(srcNode, target);
            }
            this.createDeepCopy(this.mContentProvider);
            DataLinkMappingWizard wizard = new DataLinkMappingWizard(this.mPage.getWizard().getContainer());
            wizard.initialize(this.mContentProvider, srcNode, (DevelopmentObject)target, 1, this.mIsReverseMapping);
            DataLinkMappingWizardDialog dialog = new DataLinkMappingWizardDialog(wizard);
            if (dialog.open() == 0) {
                DataLinkContentProvider newTree = wizard.getTree();
                if (srcNode.isIsNew()) {
                    this.mPage.createMapping(srcNode, srcNode.getMappedObject());
                }
                srcNode.setMappingDeleted(false);
                this.createChildrenMapping(srcNode);
                this.mPage.reloadSourceTree();
                return true;
            }
            this.mContentProvider.setRoot(this.mBackupRoot);
            this.mPage.reloadSourceTree();
            return false;
        }
        catch (Exception e) {
            Plugin.internalError(this.getClass(), "allowNormalDrop(Object, Object)", e.getMessage(), e, true);
            return false;
        }
    }

    private boolean mapAttribute(TreeNode srcNode, Object target) {
        try {
            if (null == target || null == srcNode) {
                return false;
            }
            srcNode.setMappedObject((DevelopmentObject)target);
            srcNode.setMappingDeleted(false);
            return true;
        }
        catch (Exception ex) {
            Plugin.internalError(this.getClass(), "mapAttribute(TreeNode, Object)", ex.getMessage(), ex, true);
            return false;
        }
    }

    private void createChildrenMapping(TreeNode srcNode) {
        Object[] children = srcNode.getChildren();
        int i = 0;
        while (i < children.length) {
            TreeNode child = (TreeNode)children[i];
            DevelopmentObject mappedObj = child.getMappedObject();
            if (mappedObj != null) {
                this.mPage.createMapping(child, mappedObj);
                child.setMappingDeleted(false);
            }
            if (child.hasChildren()) {
                this.createChildrenMapping(child);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

