/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.controller.refactoring;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.webdynpro.WebDynproMDOEnum;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.webdynpro.generation.eclipse.deletion.DeletionService;
import com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService;
import com.sap.ide.webdynpro.service.controllereditor.implementation.AmbiguousImportsException;
import com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardData;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;

public class RenameControllerWizard
extends RenameWizard {
    public RenameControllerWizard(Controller controller) {
        super((DevelopmentObject)controller);
    }

    public RenameControllerWizard(Controller controller, String newName, String newPackage) {
        super((DevelopmentObject)controller, newName, newPackage);
    }

    protected String verifyDevelopmentobjectName(String nameInput, String packageInput) {
        RenameWizardData renameWizardData = this.getWizardData();
        Controller controller = null;
        Component parentComponent = null;
        DevelopmentObject developmentObject = renameWizardData.getObjectToRefactor();
        if (!(developmentObject instanceof Controller)) {
            return "wrong type";
        }
        controller = (Controller)developmentObject;
        if (controller.getType() != ControllerTypeEnum.CUSTOM) {
            return "wrong type";
        }
        IStatus status = CheckServices.isValidMDOPath((Metamodel)developmentObject.getMetamodel(), (MDOEnum)WebDynproMDOEnum.CONTROLLER, (String)nameInput, (String)packageInput, (SourcePathIdentifier)renameWizardData.getTemporarySourcePathIdentifier());
        if (status.getSeverity() == 4) {
            return status.getMessage();
        }
        parentComponent = (Component)controller.getParent().getMDO();
        return ControllerService.isNewControllerNameValid((String)nameInput, (String)packageInput, (Metamodel)parentComponent.getRoot().getMetamodel(), (MainDevelopmentObject)parentComponent);
    }

    protected void deleteImplementation(DevelopmentObject developmentObject) {
        if (developmentObject instanceof Controller) {
            Controller controller = (Controller)developmentObject;
            DeletionService deletionService = new DeletionService(this.getWizardData().getEclipseProject());
            deletionService.deleteController(controller, true);
        }
    }

    protected void generateImplementation(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
        if (developmentObject instanceof Controller) {
            Controller controller = (Controller)developmentObject;
            ControllerService.createControllerImplementation((Controller)controller, (ProgressMonitorDialog)dialog);
        }
    }

    protected void organizeImports(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
        Controller controller;
        if (developmentObject instanceof Controller && (controller = (Controller)developmentObject).getCodeBody() != null) {
            dialog.getProgressMonitor().setTaskName(CoreTextPool.getInstance().getText(214));
            ImplementationService implService = new ImplementationService(controller);
            this.doOrganizeImports(implService, dialog.getProgressMonitor());
        }
    }

    private void doOrganizeImports(ImplementationService implService, IProgressMonitor monitor) {
        try {
            implService.organizeImports(true, monitor);
        }
        catch (AmbiguousImportsException ambiguousImportsException) {
            // empty catch block
        }
    }
}

