/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.controller;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.webdynpro.controllereditor.wizards.controller.CreateControllerWizardData;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateControllerWizardPropertiesPage
extends WizardPage {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String PAGE_NAME;
    private static final String PAGE_TITLE;
    private static final String PAGE_DESCRIPTION;
    private CreateControllerWizardData mData = null;
    private IProject mProject = null;
    private Text mNameField = null;
    private Text mPackageField = null;
    private Button mPackageButton = null;
    private List mSourcePathList = null;

    public CreateControllerWizardPropertiesPage(CreateControllerWizardData data, IProject project) {
        super(PAGE_NAME);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
        ImageDescriptor imageDescriptor = SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_CONTROLLER_BANNER);
        this.setImageDescriptor(imageDescriptor);
        this.mData = data;
        this.mProject = project;
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        this.setControl((Control)root);
        IGridLayoutPane propertyPane = PaneFactory.createGridLayoutPane((Composite)root, (int)3);
        propertyPane.addTextLabel(mTextPool.getText(73));
        IGridLayoutData gd = propertyPane.createGridLayoutData(4, 1, true, false);
        this.mNameField = propertyPane.addTextField(this.mData.getName(), false, gd);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        this.mNameField.setFocus();
        propertyPane.addPlaceholder();
        propertyPane.addTextLabel(mTextPool.getText(74));
        gd = propertyPane.createGridLayoutData(4, 1, true, false);
        this.mPackageField = propertyPane.addTextField(this.mData.getPackage(), false, gd);
        this.mPackageField.addModifyListener((ModifyListener)new PackageModifyListener());
        this.mPackageButton = propertyPane.addPushButton(mTextPool.getText(75));
        this.mPackageButton.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        propertyPane.addTextLabel(mCoreTextPool.getText(207));
        gd = propertyPane.createGridLayoutData(1, 1, true, false);
        IPackageFragmentRoot[] roots = this.mData.getAllValidRoots();
        String[] items = new String[roots.length];
        IPackageFragmentRoot selectedRoot = this.mData.getSelectedRoot();
        int preselectionIndex = 0;
        int i = 0;
        while (i < roots.length) {
            items[i] = roots[i].getPath().removeFirstSegments(1).makeRelative().toString();
            if (roots[i].equals(selectedRoot)) {
                preselectionIndex = i;
            }
            ++i;
        }
        this.mSourcePathList = propertyPane.addList(items, false, gd);
        GridData pathGridData = new GridData(1808);
        pathGridData.widthHint = 270;
        pathGridData.heightHint = 40;
        this.mSourcePathList.setLayoutData((Object)pathGridData);
        this.mSourcePathList.addSelectionListener((SelectionListener)new SourceSelectionListener());
        this.mSourcePathList.setSelection(preselectionIndex);
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.mNameField != null) {
            this.mNameField.setFocus();
        }
    }

    static {
        PAGE_TITLE = PAGE_NAME = mTextPool.getText(70);
        PAGE_DESCRIPTION = mTextPool.getText(71);
    }

    private class SourceSelectionListener
    implements SelectionListener {
        private SourceSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int selectionIndex = CreateControllerWizardPropertiesPage.this.mSourcePathList.getSelectionIndex();
            if (selectionIndex >= 0) {
                IPackageFragmentRoot[] allRoots = CreateControllerWizardPropertiesPage.this.mData.getAllValidRoots();
                IPackageFragmentRoot selectedRoot = allRoots[selectionIndex];
                CreateControllerWizardPropertiesPage.this.mData.setSelectedRoot(selectedRoot);
            }
        }
    }

    private class ButtonSelectionListener
    implements SelectionListener {
        private ButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            IPackageFragmentRoot sourceRoot = CreateControllerWizardPropertiesPage.this.mData.getSelectedRoot();
            String packageName = CreateControllerWizardPropertiesPage.this.mData.getPackage();
            IPackageFragment preselectedPackage = null;
            if (sourceRoot != null) {
                preselectedPackage = ServicesEclipse.getPackageInSourceRoot((String)packageName, (IPackageFragmentRoot)sourceRoot);
            }
            IPackageFragment packageFragment = null;
            if (sourceRoot != null) {
                packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)sourceRoot, (IPackageFragment)preselectedPackage, (Shell)CreateControllerWizardPropertiesPage.this.getShell());
            }
            if (packageFragment != null) {
                CreateControllerWizardPropertiesPage.this.mData.setPackage(packageFragment.getElementName());
                CreateControllerWizardPropertiesPage.this.mPackageField.setText(packageFragment.getElementName());
            }
        }
    }

    private class PackageModifyListener
    implements ModifyListener {
        private PackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            IStatus nameStatus = ControllerService.isNewControllerNameValid((String)CreateControllerWizardPropertiesPage.this.mNameField.getText(), (String)CreateControllerWizardPropertiesPage.this.mPackageField.getText(), (Metamodel)CreateControllerWizardPropertiesPage.this.mData.getComponent().getRoot().getMetamodel(), (MainDevelopmentObject)CreateControllerWizardPropertiesPage.this.mData.getComponent(), (int)0);
            String packageInput = CheckServices.convertToLowerCase((Text)CreateControllerWizardPropertiesPage.this.mPackageField);
            IStatus packageStatus = CheckServices.isValidPackage((String)packageInput);
            if (nameStatus.getSeverity() == 0 && packageStatus.getSeverity() == 0) {
                CreateControllerWizardPropertiesPage.this.setPageComplete(true);
                CreateControllerWizardPropertiesPage.this.setErrorMessage(null);
                CreateControllerWizardPropertiesPage.this.setMessage(null);
                CreateControllerWizardPropertiesPage.this.mData.setPackage(CreateControllerWizardPropertiesPage.this.mPackageField.getText());
            } else if (nameStatus.getSeverity() == 4 || packageStatus.getSeverity() == 4) {
                String error = "";
                if (packageStatus.getSeverity() == 4) {
                    error = packageStatus.getMessage();
                } else if (nameStatus.getSeverity() == 4) {
                    error = nameStatus.getMessage();
                }
                CreateControllerWizardPropertiesPage.this.setPageComplete(false);
                CreateControllerWizardPropertiesPage.this.setErrorMessage(error);
            } else if (nameStatus.getSeverity() == 2 || packageStatus.getSeverity() == 2) {
                String warning = "";
                if (packageStatus.getSeverity() == 2) {
                    warning = packageStatus.getMessage();
                } else if (nameStatus.getSeverity() == 2) {
                    warning = nameStatus.getMessage();
                }
                CreateControllerWizardPropertiesPage.this.setErrorMessage(null);
                CreateControllerWizardPropertiesPage.this.setMessage(warning, 2);
                CreateControllerWizardPropertiesPage.this.setPageComplete(true);
                CreateControllerWizardPropertiesPage.this.mData.setPackage(CreateControllerWizardPropertiesPage.this.mPackageField.getText());
            }
        }
    }

    private class NameModifyListener
    implements ModifyListener {
        private NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String nameInput = CreateControllerWizardPropertiesPage.this.mNameField.getText();
            nameInput = CheckServices.checkFirstCharacter((Text)CreateControllerWizardPropertiesPage.this.mNameField);
            IStatus nameStatus = ControllerService.isNewControllerNameValid((String)nameInput, (String)CreateControllerWizardPropertiesPage.this.mPackageField.getText(), (Metamodel)CreateControllerWizardPropertiesPage.this.mData.getComponent().getRoot().getMetamodel(), (MainDevelopmentObject)CreateControllerWizardPropertiesPage.this.mData.getComponent(), (int)0);
            IStatus packageStatus = CheckServices.isValidPackage((String)CreateControllerWizardPropertiesPage.this.mPackageField.getText());
            if (nameStatus.getSeverity() == 0 && packageStatus.getSeverity() == 0) {
                CreateControllerWizardPropertiesPage.this.setPageComplete(true);
                CreateControllerWizardPropertiesPage.this.setErrorMessage(null);
                CreateControllerWizardPropertiesPage.this.setMessage(null);
                CreateControllerWizardPropertiesPage.this.mData.setName(CreateControllerWizardPropertiesPage.this.mNameField.getText());
            } else if (nameStatus.getSeverity() == 4 || packageStatus.getSeverity() == 4) {
                String error = "";
                if (nameStatus.getSeverity() == 4) {
                    error = nameStatus.getMessage();
                } else if (packageStatus.getSeverity() == 4) {
                    error = packageStatus.getMessage();
                }
                CreateControllerWizardPropertiesPage.this.setPageComplete(false);
                CreateControllerWizardPropertiesPage.this.setErrorMessage(error);
            } else if (nameStatus.getSeverity() == 2 || packageStatus.getSeverity() == 2) {
                String warning = "";
                if (nameStatus.getSeverity() == 2) {
                    warning = nameStatus.getMessage();
                } else if (packageStatus.getSeverity() == 2) {
                    warning = packageStatus.getMessage();
                }
                CreateControllerWizardPropertiesPage.this.setErrorMessage(null);
                CreateControllerWizardPropertiesPage.this.setMessage(warning, 2);
                CreateControllerWizardPropertiesPage.this.setPageComplete(true);
                CreateControllerWizardPropertiesPage.this.mData.setName(CreateControllerWizardPropertiesPage.this.mNameField.getText());
            }
        }
    }
}

