/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.controller;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.wizards.controller.CreateControllerWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.controller.CreateControllerWizardPropertiesPage;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateControllerWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private CreateControllerWizardData mData = null;
    private CreateControllerWizardPropertiesPage mPropertiesPage = null;

    public CreateControllerWizard(Component component, CreateControllerWizardData data) {
        this.mData = data == null ? new CreateControllerWizardData(component) : data;
        this.setWindowTitle(mTextPool.getText(597));
    }

    public boolean performFinish() {
        Controller controller;
        IPackageFragmentRoot packageFragmentRoot = this.mData.getSelectedRoot();
        MetamodelManager manager = MetamodelManager.getMetamodelManager((String)this.mData.getComponent().getRoot().getMetamodel().getName());
        IPath sourcePath = manager.makePathAbsolute(packageFragmentRoot.getPath());
        SourcePathIdentifier identifier = manager.getSourcePathIdentifier(sourcePath);
        try {
            controller = ControllerService.createCustomController((Component)this.mData.getComponent(), (String)this.mData.getPackage().toLowerCase(), (String)this.mData.getName(), (SourcePathIdentifier)identifier, (boolean)false);
        }
        catch (CreateException e) {
            Plugin.internalError(((Object)((Object)this)).getClass(), "performFinish()", e.getMessage(), e, true);
            this.mPropertiesPage.setMessage(e.getMessage());
            return false;
        }
        if (controller != null) {
            return true;
        }
        this.mPropertiesPage.setMessage(mTextPool.getText(1002, (Object)this.mData.getName()));
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(mTextPool.getText(69));
    }

    public void addPages() {
        IProject project = ServicesEclipse.getEclipseProject((DevelopmentObject)this.mData.getComponent());
        this.mPropertiesPage = new CreateControllerWizardPropertiesPage(this.mData, project);
        this.addPage((IWizardPage)this.mPropertiesPage);
    }

    public CreateControllerWizardData getData() {
        return this.mData;
    }
}

