/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.treelist;

import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.IItemValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.ValidationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public class TreeListValidationService {
    private IItemValidator mValidator;
    private List mErroneousItems = new ArrayList();
    private TreeListItemHelper mHelper;
    public static final IStatus OK_RESULT = new ValidationResult("Ok", 0);

    public TreeListValidationService(IItemValidator validator, TreeListItemHelper helper) {
        this.mValidator = validator;
        this.mHelper = helper;
    }

    public boolean isEnabled(TreeListItem item) {
        return this.mValidator.isEnabled(item, this.mHelper);
    }

    public boolean isNode(TreeListItem item) {
        return this.mValidator.isNode(item, this.mHelper);
    }

    public boolean isChecked(TreeListItem item) {
        return this.mValidator.isChecked(item, this.mHelper);
    }

    public IStatus validateSingleItem(TreeListItem item, int severityFilter, boolean force) {
        IStatus result = this.validateSingleItem(item, force);
        if (result.getSeverity() == severityFilter) {
            return result;
        }
        return OK_RESULT;
    }

    public IStatus validateSingleItem(TreeListItem item, boolean force) {
        return this.validateSingleItem(item, null, null, force);
    }

    public IStatus validateSingleItem(TreeListItem item, String property, Object value, boolean force) {
        if (item == null) {
            return OK_RESULT;
        }
        IStatus result = item.getValidationResult();
        if (result == null || force) {
            result = this.mValidator.validateItem(item, this.mHelper, property, value);
        }
        if (result == null) {
            result = OK_RESULT;
        }
        item.setValidationResult(result);
        return this.checkResult(item);
    }

    public IStatus validateTreeListItemAndChildren(TreeListItem rootItem, int severityFilter, boolean onlyCheckedItems, boolean force) {
        IStatus result = this.validateSingleItem(rootItem, severityFilter, force);
        if (!result.isOK()) {
            return result;
        }
        List children = rootItem.getChildren();
        if (children != null) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                TreeListItem child = this.mHelper.get(iter.next());
                if (onlyCheckedItems) {
                    if (child.isChecked()) {
                        result = this.validateTreeListItemAndChildren(child, severityFilter, onlyCheckedItems, force);
                    }
                } else {
                    result = this.validateTreeListItemAndChildren(child, severityFilter, onlyCheckedItems, force);
                }
                if (result.isOK()) continue;
                return result;
            }
        }
        return result;
    }

    private IStatus validateAllItems(int severityFilter, boolean onlyCheckedItems, boolean force) {
        List items = this.mHelper.getItems();
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            TreeListItem item = (TreeListItem)iter.next();
            IStatus result = this.validateTreeListItemAndChildren(item, severityFilter, onlyCheckedItems, force);
            if (result.isOK()) continue;
            return result;
        }
        return OK_RESULT;
    }

    public boolean validateForWizardPageCompleteness() {
        return !this.mHelper.getCheckedAndEnabledItems().isEmpty() && this.mErroneousItems.isEmpty();
    }

    public static boolean isDuplicateName(TreeListItem itemToCheck, TreeListItemHelper helper, String propertyName, Object propertyValue) {
        List items = helper.getItems();
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            TreeListItem item = (TreeListItem)iter.next();
            Object value = item.getProperties().getValue(propertyName);
            if (value == null || item.equals(itemToCheck) || !itemToCheck.isChecked() || !item.isChecked() || item.isNode() != itemToCheck.isNode()) continue;
            if (value instanceof String && propertyValue instanceof String && ((String)value).equalsIgnoreCase((String)propertyValue)) {
                return true;
            }
            if (!value.equals(propertyValue)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDuplicateName(TreeListItem itemToCheck, TreeListItem scopeItem, TreeListItemHelper helper, String propertyName, Object propertyValue) {
        Collection children = null;
        if (scopeItem == null) {
            children = helper.getTopLevelKeys();
        } else {
            Object value = scopeItem.getProperties().getValue(propertyName);
            if (value != null && !scopeItem.equals(itemToCheck) && !scopeItem.isChecked() && scopeItem.isNode() == itemToCheck.isNode()) {
                if (value instanceof String && propertyValue instanceof String && ((String)value).equalsIgnoreCase((String)propertyValue)) {
                    return true;
                }
                if (value.equals(propertyValue)) {
                    return true;
                }
            }
            children = scopeItem.getChildren();
        }
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            TreeListItem item = helper.get(iter.next());
            Object value = item.getProperties().getValue(propertyName);
            if (value == null || item.equals(itemToCheck) || item.isNode() != itemToCheck.isNode()) continue;
            if (value instanceof String && propertyValue instanceof String && ((String)value).equalsIgnoreCase((String)propertyValue)) {
                return true;
            }
            if (!value.equals(propertyValue)) continue;
            return true;
        }
        return false;
    }

    private IStatus checkResult(TreeListItem item) {
        IStatus result = item.getValidationResult();
        if (result == null) {
            result = OK_RESULT;
        } else if (result.getSeverity() == 4 && !this.mErroneousItems.contains(item)) {
            this.mErroneousItems.add(item);
        } else if (result.getSeverity() != 4 && this.mErroneousItems.contains(item)) {
            this.mErroneousItems.remove(item);
        }
        return result;
    }
}

