/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.treelist;

import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.CheckboxTreeAndList;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.IPropertyProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.PropertyMap;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListCheckStateListener;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemCellModifier;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemCellValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemSorter;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListSelectionChangedListener;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListValidationService;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;

public class TreeListItemHelper {
    private CheckboxTreeAndList mTreeList;
    private WizardPage mWizardPage;
    private List mItems = new ArrayList(100);
    private Map mItemForKey = null;
    private Map mTopLevelItemForKey = null;
    private Map mChildrenForKey = new HashMap(100);
    private TreeListValidationService mValidation;
    private TreeListCheckStateListener mCheckstateListener;
    private ITreeViewerListener mTreeViewerListener;
    private ISelectionChangedListener mTreeSelectionChangedListener;
    private ISelectionChangedListener mListSelectionChangedListener;
    private PrintStream mDumper = System.err;

    public List getItems() {
        return this.mItems;
    }

    public void clearData() {
        this.mItems.clear();
        this.mItemForKey = null;
        this.mTopLevelItemForKey = null;
        this.mChildrenForKey.clear();
    }

    public TreeListItem get(Object key) {
        if (key == null) {
            return null;
        }
        this.checkBuildKeyMap();
        if (this.mItemForKey.containsKey(key)) {
            return (TreeListItem)this.mItemForKey.get(key);
        }
        return null;
    }

    public Set getKeys() {
        this.checkBuildKeyMap();
        return this.mItemForKey.keySet();
    }

    public Set getTopLevelKeys() {
        this.checkBuildTopLevelKeyMap();
        return this.mTopLevelItemForKey.keySet();
    }

    public Collection getTopLevelItems() {
        this.checkBuildTopLevelKeyMap();
        return this.mTopLevelItemForKey.values();
    }

    public List getItems(List keys) {
        this.checkBuildKeyMap();
        ArrayList results = new ArrayList();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (!this.mItemForKey.containsKey(key)) continue;
            results.add(this.mItemForKey.get(key));
        }
        return results;
    }

    public List buildTreeListItems(CheckboxTreeAndList treeList, ITreeContentProvider contentProvider, Object[] columnProperties, IPropertyProvider propertyProvider, Object root, TreeListValidationService validation, IProgressMonitor monitor) {
        this.mValidation = validation;
        this.mTreeList = treeList;
        CheckboxTreeViewer viewer = null;
        if (treeList != null) {
            viewer = treeList.getTreeViewer();
        }
        contentProvider.inputChanged((Viewer)viewer, null, root);
        Object[] elements = contentProvider.getElements(root);
        int i = 0;
        while (i < elements.length) {
            this.buildChildTreeListItems(contentProvider, propertyProvider, columnProperties, elements[i], true, this.mValidation, monitor, 0, Plugin.isContextWizardTreeDumpEnabled() ? this.mDumper : null);
            ++i;
        }
        int nodes = 0;
        int leaves = 0;
        Iterator iter = this.mItems.iterator();
        while (iter.hasNext()) {
            TreeListItem item = (TreeListItem)iter.next();
            PropertyMap propertyMap = item.getProperties();
            if (this.mValidation == null) continue;
            item.setIsEnabled(this.mValidation.isEnabled(item));
            item.setIsNode(this.mValidation.isNode(item));
            item.setIsChecked(this.mValidation.isChecked(item));
            if (item.isNode()) {
                ++nodes;
                continue;
            }
            ++leaves;
        }
        if (Plugin.isContextWizardTreeStatisticsEnabled()) {
            this.mDumper.println("\nElements: " + (nodes + leaves) + " (" + nodes + " nodes, " + leaves + " leaves)");
        }
        return this.mItems;
    }

    public List getChildren(TreeListItem item) {
        if (!this.mChildrenForKey.containsKey(item.getElement())) {
            ArrayList<TreeListItem> children = new ArrayList<TreeListItem>();
            List childrenKeys = item.getChildren();
            Iterator iter = childrenKeys.iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                children.add(this.get(key));
            }
            this.mChildrenForKey.put(item.getElement(), children);
        }
        return (List)this.mChildrenForKey.get(item.getElement());
    }

    public Set getCheckedKeys() {
        this.checkBuildKeyMap();
        HashSet<Object> checkedKeys = new HashSet<Object>();
        Iterator iter = this.mItemForKey.keySet().iterator();
        while (iter.hasNext()) {
            TreeListItem item = this.get(iter.next());
            if (!item.isChecked()) continue;
            checkedKeys.add(item.getElement());
        }
        return checkedKeys;
    }

    public List getCheckedItems() {
        this.checkBuildKeyMap();
        ArrayList<TreeListItem> checked = new ArrayList<TreeListItem>();
        Iterator iter = this.mItemForKey.keySet().iterator();
        while (iter.hasNext()) {
            TreeListItem item = this.get(iter.next());
            if (!item.isChecked()) continue;
            checked.add(item);
        }
        return checked;
    }

    public List getDisabledItems() {
        this.checkBuildKeyMap();
        ArrayList<TreeListItem> disabled = new ArrayList<TreeListItem>();
        Iterator iter = this.mItemForKey.keySet().iterator();
        while (iter.hasNext()) {
            TreeListItem item = this.get(iter.next());
            if (item.isEnabled()) continue;
            disabled.add(item);
        }
        return disabled;
    }

    public List getDisabledChildren(TreeListItem item) {
        List children = this.getChildren(item);
        ArrayList<TreeListItem> disabledChildren = new ArrayList<TreeListItem>();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            TreeListItem child = (TreeListItem)iterator.next();
            if (child.isEnabled()) continue;
            disabledChildren.add(child);
        }
        return disabledChildren;
    }

    public List getChildNodes(TreeListItem item) {
        List children = this.getChildren(item);
        ArrayList<TreeListItem> childNodes = new ArrayList<TreeListItem>();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            TreeListItem child = (TreeListItem)iterator.next();
            if (!child.isNode()) continue;
            childNodes.add(child);
        }
        return childNodes;
    }

    public Set getDisabledKeys() {
        this.checkBuildKeyMap();
        HashSet keys = new HashSet();
        Iterator iter = this.mItemForKey.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            TreeListItem item = this.get(key);
            if (item.isEnabled()) continue;
            keys.add(key);
        }
        return keys;
    }

    public List getCheckedAndEnabledItems() {
        this.checkBuildKeyMap();
        ArrayList<TreeListItem> checkedAndEnabled = new ArrayList<TreeListItem>();
        Iterator iter = this.mItemForKey.keySet().iterator();
        while (iter.hasNext()) {
            TreeListItem item = this.get(iter.next());
            if (!item.isChecked() || !item.isEnabled()) continue;
            checkedAndEnabled.add(item);
        }
        return checkedAndEnabled;
    }

    public List getParents(TreeListItem item) {
        TreeListItem parentItem;
        ArrayList<TreeListItem> parents = new ArrayList<TreeListItem>();
        if (item.getParent() != null && (parentItem = this.get(item.getParent())) != null) {
            parents.add(parentItem);
            parents.addAll(this.getParents(parentItem));
        }
        return parents;
    }

    public List getCheckedParents(TreeListItem item) {
        ArrayList<TreeListItem> checkedParents = new ArrayList<TreeListItem>();
        if (item.getParent() != null) {
            TreeListItem parentItem = this.get(item.getParent());
            if (parentItem != null && parentItem.isChecked()) {
                checkedParents.add(parentItem);
            }
            checkedParents.addAll(this.getParents(parentItem));
        }
        return checkedParents;
    }

    public List getCheckedSiblings(TreeListItem item) {
        TreeListItem parentItem;
        ArrayList checkedSiblings = new ArrayList();
        if (item.getParent() != null && (parentItem = this.get(item.getParent())) != null) {
            checkedSiblings.addAll(this.getCheckedChildren(parentItem));
            checkedSiblings.remove(item);
        }
        return checkedSiblings;
    }

    public List getCheckedChildren(TreeListItem parentItem) {
        ArrayList<TreeListItem> checkedChildren = new ArrayList<TreeListItem>();
        List children = this.getChildren(parentItem);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            TreeListItem child = (TreeListItem)iter.next();
            if (!child.isChecked()) continue;
            checkedChildren.add(child);
        }
        return checkedChildren;
    }

    public List getItemAndDescendants(TreeListItem item, boolean leavesOnly) {
        ArrayList<TreeListItem> results = new ArrayList<TreeListItem>();
        if (item != null) {
            results.add(item);
            List children = item.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                TreeListItem child = this.get(iter.next());
                results.addAll(this.getItemAndDescendants(child, leavesOnly));
            }
        }
        return results;
    }

    public List getItemAndChildren(TreeListItem item, boolean leavesOnly) {
        ArrayList<TreeListItem> results = new ArrayList<TreeListItem>();
        if (item != null) {
            results.add(item);
            List children = item.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                TreeListItem child = this.get(iter.next());
                if (leavesOnly) {
                    if (child.isNode()) continue;
                    results.add(child);
                    continue;
                }
                results.add(child);
            }
        }
        return results;
    }

    public List getCheckedItemAndDescendants(TreeListItem item, boolean leavesOnly) {
        ArrayList<TreeListItem> results = new ArrayList<TreeListItem>();
        if (item != null) {
            if (item.isChecked()) {
                results.add(item);
            }
            List children = item.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                TreeListItem child = this.get(iter.next());
                results.addAll(this.getItemAndDescendants(child, leavesOnly));
            }
        }
        return results;
    }

    public List getDisabledItemAndDescendants(TreeListItem item) {
        ArrayList<TreeListItem> results = new ArrayList<TreeListItem>();
        if (item != null) {
            if (!item.isEnabled()) {
                results.add(item);
            }
            List children = item.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                TreeListItem child = this.get(iter.next());
                results.addAll(this.getDisabledItemAndDescendants(child));
            }
        }
        return results;
    }

    public boolean isDescendant(TreeListItem item, TreeListItem parent) {
        List children = this.getChildren(parent);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            TreeListItem child = (TreeListItem)iter.next();
            if (child == item) {
                return true;
            }
            if (!this.isDescendant(item, child)) continue;
            return true;
        }
        return false;
    }

    public void checkItems(Set itemsToCheck) {
        Iterator iter = this.mItems.iterator();
        while (iter.hasNext()) {
            TreeListItem item = (TreeListItem)iter.next();
            item.setIsChecked(false);
        }
        Iterator iter2 = itemsToCheck.iterator();
        while (iter2.hasNext()) {
            Object element = iter2.next();
            if (!(element instanceof TreeListItem)) continue;
            TreeListItem item = (TreeListItem)element;
            item.setIsChecked(true);
        }
    }

    public void checkItemAndDescendants(TreeListItem item, boolean state, boolean leavesOnly) {
        List itemAndDescendants = this.getItemAndDescendants(item, leavesOnly);
        Iterator iter = itemAndDescendants.iterator();
        while (iter.hasNext()) {
            TreeListItem childItem = (TreeListItem)iter.next();
            childItem.setIsChecked(state);
        }
    }

    public void checkItemAndChildren(TreeListItem item, boolean state, boolean leavesOnly) {
        List itemAndChildren = this.getItemAndChildren(item, leavesOnly);
        Iterator iter = itemAndChildren.iterator();
        while (iter.hasNext()) {
            TreeListItem childItem = (TreeListItem)iter.next();
            childItem.setIsChecked(state);
        }
    }

    public void checkParents(TreeListItem item, boolean state) {
        List parents = this.getParents(item);
        Iterator iter = parents.iterator();
        while (iter.hasNext()) {
            TreeListItem parentItem = (TreeListItem)iter.next();
            parentItem.setIsChecked(state);
        }
    }

    public void checkTopLevelItems(boolean state) {
        Collection topLevelItems = this.getTopLevelItems();
        Iterator iter = topLevelItems.iterator();
        while (iter.hasNext()) {
            TreeListItem topLevelItem = (TreeListItem)iter.next();
            topLevelItem.setIsChecked(state);
        }
    }

    public void checkEnabledItems(boolean state) {
        Iterator iter = this.mItems.iterator();
        while (iter.hasNext()) {
            TreeListItem item = (TreeListItem)iter.next();
            if (!item.isEnabled()) continue;
            item.setIsChecked(state);
        }
    }

    private void addCheckStateListener(TreeListItem selectedItem) {
        this.mCheckstateListener = new TreeListCheckStateListener(this, this.mTreeList, this.mWizardPage, selectedItem, this.mValidation);
        this.mTreeList.addCheckStateListener(this.mCheckstateListener);
        this.mTreeList.addLogicalCheckStateListener(this.mCheckstateListener);
    }

    private void addSelectionChangedListener() {
        this.mTreeSelectionChangedListener = new TreeListSelectionChangedListener(this.mTreeList, this.mWizardPage);
        this.mTreeList.addSelectionChangedListener(2, this.mTreeSelectionChangedListener);
        if (!this.mTreeList.getListEditable()) {
            this.mListSelectionChangedListener = new TreeListSelectionChangedListener(this.mTreeList, this.mWizardPage);
            this.mTreeList.addSelectionChangedListener(1, this.mListSelectionChangedListener);
        }
    }

    private void addTreeViewerListener() {
    }

    private void removeListeners() {
        this.mTreeList.removeCheckStateListener(this.mCheckstateListener);
        this.mTreeList.removeLogicalCheckStateListener(this.mCheckstateListener);
        this.mTreeList.removeSelectionChangedListener(this.mTreeSelectionChangedListener);
        if (this.mListSelectionChangedListener != null) {
            this.mTreeList.removeSelectionChangedListener(this.mListSelectionChangedListener);
        }
    }

    public void initializeTreeList(WizardPage page, Object treeListRoot, Object selectedElement, int expandLevel, IProgressMonitor monitor) {
        this.mWizardPage = page;
        ViewerSorter sorter = this.mTreeList.getListViewer().getSorter();
        if (sorter instanceof TreeListItemSorter) {
            TreeListItemSorter treeListSorter = (TreeListItemSorter)sorter;
            treeListSorter.setTreeViewer((TreeViewer)this.mTreeList.getTreeViewer());
        }
        TreeListItem selectedItem = null;
        if (selectedElement != null) {
            selectedItem = this.get(selectedElement);
        }
        this.removeListeners();
        this.mTreeList.clearCheckState();
        this.addCheckStateListener(selectedItem);
        this.addSelectionChangedListener();
        this.addTreeViewerListener();
        this.mTreeList.setRoot(treeListRoot);
        this.mTreeList.aboutToOpen();
        if (selectedItem != null) {
            StructuredSelection selection = new StructuredSelection((Object)selectedItem);
            this.mTreeList.getTreeViewer().setSelection((ISelection)selection);
            this.mTreeList.getTreeViewer().expandToLevel((Object)selectedItem, 1);
        } else {
            this.mTreeList.getTreeViewer().expandToLevel(expandLevel);
        }
        this.mTreeList.setDisabledElements(this.getDisabledItems().toArray());
        List checkedItems = this.getCheckedAndEnabledItems();
        ArrayList<TreeListItem> itemsToCheck = new ArrayList<TreeListItem>();
        ArrayList temporaryCheckedChildren = new ArrayList();
        Iterator checkedIterator = checkedItems.iterator();
        while (checkedIterator.hasNext()) {
            TreeListItem item = (TreeListItem)checkedIterator.next();
            if (!item.isNode()) {
                itemsToCheck.add(item);
                continue;
            }
            List children = this.getChildren(item);
            if (children.isEmpty()) {
                itemsToCheck.add(item);
                continue;
            }
            if (!this.getCheckedChildren(item).isEmpty()) continue;
            temporaryCheckedChildren.add(children.get(0));
        }
        this.mTreeList.setCheckedElements(itemsToCheck.toArray());
        Object[] temporaryCheckedChildrenArray = temporaryCheckedChildren.toArray();
        this.mTreeList.setCheckedElements(temporaryCheckedChildrenArray);
        this.mTreeList.toggleElements(temporaryCheckedChildrenArray);
    }

    public void setTreeListEditable(WizardPage page, CellEditor[] cellEditors, TreeListItemCellModifier cellModifier, TreeListItemCellValidator cellValidator) {
        this.mWizardPage = page;
        cellValidator.registerValidationCallback(this.mTreeList, this.mWizardPage, this, this.mValidation);
        cellModifier.registerValidationCallback(this.mTreeList, this.mWizardPage, this, this.mValidation);
        int i = 0;
        while (i < cellEditors.length) {
            CellEditor editor = cellEditors[i];
            editor.addListener((ICellEditorListener)cellModifier);
            ++i;
        }
        this.mTreeList.setListEditable(cellEditors, cellModifier, cellValidator);
    }

    private void buildChildTreeListItems(ITreeContentProvider contentProvider, IPropertyProvider propertyProvider, Object[] properties, Object root, boolean isTopLevelItem, TreeListValidationService validation, IProgressMonitor monitor, int level, PrintStream dumper) {
        Object[] children;
        Object parent = contentProvider.getParent(root);
        PropertyMap propertyMap = new PropertyMap();
        if (propertyProvider != null) {
            int i = 0;
            while (i < properties.length) {
                if (properties[i] instanceof String) {
                    String propertyName = (String)properties[i];
                    Object propertyValue = propertyProvider.getValue(root, propertyName);
                    propertyMap.put(propertyName, propertyValue);
                }
                ++i;
            }
        }
        TreeListItem item = new TreeListItem(root, isTopLevelItem, false, parent, null, propertyMap, null);
        if (monitor != null) {
            monitor.worked(1);
        }
        if (dumper != null) {
            this.dumpItem(item, level, dumper);
        }
        if ((children = contentProvider.getChildren(root)) == null || children.length == 0) {
            item.setChildren(new ArrayList());
        } else {
            item.setChildren(new ArrayList<Object>(Arrays.asList(children)));
            int j = 0;
            while (j < children.length) {
                this.buildChildTreeListItems(contentProvider, propertyProvider, properties, children[j], false, validation, monitor, ++level, dumper);
                --level;
                ++j;
            }
        }
        this.mItems.add(item);
    }

    public static void displayWizardMessages(WizardPage page, IStatus result) {
        if (result == null) {
            page.setErrorMessage(null);
            page.setMessage(null);
            return;
        }
        switch (result.getSeverity()) {
            case 4: {
                page.setErrorMessage(result.getMessage());
                page.setMessage(null);
                break;
            }
            case 2: {
                page.setMessage(result.getMessage(), result.getSeverity());
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(result.getMessage(), result.getSeverity());
                page.setErrorMessage(null);
                break;
            }
            default: {
                page.setMessage(null);
                page.setErrorMessage(null);
            }
        }
    }

    private void checkBuildKeyMap() {
        if (this.mItemForKey == null) {
            this.mItemForKey = new HashMap();
            Iterator iter = this.mItems.iterator();
            while (iter.hasNext()) {
                TreeListItem item = (TreeListItem)iter.next();
                this.mItemForKey.put(item.getElement(), item);
            }
        }
    }

    private void checkBuildTopLevelKeyMap() {
        if (this.mTopLevelItemForKey == null) {
            this.mTopLevelItemForKey = new HashMap();
            Iterator iter = this.mItems.iterator();
            while (iter.hasNext()) {
                TreeListItem item = (TreeListItem)iter.next();
                if (!item.isTopLevelItem()) continue;
                this.mTopLevelItemForKey.put(item.getElement(), item);
            }
        }
    }

    private void dumpItem(TreeListItem item, int level, PrintStream stream) {
        stream.println();
        int i = 0;
        while (i < level) {
            stream.print("  ");
            ++i;
        }
        stream.print(item.getProperties().getValue(0));
    }
}

