/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.treelist;

import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.CheckboxTreeAndList;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListValidationService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.TableItem;

public class TreeListItemCellValidator
implements ICellEditorValidator {
    protected CheckboxTreeAndList mTreeList;
    protected WizardPage mPage;
    protected TreeListItemHelper mHelper;
    protected TreeListValidationService mValidation;

    public void registerValidationCallback(CheckboxTreeAndList treeList, WizardPage page, TreeListItemHelper helper, TreeListValidationService validation) {
        this.mTreeList = treeList;
        this.mPage = page;
        this.mHelper = helper;
        this.mValidation = validation;
    }

    public String isValid(Object value) {
        Object object = null;
        Object message = null;
        String columnProperty = this.mTreeList.getColumnToEdit();
        if (columnProperty == null) {
            return null;
        }
        TableItem[] items = this.mTreeList.getListTable().getSelection();
        object = items.length == 0 ? this.mTreeList.getListTable().getItem(0).getData() : items[0].getData();
        if (!(object instanceof TreeListItem)) {
            return null;
        }
        TreeListItem item = (TreeListItem)object;
        IStatus result = this.mValidation.validateSingleItem(item, columnProperty, value, true);
        if (result != null) {
            switch (result.getSeverity()) {
                case 4: {
                    this.mPage.setErrorMessage(result.getMessage());
                    return result.getMessage();
                }
                case 2: {
                    this.mPage.setMessage(result.getMessage(), result.getSeverity());
                    return null;
                }
                case 1: {
                    this.mPage.setMessage(result.getMessage(), result.getSeverity());
                    return null;
                }
            }
        }
        this.mPage.setErrorMessage(null);
        this.mPage.setMessage(null);
        return null;
    }
}

