/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.treelist;

import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.CheckboxTreeAndList;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.PropertyMap;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListValidationService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;

public class TreeListItemCellModifier
implements ICellModifier,
ICellEditorListener {
    protected CheckboxTreeAndList mTreeList;
    protected WizardPage mPage;
    protected TreeListItemHelper mHelper;
    protected TreeListValidationService mValidation;
    protected TreeListItem mCurrentItem;

    public void registerValidationCallback(CheckboxTreeAndList treeList, WizardPage page, TreeListItemHelper helper, TreeListValidationService validation) {
        this.mTreeList = treeList;
        this.mPage = page;
        this.mHelper = helper;
        this.mValidation = validation;
    }

    public boolean canModify(Object element, String property) {
        if (element instanceof TreeListItem) {
            TreeListItem item;
            this.mCurrentItem = item = (TreeListItem)element;
            if (item.isEnabled()) {
                return true;
            }
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        if (element instanceof TreeListItem) {
            TreeListItem item;
            this.mCurrentItem = item = (TreeListItem)element;
            return item.getProperties().getValue(property);
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        Object modifiedElement = element;
        if (element instanceof Item) {
            modifiedElement = ((Item)element).getData();
        }
        if (!(modifiedElement instanceof TreeListItem)) {
            return;
        }
        this.mCurrentItem = (TreeListItem)modifiedElement;
        if (value == null) {
            return;
        }
        this.mCurrentItem.getProperties().putValue(property, value);
        Iterator iter = this.mHelper.getItems().iterator();
        while (iter.hasNext()) {
            TreeListItem currentItem = (TreeListItem)iter.next();
            if (currentItem.getValidationResult() == null || currentItem.getValidationResult().isOK()) continue;
            PropertyMap itemProperties = currentItem.getProperties();
            IStatus result = this.mValidation.validateSingleItem(currentItem, property, itemProperties.getValue(property), true);
        }
        this.updateTreeItems();
        this.mTreeList.getListViewer().refresh(true);
        this.mPage.setPageComplete(true);
        if (element instanceof Item) {
            TableItem tableItem = (TableItem)element;
            int idx = this.mTreeList.getListTable().indexOf(tableItem);
            if (idx + 1 < this.mTreeList.getListTable().getItemCount()) {
                this.mTreeList.getListTable().setSelection(idx + 1);
            }
        }
    }

    public void cancelEditor() {
        this.mPage.setErrorMessage(null);
        if (this.mCurrentItem != null) {
            this.mValidation.validateSingleItem(this.mCurrentItem, true);
        }
        this.mPage.setPageComplete(true);
    }

    public void applyEditorValue() {
        this.mPage.setErrorMessage(null);
        if (this.mCurrentItem != null) {
            this.mValidation.validateSingleItem(this.mCurrentItem, true);
        }
        this.mPage.setPageComplete(true);
    }

    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
    }

    private void updateTreeItems() {
        HashSet<Object> visibleElements = new HashSet<Object>(Arrays.asList(this.mTreeList.getTreeViewer().getVisibleExpandedElements()));
        HashSet children = new HashSet();
        Iterator iter = visibleElements.iterator();
        while (iter.hasNext()) {
            children.addAll(this.mHelper.getChildren((TreeListItem)iter.next()));
        }
        visibleElements.addAll(children);
        this.mTreeList.getTreeViewer().update(visibleElements.toArray(), null);
    }
}

