/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.treelist;

import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.CheckboxTreeAndList;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.ListRoot;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.LogicalCheckedTreeViewer;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListValidationService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;

public class TreeListCheckStateListener
implements ICheckStateListener,
LogicalCheckedTreeViewer.ILogicalCheckStateListener {
    protected TreeListItemHelper mHelper;
    protected CheckboxTreeAndList mTreeList;
    protected WizardPage mPage;
    protected TreeListValidationService mValidation;
    protected TreeListItem mSourceItem;

    public TreeListCheckStateListener(TreeListItemHelper helper, CheckboxTreeAndList treeList, WizardPage page, TreeListItem sourceItem, TreeListValidationService validation) {
        this.mHelper = helper;
        this.mTreeList = treeList;
        this.mPage = page;
        this.mValidation = validation;
        this.mSourceItem = sourceItem;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        List childNodes;
        if (!(event.getElement() instanceof TreeListItem)) {
            return;
        }
        TreeListItem checkedItem = (TreeListItem)event.getElement();
        Object selectedElement = ((IStructuredSelection)this.mTreeList.getTreeViewer().getSelection()).getFirstElement();
        TreeListItem selectedItem = null;
        if (selectedElement instanceof TreeListItem) {
            selectedItem = (TreeListItem)selectedElement;
        }
        if (checkedItem.isEnabled() && !(childNodes = this.mHelper.getChildNodes(checkedItem)).isEmpty()) {
            this.mTreeList.getTreeViewer().expandToLevel((Object)checkedItem, 1);
        }
        HashSet<Object> visibleElements = new HashSet<Object>(Arrays.asList(this.mTreeList.getTreeViewer().getVisibleExpandedElements()));
        HashSet children = new HashSet();
        Iterator iter = visibleElements.iterator();
        while (iter.hasNext()) {
            TreeListItem item = (TreeListItem)iter.next();
            children.addAll(this.mHelper.getChildren(item));
        }
        visibleElements.addAll(children);
        if (selectedItem != null) {
            IStatus result = this.mValidation.validateSingleItem(selectedItem, true);
            TreeListItemHelper.displayWizardMessages(this.mPage, result);
        }
        this.mTreeList.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)checkedItem));
        selectedItem = checkedItem;
        if (checkedItem.isEnabled()) {
            this.mTreeList.getListViewer().setInput((Object)new ListRoot(selectedItem));
            this.mTreeList.getTreeViewer().update(visibleElements.toArray(), null);
            this.mPage.setPageComplete(this.mValidation.validateForWizardPageCompleteness());
        }
    }

    public void logicalCheckStateChanged(Object element, boolean checked, boolean grayed) {
        if (element instanceof TreeListItem) {
            TreeListItem checkedItem = (TreeListItem)element;
            checkedItem.setIsChecked(checked);
            if (checkedItem.isEnabled() && (checked || !checked && checkedItem.getValidationResult() != null && !checkedItem.getValidationResult().isOK())) {
                this.mValidation.validateSingleItem(checkedItem, true);
            }
        }
    }
}

