/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.treelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class LogicalCheckedTreeViewer {
    public static final int LOGIC_TYPE_CONTEXT = 99;
    private CheckboxTreeViewer mCheckboxTreeViewer;
    private ITreeContentProvider mTreeContentProvider;
    private List mCheckedElements;
    private List mGrayedElements;
    private List mPreGrayedElements;
    private InnerBaseCheckStateListener mCheckStateListener;
    private List mCheckStateListeners = new ArrayList();
    private List mLogicalCheckStateListeners = new ArrayList();

    public LogicalCheckedTreeViewer(CheckboxTreeViewer checkboxTreeViewer) {
        if (checkboxTreeViewer == null) {
            throw new IllegalArgumentException("CheckboxTreeViewer must not be null");
        }
        this.mCheckboxTreeViewer = checkboxTreeViewer;
        this.setSelectionLogicType(99);
    }

    private ITreeContentProvider getContentProvider() {
        return this.mTreeContentProvider;
    }

    public CheckboxTreeViewer getCheckboxTreeViewer() {
        return this.mCheckboxTreeViewer;
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        if (listener != null && !this.mCheckStateListeners.contains(listener)) {
            this.mCheckStateListeners.add(listener);
        }
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        if (listener != null && this.mCheckStateListeners.contains(listener)) {
            this.mCheckStateListeners.remove(listener);
        }
    }

    public void addLogicalCheckStateListener(ILogicalCheckStateListener listener) {
        if (listener != null && !this.mLogicalCheckStateListeners.contains(listener)) {
            this.mLogicalCheckStateListeners.add(listener);
        }
    }

    public void removeLogicalCheckStateListener(ILogicalCheckStateListener listener) {
        if (listener != null && this.mLogicalCheckStateListeners.contains(listener)) {
            this.mLogicalCheckStateListeners.remove(listener);
        }
    }

    private void notifyCheckStateListeners(CheckStateChangedEvent event) {
        Iterator iter = this.mCheckStateListeners.iterator();
        while (iter.hasNext()) {
            ICheckStateListener listener = (ICheckStateListener)iter.next();
            listener.checkStateChanged(event);
        }
    }

    private void notifyLogicalCheckStateListeners(Object element, boolean checked, boolean grayed) {
        Iterator iter = this.mLogicalCheckStateListeners.iterator();
        while (iter.hasNext()) {
            ILogicalCheckStateListener listener = (ILogicalCheckStateListener)iter.next();
            listener.logicalCheckStateChanged(element, checked, grayed);
        }
    }

    private InnerBaseCheckStateListener getCheckStateListener() {
        return this.mCheckStateListener;
    }

    public void clearSelection() {
        List checked = this.getStoredChecked();
        Iterator iter = checked.iterator();
        while (iter.hasNext()) {
            this.mCheckboxTreeViewer.setChecked(iter.next(), false);
        }
        checked.clear();
        List grayed = this.getStoredGrayed();
        Iterator iter2 = grayed.iterator();
        while (iter2.hasNext()) {
            this.mCheckboxTreeViewer.setGrayed(iter2.next(), false);
        }
        grayed.clear();
    }

    void clearCheckState() {
        this.getStoredChecked().clear();
        this.getStoredGrayed().clear();
    }

    private List getStoredChecked() {
        if (this.mCheckedElements == null) {
            this.mCheckedElements = new ArrayList();
        }
        return this.mCheckedElements;
    }

    private List getStoredGrayed() {
        if (this.mGrayedElements == null) {
            this.mGrayedElements = new ArrayList();
        }
        return this.mGrayedElements;
    }

    private List getPreGrayed() {
        return this.mPreGrayedElements == null ? Collections.EMPTY_LIST : this.mPreGrayedElements;
    }

    public void preCheckElements(Object[] elements) {
        List preGrayed = this.getPreGrayed();
        int i = 0;
        while (i < elements.length) {
            if (!preGrayed.contains(elements[i])) {
                this.mCheckboxTreeViewer.setChecked(elements[i], true);
                if (this.getCheckStateListener() != null) {
                    this.getCheckStateListener().checkElement(elements[i], true);
                }
            }
            ++i;
        }
    }

    public void preCheckElementSingle(Object element, boolean grayed) {
        if (this.getPreGrayed().contains(element)) {
            return;
        }
        if (grayed) {
            this.mCheckboxTreeViewer.setGrayChecked(element, true);
        } else {
            this.mCheckboxTreeViewer.setChecked(element, true);
        }
        this.setCheckedState(element, true, grayed);
    }

    public void preGrayElements(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.mCheckboxTreeViewer.setGrayed(elements[i], true);
            this.setCheckedState(elements, false, true);
            ++i;
        }
        this.mPreGrayedElements = Arrays.asList(elements);
    }

    public void refreshTreeViewer() {
        if (this.mCheckboxTreeViewer != null) {
            this.mCheckboxTreeViewer.refresh();
        }
    }

    private void setCheckedState(Object element, boolean checkedState, boolean grayedState) {
        if (checkedState) {
            if (!this.getStoredChecked().contains(element)) {
                this.getStoredChecked().add(element);
            }
        } else {
            this.getStoredChecked().remove(element);
        }
        if (grayedState) {
            if (!this.getStoredGrayed().contains(element)) {
                this.getStoredGrayed().add(element);
            }
        } else {
            this.getStoredGrayed().remove(element);
        }
        if (!this.getPreGrayed().contains(element)) {
            this.notifyLogicalCheckStateListeners(element, checkedState, grayedState);
        }
    }

    private void setCheckStateListener(InnerBaseCheckStateListener listener) {
        if (this.getCheckStateListener() != null) {
            this.mCheckboxTreeViewer.removeCheckStateListener((ICheckStateListener)this.getCheckStateListener());
        }
        this.mCheckStateListener = listener;
        this.mCheckboxTreeViewer.addCheckStateListener((ICheckStateListener)listener);
    }

    public void setContentProvider(ITreeContentProvider lProvider) {
        this.mTreeContentProvider = lProvider;
        if (this.mCheckboxTreeViewer != null) {
            this.mCheckboxTreeViewer.setContentProvider((IContentProvider)lProvider);
            this.refreshTreeViewer();
        }
    }

    public void setLabelProvider(ILabelProvider lProvider) {
        if (this.mCheckboxTreeViewer != null) {
            this.mCheckboxTreeViewer.setLabelProvider((IBaseLabelProvider)lProvider);
        }
    }

    public void setTreeInput(Object treeInput) {
        if (this.mCheckboxTreeViewer != null) {
            this.mCheckboxTreeViewer.setInput(treeInput);
        }
    }

    public void setSelectionLogicType(int type) {
        ContextLogic checkListener = null;
        switch (type) {
            case 99: {
                checkListener = new ContextLogic(this.mCheckboxTreeViewer);
                break;
            }
        }
        this.setCheckStateListener(checkListener);
    }

    public void toggleElement(Object element) {
        this.toggleElements(new Object[]{element});
    }

    public void toggleElements(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            boolean newState = this.mCheckboxTreeViewer.getChecked(elements[i]) ^ true;
            this.mCheckboxTreeViewer.setChecked(elements[i], newState);
            if (this.getCheckStateListener() != null) {
                this.getCheckStateListener().checkElement(elements[i], newState);
            }
            ++i;
        }
    }

    public static interface ILogicalCheckStateListener {
        public void logicalCheckStateChanged(Object var1, boolean var2, boolean var3);
    }

    class ContextLogic
    extends InnerBaseCheckStateListener {
        public ContextLogic(CheckboxTreeViewer viewer) {
            super(viewer);
        }

        protected void checkElement(Object element, boolean state) {
            Object checkedElement = element;
            boolean checkState = state;
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this, checkedElement, checkState){
                private final /* synthetic */ Object val$checkedElement;
                private final /* synthetic */ boolean val$checkState;
                private final /* synthetic */ ContextLogic this$1;
                {
                    this.this$1 = this$1;
                    this.val$checkedElement = val$checkedElement;
                    this.val$checkState = val$checkState;
                }

                public void run() {
                    ContextLogic.access$300(this.this$1, this.val$checkedElement, this.val$checkState);
                    ContextLogic.access$400(this.this$1, this.val$checkedElement, this.val$checkState);
                }
            });
        }

        private void checkElementsDownward(Object checkedElement, boolean checkState) {
            if (LogicalCheckedTreeViewer.this.getPreGrayed().contains(checkedElement)) {
                this.getTreeViewer().setChecked(checkedElement, false);
                this.getTreeViewer().setGrayed(checkedElement, true);
                return;
            }
            boolean checkElement = checkState;
            boolean grayElement = false;
            Object[] relevantChildren = this.EMPTY_OBJ_AR;
            boolean checkChildren = checkState;
            boolean grayChildren = false;
            Object[] children = this.getChildren(checkedElement);
            Object[] childLeaves = this.getChildLeaves(checkedElement);
            Object[] childNodes = this.getChildNodes(checkedElement);
            if (checkState) {
                if (children.length > childLeaves.length) {
                    checkElement = true;
                    grayElement = true;
                } else {
                    checkElement = true;
                    grayElement = false;
                }
                relevantChildren = childLeaves;
                checkChildren = true;
                grayChildren = false;
            } else if (this.countChecked(childLeaves) == childLeaves.length || this.countChecked(children) == 0) {
                checkElement = false;
                grayElement = false;
                relevantChildren = this.getAllChildren(checkedElement);
                checkChildren = false;
                grayChildren = false;
            } else {
                if (this.countChecked(childNodes) == childNodes.length && this.countGrayed(childNodes) == 0) {
                    checkElement = true;
                    grayElement = false;
                } else {
                    checkElement = true;
                    grayElement = true;
                }
                relevantChildren = childLeaves;
                checkChildren = true;
                grayChildren = false;
            }
            this.getTreeViewer().setChecked(checkedElement, checkElement);
            this.getTreeViewer().setGrayed(checkedElement, grayElement);
            LogicalCheckedTreeViewer.this.setCheckedState(checkedElement, checkElement, grayElement);
            int i = 0;
            while (i < relevantChildren.length) {
                if (!LogicalCheckedTreeViewer.this.getPreGrayed().contains(relevantChildren[i])) {
                    this.getTreeViewer().setChecked(relevantChildren[i], checkChildren);
                    this.getTreeViewer().setGrayed(relevantChildren[i], grayChildren);
                    LogicalCheckedTreeViewer.this.setCheckedState(relevantChildren[i], checkChildren, grayChildren);
                }
                ++i;
            }
        }

        private void checkElementsUpward(Object checkedElement, boolean newCheckState) {
            Object parent = this.getParent((TreeViewer)this.getTreeViewer(), checkedElement);
            List preGrayed = LogicalCheckedTreeViewer.this.getPreGrayed();
            if (preGrayed.contains(checkedElement)) {
                return;
            }
            if (parent == null) {
                return;
            }
            if (preGrayed.contains(parent)) {
                return;
            }
            boolean check = false;
            boolean gray = false;
            Object[] siblings = this.getSiblings((TreeViewer)this.getTreeViewer(), checkedElement);
            int checkedNum = this.countChecked(siblings);
            int grayedNum = this.countGrayed(siblings);
            if (grayedNum == 0) {
                if (checkedNum == 0) {
                    gray = true;
                    check = true;
                } else if (checkedNum == siblings.length) {
                    gray = false;
                    check = true;
                } else {
                    gray = true;
                    check = true;
                }
            } else {
                gray = true;
                check = true;
            }
            if (gray || check) {
                this.getTreeViewer().setGrayed(parent, gray);
                this.getTreeViewer().setChecked(parent, check);
                LogicalCheckedTreeViewer.this.setCheckedState(parent, check, gray);
                this.checkElementsUpward(parent, true);
            }
        }

        static /* synthetic */ void access$300(ContextLogic x0, Object x1, boolean x2) {
            x0.checkElementsDownward(x1, x2);
        }

        static /* synthetic */ void access$400(ContextLogic x0, Object x1, boolean x2) {
            x0.checkElementsUpward(x1, x2);
        }
    }

    abstract class InnerBaseCheckStateListener
    implements ICheckStateListener {
        protected final Object[] EMPTY_OBJ_AR = new Object[0];
        private CheckboxTreeViewer mTreeViewer;

        public InnerBaseCheckStateListener(CheckboxTreeViewer viewer) {
            this.mTreeViewer = viewer;
        }

        private void addChilds(ITreeContentProvider tcp, Object element, List list) {
            Object[] ch = tcp.getChildren(element);
            list.addAll(Arrays.asList(ch));
            int i = 0;
            while (i < ch.length) {
                this.addChilds(tcp, ch[i], list);
                ++i;
            }
        }

        protected abstract void checkElement(Object var1, boolean var2);

        public void checkStateChanged(CheckStateChangedEvent event) {
            this.checkElement(event.getElement(), event.getChecked());
            LogicalCheckedTreeViewer.this.notifyCheckStateListeners(event);
        }

        protected int countChecked(Object[] elements) {
            int ret = 0;
            List preGrayed = LogicalCheckedTreeViewer.this.getPreGrayed();
            int i = 0;
            while (i < elements.length) {
                if (this.getTreeViewer().getChecked(elements[i]) && !preGrayed.contains(elements[i])) {
                    ++ret;
                }
                ++i;
            }
            return ret;
        }

        protected int countGrayed(Object[] elements) {
            int ret = 0;
            List preGrayed = LogicalCheckedTreeViewer.this.getPreGrayed();
            int i = 0;
            while (i < elements.length) {
                if (this.getTreeViewer().getGrayed(elements[i]) && !preGrayed.contains(elements[i])) {
                    ++ret;
                }
                ++i;
            }
            return ret;
        }

        protected Object[] getAllChildren(Object element) {
            ArrayList list = new ArrayList();
            this.addChilds(LogicalCheckedTreeViewer.this.getContentProvider(), element, list);
            return this.filterPreGrayed(list);
        }

        protected Object[] getChildren(Object element) {
            ITreeContentProvider provider = LogicalCheckedTreeViewer.this.getContentProvider();
            return this.filterPreGrayed(provider.getChildren(element));
        }

        protected Object[] getChildLeaves(Object element) {
            ArrayList<Object> result = new ArrayList<Object>();
            List preGrayed = LogicalCheckedTreeViewer.this.getPreGrayed();
            ITreeContentProvider provider = LogicalCheckedTreeViewer.this.getContentProvider();
            Object[] children = this.getChildren(element);
            int i = 0;
            while (i < children.length) {
                if (!provider.hasChildren(children[i]) && !preGrayed.contains(children[i])) {
                    result.add(children[i]);
                }
                ++i;
            }
            return result.toArray();
        }

        protected Object[] getChildNodes(Object element) {
            ArrayList<Object> result = new ArrayList<Object>();
            List preGrayed = LogicalCheckedTreeViewer.this.getPreGrayed();
            ITreeContentProvider provider = LogicalCheckedTreeViewer.this.getContentProvider();
            Object[] children = this.getChildren(element);
            int i = 0;
            while (i < children.length) {
                if (provider.hasChildren(children[i]) && !preGrayed.contains(children[i])) {
                    result.add(children[i]);
                }
                ++i;
            }
            return result.toArray();
        }

        protected Object getParent(TreeViewer treeViewer, Object element) {
            return this.getTreeContentProvider(treeViewer).getParent(element);
        }

        protected Object[] getSiblings(TreeViewer tv, Object element) {
            Object parent = this.getTreeContentProvider(tv).getParent(element);
            return parent != null ? this.filterPreGrayed(this.getTreeContentProvider(tv).getChildren(parent)) : this.EMPTY_OBJ_AR;
        }

        protected Object[] getSiblingLeaves(Object element) {
            Object parent = LogicalCheckedTreeViewer.this.getContentProvider().getParent(element);
            return parent != null ? this.getChildLeaves(parent) : this.EMPTY_OBJ_AR;
        }

        private ITreeContentProvider getTreeContentProvider(TreeViewer treeViewer) {
            return (ITreeContentProvider)treeViewer.getContentProvider();
        }

        private Object[] filterPreGrayed(Object[] elements) {
            return this.filterPreGrayed(Arrays.asList(elements));
        }

        private Object[] filterPreGrayed(List elements) {
            ArrayList list = new ArrayList(elements);
            list.removeAll(LogicalCheckedTreeViewer.this.getPreGrayed());
            return list.toArray();
        }

        protected CheckboxTreeViewer getTreeViewer() {
            return this.mTreeViewer;
        }
    }
}

