/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.treelist;

import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.IPropertyProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListValidationService;
import com.sap.ide.webdynpro.ui.decorator.ImageDecorator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class GenericTreeLabelProvider
extends LabelProvider
implements IColorProvider {
    private TreeListItemHelper mHelper;
    private ILabelProvider mLabelProvider;
    protected IPropertyProvider mPropertyProvider;
    private ILabelProvider mDisabledStateProvider;
    protected TreeListValidationService mValidation;
    private ImageDecorator mDecorator = ImageDecorator.getInstance();
    protected static final String DEFAULT_LABEL = "";

    public GenericTreeLabelProvider(TreeListItemHelper helper, ILabelProvider customLabelProvider, ILabelProvider disabledStateProvider, IPropertyProvider propertyProvider, TreeListValidationService validation) {
        this.mHelper = helper;
        this.mLabelProvider = customLabelProvider;
        this.mDisabledStateProvider = disabledStateProvider;
        this.mPropertyProvider = propertyProvider;
        this.mValidation = validation;
    }

    public Image getImage(Object element) {
        Image baseImage = null;
        int errorType = 0;
        if (this.mLabelProvider == null || this.mHelper.getItems().isEmpty()) {
            return null;
        }
        if (!(element instanceof TreeListItem)) {
            return null;
        }
        TreeListItem item = (TreeListItem)element;
        if (item.isEnabled()) {
            baseImage = this.mLabelProvider.getImage(item.getElement());
        } else if (this.mDisabledStateProvider != null) {
            baseImage = this.mDisabledStateProvider.getImage(item.getElement());
        }
        if (!item.isChecked()) {
            return baseImage;
        }
        IStatus result = this.getResult(item, this.mHelper, 4);
        if (!result.isOK()) {
            errorType = 4;
        }
        if (result.isOK()) {
            result = this.getResult(item, this.mHelper, 2);
            if (!result.isOK()) {
                errorType = 2;
            }
            if (result.isOK() && !(result = this.getResult(item, this.mHelper, 1)).isOK()) {
                errorType = 1;
            }
        }
        if (errorType == 0) {
            return baseImage;
        }
        return this.mDecorator.decorate(baseImage, errorType);
    }

    public String getText(Object element) {
        TreeListItem item;
        String firstProperty;
        if (element instanceof TreeListItem && (firstProperty = (item = (TreeListItem)element).getProperties().getName(0)) != null) {
            return this.mPropertyProvider.getLabel(item, firstProperty);
        }
        return super.getText(element);
    }

    public void dispose() {
        this.mLabelProvider.dispose();
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        TreeListItem item;
        if (element instanceof TreeListItem && (item = (TreeListItem)element).isEnabled()) {
            return Display.getCurrent().getSystemColor(9);
        }
        return null;
    }

    public ILabelProvider getCustomLabelProvider() {
        return this.mLabelProvider;
    }

    protected IStatus getResult(TreeListItem item, TreeListItemHelper helper, int severity) {
        return this.mValidation.validateTreeListItemAndChildren(item, severity, true, false);
    }
}

