/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.treelist;

import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class GenericTreeContentProvider
implements ITreeContentProvider {
    private TreeListItemHelper mHelper;
    private ITreeContentProvider mContentProvider;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public GenericTreeContentProvider(TreeListItemHelper helper, ITreeContentProvider customContentProvider) {
        this.mHelper = helper;
        this.mContentProvider = customContentProvider;
    }

    public ITreeContentProvider getCustomContentProvider() {
        return this.mContentProvider;
    }

    public Object[] getChildren(Object parentElement) {
        TreeListItem item;
        List children;
        if (parentElement instanceof TreeListItem && (children = (item = (TreeListItem)parentElement).getChildren()) != null) {
            return this.mHelper.getItems(children).toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof TreeListItem) {
            TreeListItem item = (TreeListItem)element;
            return this.mHelper.get(item.getParent());
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Collection) {
            return ((Collection)inputElement).toArray();
        }
        return EMPTY_ARRAY;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

