/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.treelist;

import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.ListRoot;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.LogicalCheckedTreeViewer;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CheckboxTreeAndList
implements ICheckStateListener,
ISelectionChangedListener,
ITreeViewerListener {
    public static final String DEFAULT_COLUMN_PROPERTY = "defaultColumn";
    public static final int VIEWER_TYPE_LIST = 1;
    public static final int VIEWER_TYPE_TREE = 2;
    private Object mRoot;
    private Object mCurrentTreeSelection;
    private List mTreeViewerListeners = new ArrayList();
    private List mTreeSelectionChangedListeners = new ArrayList();
    private List mListSelectionChangedListeners = new ArrayList();
    private ITreeContentProvider mTreeContentProvider;
    private IStructuredContentProvider mListContentProvider;
    private ILabelProvider mTreeLabelProvider;
    private ILabelProvider mListLabelProvider;
    private String[] mColumnProperties;
    private ViewerSorter mTreeSorter;
    private ViewerSorter mListSorter;
    private CellEditor[] mCellEditors = new CellEditor[0];
    private ICellModifier mCellModifier;
    private ICellEditorValidator mCellValidator;
    private LogicalCheckedTreeViewer mLogicalTreeViewer;
    private TableViewer mListViewer;
    private int mCurrentListColumn = -1;

    public CheckboxTreeAndList(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, IStructuredContentProvider listContentProvider, ILabelProvider listLabelProvider, ViewerSorter treeSorter, ViewerSorter listSorter, int style, int width, int height) {
        this(parent, rootObject, treeContentProvider, treeLabelProvider, listContentProvider, listLabelProvider, treeSorter, listSorter, new String[]{DEFAULT_COLUMN_PROPERTY}, style, width, height);
    }

    public CheckboxTreeAndList(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, IStructuredContentProvider listContentProvider, ILabelProvider listLabelProvider, ViewerSorter treeSorter, ViewerSorter listSorter, String[] columnProperties, int style, int width, int height) {
        this.mRoot = rootObject;
        this.mTreeContentProvider = treeContentProvider;
        this.mListContentProvider = listContentProvider;
        this.mTreeLabelProvider = treeLabelProvider;
        this.mListLabelProvider = listLabelProvider;
        this.mTreeSorter = treeSorter;
        this.mListSorter = listSorter;
        this.mColumnProperties = columnProperties;
        this.createContents(parent, width, height, style);
    }

    public void aboutToOpen() {
        Object primary;
        Object[] elements = this.mTreeContentProvider.getElements(this.mRoot);
        Object object = primary = elements.length > 0 ? elements[0] : null;
        if (primary != null) {
            this.mLogicalTreeViewer.getCheckboxTreeViewer().setSelection((ISelection)new StructuredSelection(primary));
        }
        this.mLogicalTreeViewer.getCheckboxTreeViewer().getControl().setFocus();
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.mLogicalTreeViewer.addCheckStateListener(listener);
    }

    public void addTreeViewerListener(ITreeViewerListener listener) {
        this.mTreeViewerListeners.add(listener);
    }

    public void addSelectionChangedListener(int viewerType, ISelectionChangedListener listener) {
        if (viewerType == 1) {
            this.mListSelectionChangedListeners.add(listener);
        } else if (viewerType == 2) {
            this.mTreeSelectionChangedListeners.add(listener);
        }
    }

    public void addLogicalCheckStateListener(LogicalCheckedTreeViewer.ILogicalCheckStateListener listener) {
        this.mLogicalTreeViewer.addLogicalCheckStateListener(listener);
    }

    public void checkStateChanged(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.mLogicalTreeViewer.getCheckboxTreeViewer().getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (event.getCheckable().equals(CheckboxTreeAndList.this.mLogicalTreeViewer.getCheckboxTreeViewer())) {
                    CheckboxTreeAndList.this.populateListViewer(event.getElement());
                }
            }
        });
    }

    protected void createContents(Composite parent, int width, int height, int style) {
        IGridLayoutPane theGridLayoutPane = PaneFactory.createGridLayoutPane((Composite)parent, (int)1);
        ISashPane hostSashPane = theGridLayoutPane.addHorizontalSashPane(theGridLayoutPane.createGridLayoutData(4, 4, true, true, 1, 1));
        IGridLayoutPane treePane = hostSashPane.addGridLayoutPane(1);
        IGridLayoutPane listPane = hostSashPane.addGridLayoutPane(1);
        this.createTreeViewer(treePane);
        this.createListViewer(listPane);
        if (this.mColumnProperties != null && this.mColumnProperties.length > 1) {
            hostSashPane.setWeights(new int[]{8, 7});
        }
        this.initialize();
    }

    private void createListViewer(IGridLayoutPane listPane) {
        this.mListViewer = listPane.addTableViewer(false, listPane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.mListViewer.setContentProvider((IContentProvider)this.mListContentProvider);
        this.mListViewer.setLabelProvider((IBaseLabelProvider)this.mListLabelProvider);
        this.mListViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.mListSorter != null) {
            this.mListViewer.setSorter(this.mListSorter);
        }
        Table table = this.mListViewer.getTable();
        if (this.mColumnProperties.length == 1) {
            table.setHeaderVisible(false);
            table.getColumn(0).setWidth(200);
            table.getColumn(0).setText(this.mColumnProperties[0]);
        } else {
            table.setHeaderVisible(true);
            if (this.mColumnProperties != null && this.mColumnProperties.length > 0) {
                table.getColumn(0).setText(this.mColumnProperties[0]);
                table.getColumn(0).setWidth(80);
                int i = 1;
                while (i < this.mColumnProperties.length) {
                    TableColumn column = new TableColumn(table, 0);
                    column.setText(this.mColumnProperties[i]);
                    column.setWidth(50);
                    ++i;
                }
            }
        }
        this.mListViewer.setColumnProperties(this.mColumnProperties);
        this.mListViewer.getTable().addListener(3, (Listener)new CellEditorListener());
        this.mListViewer.getTable().addKeyListener((KeyListener)new CellEditorKeyListener());
    }

    private void createTreeViewer(IGridLayoutPane treePane) {
        CheckboxTreeViewer treeViewer = treePane.addCheckboxTreeViewer(false, treePane.createGridLayoutData(4, 4, true, true, 1, 1));
        treeViewer.setUseHashlookup(true);
        treeViewer.addTreeListener((ITreeViewerListener)this);
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.mTreeSorter != null) {
            treeViewer.setSorter(this.mTreeSorter);
        }
        this.mLogicalTreeViewer = new LogicalCheckedTreeViewer(treeViewer);
        this.mLogicalTreeViewer.setContentProvider(this.mTreeContentProvider);
        this.mLogicalTreeViewer.setLabelProvider(this.mTreeLabelProvider);
        this.mLogicalTreeViewer.addCheckStateListener(this);
    }

    protected int getListItemsSize(Object treeElement) {
        Object[] elements = this.mListContentProvider.getElements(treeElement);
        return elements.length;
    }

    public Table getListTable() {
        return this.mListViewer.getTable();
    }

    protected void initialize() {
        this.mLogicalTreeViewer.setTreeInput(this.mRoot);
    }

    protected void notifyTreeViewerListeners(TreeExpansionEvent event, boolean expanded) {
        Iterator listenersEnum = this.mTreeViewerListeners.iterator();
        while (listenersEnum.hasNext()) {
            if (expanded) {
                ((ITreeViewerListener)listenersEnum.next()).treeExpanded(event);
                continue;
            }
            ((ITreeViewerListener)listenersEnum.next()).treeCollapsed(event);
        }
    }

    protected void notifySelectionChangedListeners(SelectionChangedEvent event) {
        block3: {
            ISelectionProvider provider;
            block2: {
                provider = event.getSelectionProvider();
                if (!(provider instanceof TreeViewer)) break block2;
                Iterator listenersEnum = this.mTreeSelectionChangedListeners.iterator();
                while (listenersEnum.hasNext()) {
                    ((ISelectionChangedListener)listenersEnum.next()).selectionChanged(event);
                }
                break block3;
            }
            if (!(provider instanceof TableViewer)) break block3;
            Iterator listenersEnum = this.mListSelectionChangedListeners.iterator();
            while (listenersEnum.hasNext()) {
                ((ISelectionChangedListener)listenersEnum.next()).selectionChanged(event);
            }
        }
    }

    protected void populateListViewer(Object treeElement) {
        this.mListViewer.setInput((Object)new ListRoot(treeElement));
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.mLogicalTreeViewer.removeCheckStateListener(listener);
    }

    public void removeTreeViewerListener(ITreeViewerListener listener) {
        this.mTreeViewerListeners.remove(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.mListSelectionChangedListeners.contains(listener)) {
            this.mListSelectionChangedListeners.remove(listener);
        } else if (this.mTreeSelectionChangedListeners.contains(listener)) {
            this.mTreeSelectionChangedListeners.remove(listener);
        }
    }

    public void removeLogicalCheckStateListener(LogicalCheckedTreeViewer.ILogicalCheckStateListener listener) {
        this.mLogicalTreeViewer.removeLogicalCheckStateListener(listener);
    }

    void clearCheckState() {
        this.mLogicalTreeViewer.clearCheckState();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelectionProvider provider = event.getSelectionProvider();
        if (provider instanceof TreeViewer) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object selectedElement = selection.getFirstElement();
            if (selectedElement == null) {
                this.mCurrentTreeSelection = null;
                this.mListViewer.setInput((Object)new ListRoot(this.mCurrentTreeSelection));
                return;
            }
            if (selectedElement != this.mCurrentTreeSelection) {
                this.populateListViewer(selectedElement);
            }
            this.mCurrentTreeSelection = selectedElement;
        } else if (provider instanceof TableViewer) {
            // empty if block
        }
        this.notifySelectionChangedListeners(event);
    }

    public void setListProviders(IStructuredContentProvider contentProvider, ILabelProvider labelProvider) {
        this.mListContentProvider = contentProvider;
        this.mListLabelProvider = labelProvider;
        this.mListViewer.setContentProvider((IContentProvider)contentProvider);
        this.mListViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setListSorter(ViewerSorter sorter) {
        this.mListViewer.setSorter(sorter);
    }

    public void setRoot(Object newRoot) {
        this.mRoot = newRoot;
        this.initialize();
    }

    public void setTreeProviders(ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        this.mTreeContentProvider = contentProvider;
        this.mTreeLabelProvider = labelProvider;
        this.mLogicalTreeViewer.setContentProvider(contentProvider);
        this.mLogicalTreeViewer.setLabelProvider(labelProvider);
    }

    public void setTreeSorter(ViewerSorter sorter) {
        this.mLogicalTreeViewer.getCheckboxTreeViewer().setSorter(sorter);
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        this.notifyTreeViewerListeners(event, false);
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Object item = event.getElement();
        this.notifyTreeViewerListeners(event, true);
    }

    public TableViewer getListViewer() {
        return this.mListViewer;
    }

    public CheckboxTreeViewer getTreeViewer() {
        return this.mLogicalTreeViewer.getCheckboxTreeViewer();
    }

    public void setDisabledElements(Object[] elements) {
        this.mLogicalTreeViewer.preGrayElements(elements);
    }

    public void setCheckedElements(Object[] elements) {
        this.mLogicalTreeViewer.preCheckElements(elements);
    }

    public void toggleElements(Object[] elements) {
        this.mLogicalTreeViewer.toggleElements(elements);
    }

    public void setListEditable(CellEditor[] cellEditors, ICellModifier cellModifier, ICellEditorValidator cellValidator) {
        if (cellEditors != null && cellModifier != null && cellValidator != null) {
            this.mCellEditors = cellEditors;
            this.mCellModifier = cellModifier;
            this.mCellValidator = cellValidator;
            int i = 0;
            while (i < this.mCellEditors.length) {
                CellEditor editor = cellEditors[i];
                editor.setValidator(this.mCellValidator);
                ++i;
            }
            this.mListViewer.setCellEditors(this.mCellEditors);
            this.mListViewer.setCellModifier(this.mCellModifier);
        }
    }

    public boolean getListEditable() {
        return this.mCellEditors.length > 0 && this.mCellModifier != null && this.mCellValidator != null;
    }

    public String getColumnToEdit() {
        if (this.mCurrentListColumn > -1 && this.mCurrentListColumn < this.mColumnProperties.length) {
            return this.mColumnProperties[this.mCurrentListColumn];
        }
        return null;
    }

    private final class CellEditorKeyListener
    extends KeyAdapter {
        private CellEditorKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.stateMask == 0 && e.keyCode == 0x100000B) {
                if (CheckboxTreeAndList.this.mCellEditors.length == 0 || CheckboxTreeAndList.this.mCellModifier == null || CheckboxTreeAndList.this.mCellValidator == null) {
                    return;
                }
                Table table = (Table)e.widget;
                int idx = table.getSelectionIndex();
                if (idx != -1) {
                    CheckboxTreeAndList.this.mCurrentListColumn = 0;
                    CheckboxTreeAndList.this.mListViewer.editElement(CheckboxTreeAndList.this.mListViewer.getElementAt(idx), CheckboxTreeAndList.this.mCurrentListColumn);
                }
            }
        }
    }

    private final class CellEditorListener
    implements Listener {
        private CellEditorListener() {
        }

        public void handleEvent(Event event) {
            if (CheckboxTreeAndList.this.mCellEditors.length == 0 || CheckboxTreeAndList.this.mCellModifier == null || CheckboxTreeAndList.this.mCellValidator == null) {
                return;
            }
            Point pt = new Point(event.x, event.y);
            CheckboxTreeAndList.this.mCurrentListColumn = this.getColumnIndex(CheckboxTreeAndList.this.mListViewer.getTable(), pt);
        }

        private int getColumnIndex(Table table, Point clickPoint) {
            Rectangle clientRect = table.getClientArea();
            int columns = table.getColumnCount();
            int start = table.getTopIndex();
            int end = table.getItemCount();
            int row = start;
            while (row < end) {
                TableItem item = table.getItem(row);
                int column = 0;
                while (column < columns) {
                    Rectangle rect = item.getBounds(column);
                    if (rect.y > clientRect.y + clientRect.height) {
                        return -1;
                    }
                    if (rect.contains(clickPoint)) {
                        return column;
                    }
                    ++column;
                }
                ++row;
            }
            return -1;
        }
    }
}

