/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding;

import com.sap.ide.metamodel.dictionary.DtDictionaryObject;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.IItemValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListValidationService;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.ValidationResult;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.core.CheckServices;
import org.eclipse.core.runtime.IStatus;

public class StructureBindingWizardValidator
implements IItemValidator {
    private ContextWizardData mData;
    private TreeListItem mRootItem;
    private static final String CONTEXT_NAME = "Context";

    public StructureBindingWizardValidator(ContextWizardData data) {
        this.mData = data;
    }

    public IStatus validateItem(TreeListItem item, TreeListItemHelper helper, String columnProperty, Object value) {
        Object element = item.getElement();
        TextPool textPool = TextPool.getInstance();
        ContextElement sourceRootElement = this.mData.getSourceContextElement();
        String message = null;
        Object sourceParent = null;
        TreeListItem parentItem = helper.get(item.getParent());
        String name = null;
        if (columnProperty == null && value == null && item.getProperties().isEmpty()) {
            return null;
        }
        if (columnProperty == null && value == null && !item.getProperties().isEmpty()) {
            columnProperty = "Name";
            name = (String)item.getProperties().getValue("Name");
        } else if (columnProperty == "Name") {
            name = (String)value;
        } else {
            return null;
        }
        if ((element instanceof ContextAttribute || element instanceof DtStructureElement) && !name.equals((String)item.getProperties().getValue("Name"))) {
            message = textPool.getText(2017);
            return new ValidationResult(message, 4);
        }
        if (value != null && !CheckServices.isValidIdentifier((String)name)) {
            message = textPool.getText(2003, (Object)name);
            return new ValidationResult(message, 4);
        }
        boolean isDuplicate = false;
        if (item.isEnabled() && item.isChecked()) {
            if (name.equalsIgnoreCase(CONTEXT_NAME) && !item.isTopLevelItem()) {
                isDuplicate = true;
            } else if (element instanceof DtStructure || element instanceof ContextValueNode) {
                if (TreeListValidationService.isDuplicateName(item, helper, columnProperty, name)) {
                    isDuplicate = true;
                }
            } else if ((element instanceof DtStructureElement || element instanceof ContextValueAttribute) && TreeListValidationService.isDuplicateName(item, parentItem, helper, columnProperty, name)) {
                isDuplicate = true;
            }
        }
        if (isDuplicate) {
            message = textPool.getText(2007, (Object)name);
            return new ValidationResult(message, 4);
        }
        return TreeListValidationService.OK_RESULT;
    }

    public boolean isEnabled(TreeListItem item, TreeListItemHelper helper) {
        Object element = item.getElement();
        if (item.isTopLevelItem()) {
            return false;
        }
        if (item.getProperties().getValue("Bound structure element") != null) {
            if (element instanceof ContextElement) {
                if (!this.mData.isNewMode()) {
                    ContextElement parentElement = (ContextElement)element;
                    do {
                        if (parentElement != this.mData.getSourceContextElement()) continue;
                        return true;
                    } while ((parentElement = parentElement.getParent()) instanceof ContextElement);
                }
            } else if (element instanceof DtDictionaryObject) {
                return true;
            }
        }
        return false;
    }

    public boolean isNode(TreeListItem item, TreeListItemHelper helper) {
        return item.getElement() instanceof AbstractContextNode || item.getElement() instanceof DtStructure;
    }

    public boolean isChecked(TreeListItem item, TreeListItemHelper helper) {
        Object element = item.getElement();
        if (element instanceof ContextElement) {
            return CheckLayerHelper.hasStructureBinding((ContextElement)((ContextElement)element), (boolean)true);
        }
        return false;
    }
}

