/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding;

import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding.PageStructureBinding;
import com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding.PageStructureSelection;
import com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding.StructureBindingHelper;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class StructureBindingWizard
extends Wizard {
    private ContextWizardData mData;
    private PageStructureSelection mPageStructureSelection;
    private PageStructureBinding mPageStructureBinding;

    public StructureBindingWizard(ContextElement sourceElement, ControllerUsage[] controllerUsages, ControllerUsage defaultControllerUsage) {
        this.setNeedsProgressMonitor(true);
        this.mData = new ContextWizardData();
        this.mData.setSourceContextElement(sourceElement);
        this.mData.setControllerUsages(controllerUsages);
        this.mData.setDefaultControllerUsage(defaultControllerUsage);
        this.mData.setNewMode(false);
        this.setWindowTitle(TextPool.getInstance().getText(2317));
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage.equals(this.mPageStructureSelection)) {
            return false;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        DtStructure structure = this.mData.getSourceStructure();
        if (structure != null) {
            if (this.mData.getHelper() == null) {
                this.mPageStructureBinding.initializeItems(null);
                this.mData.getHelper().checkEnabledItems(true);
            }
            StructureBindingHelper.getInstance(this.mData).createAndBindStructure();
        }
        return true;
    }

    public void addPages() {
        this.mPageStructureSelection = new PageStructureSelection(this.mData);
        this.mPageStructureBinding = new PageStructureBinding(this.mData);
        ContextValueNode sourceNode = (ContextValueNode)this.mData.getSourceContextElement();
        if (!sourceNode.hasStructure()) {
            this.addPage((IWizardPage)this.mPageStructureSelection);
        } else {
            this.mData.setSourceStructure((DtStructure)sourceNode.getStructure());
        }
        this.addPage((IWizardPage)this.mPageStructureBinding);
    }
}

