/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding;

import com.sap.ide.metamodel.dictionary.DtDictionaryObject;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.IPropertyProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;

public class StructureBindingPropertyProvider
implements IPropertyProvider {
    private DtStructure mStructure;
    private ContextElement mSourceElement;
    private String mNewName;

    public StructureBindingPropertyProvider(ContextElement sourceElement) {
        this.mSourceElement = sourceElement;
    }

    public void setTarget(DtStructure structure, String newName) {
        this.mStructure = structure;
        this.mNewName = newName;
    }

    public Object getValue(Object element, String name) {
        int index = -1;
        if (name == "Name") {
            index = 0;
        } else if (name == "Bound structure element") {
            index = 1;
        }
        if (index > -1) {
            return this.getColumnValue(element, index);
        }
        return null;
    }

    public String getLabel(Object element, String name) {
        return this.getColumnText(this.getValue(element, name));
    }

    private Object getColumnValue(Object element, int columnIndex) {
        if (element instanceof TreeListItem) {
            TreeListItem item = (TreeListItem)element;
            return item.getProperties().getValue(columnIndex);
        }
        if (element instanceof ContextElement) {
            ContextElement contextElement = (ContextElement)element;
            switch (columnIndex) {
                case 0: {
                    return contextElement.getName();
                }
                case 1: {
                    if (contextElement instanceof ContextValueNode) {
                        ContextValueNode valueNode = (ContextValueNode)contextElement;
                        if (valueNode == this.mSourceElement && this.mNewName == null) {
                            return this.mStructure;
                        }
                        return valueNode.getStructure();
                    }
                    if (!(contextElement instanceof ContextValueAttribute)) break;
                    ContextValueAttribute valueAtt = (ContextValueAttribute)contextElement;
                    if (valueAtt.hasStructureElement()) {
                        return valueAtt.getStructureElement();
                    }
                    if (!this.mStructure.hasStructureElement(valueAtt.getName())) break;
                    return this.mStructure.getStructureElement(valueAtt.getName());
                }
            }
            return null;
        }
        if (element instanceof DtDictionaryObject) {
            DtDictionaryObject dtObject = (DtDictionaryObject)element;
            switch (columnIndex) {
                case 0: {
                    if (dtObject == this.mStructure && this.mNewName != null) {
                        return this.mNewName;
                    }
                    return dtObject.getName();
                }
                case 1: {
                    return dtObject;
                }
            }
            return null;
        }
        return null;
    }

    private String getColumnText(Object value) {
        if (value instanceof DevelopmentObject) {
            return ((DevelopmentObject)value).getName();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }
}

