/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding;

import com.sap.ide.metamodel.dictionary.DtDictionaryObject;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.service.controllereditor.context.ServicesCreation;
import com.sap.ide.webdynpro.service.controllereditor.context.paste.ServicesRefactoring;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StructureBindingHelper
extends ContextWizardHelper {
    private ContextWizardData mData;
    private Map mElementsToRename = new HashMap();

    public static StructureBindingHelper getInstance(ContextWizardData data) {
        return new StructureBindingHelper(data);
    }

    private StructureBindingHelper(ContextWizardData data) {
        this.mData = data;
    }

    public void createAndBindStructure() {
        TreeListItem rootItem = null;
        rootItem = this.mData.isNewMode() ? this.mData.getHelper().get(this.mData.getSourceStructure()) : this.mData.getHelper().get(this.mData.getSourceContextElement());
        ContextElement currentElement = this.mData.getSourceContextElement();
        if (!this.mData.isNewMode() && !this.mData.getSourceContextElement().getName().equalsIgnoreCase((String)rootItem.getProperties().getValue("Name"))) {
            this.mElementsToRename.put(this.mData.getSourceContextElement(), rootItem.getProperties().getValue("Name"));
        }
        if (!ServicesRefactoring.renameElements((Map)this.mElementsToRename)) {
            return;
        }
        if (rootItem.isChecked() && rootItem.isEnabled()) {
            if (this.mData.isNewMode()) {
                String name = (String)rootItem.getProperties().getValue("Name");
                currentElement = this.createAndBind((ContextNode)this.mData.getSourceContextElement(), name, WebDynproDevelopmentObjectEnum.CONTEXTVALUENODE, (DtDictionaryObject)this.mData.getSourceStructure());
            } else {
                this.bindOnly(currentElement, (DtDictionaryObject)this.mData.getSourceStructure());
            }
        }
        List children = rootItem.getChildren();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            TreeListItem child = this.mData.getHelper().get(iter.next());
            this.createAndBindContextSubTree(child, currentElement);
        }
    }

    private void createAndBindContextSubTree(TreeListItem item, ContextElement parent) {
        if (item == null) {
            throw new IllegalArgumentException("Item must not be null");
        }
        ContextElement newElement = null;
        if (item.isChecked() && item.isEnabled()) {
            if (item.getElement() instanceof DtDictionaryObject) {
                if (parent == null) {
                    throw new IllegalArgumentException("Parent must not be null");
                }
                if (!(parent instanceof ContextNode)) {
                    throw new IllegalArgumentException("Parent element must be a Context node");
                }
                DevelopmentObjectEnum type = null;
                DtDictionaryObject dtObject = (DtDictionaryObject)item.getElement();
                if (dtObject instanceof DtStructure) {
                    type = WebDynproDevelopmentObjectEnum.CONTEXTVALUENODE;
                } else if (dtObject instanceof DtStructureElement) {
                    type = WebDynproDevelopmentObjectEnum.CONTEXTVALUEATTRIBUTE;
                }
                String name = (String)item.getProperties().getValue(0);
                newElement = this.createAndBind((ContextNode)parent, name, type, dtObject);
            } else if (item.getElement() instanceof ContextValueAttribute) {
                ContextValueAttribute attribute = (ContextValueAttribute)item.getElement();
                Object structureObject = item.getProperties().getValue("Bound structure element");
                if (structureObject != null) {
                    this.bindOnly((ContextElement)attribute, (DtDictionaryObject)((DtStructureElement)structureObject));
                }
            }
        }
        List children = item.getChildren();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            TreeListItem child = this.mData.getHelper().get(iter.next());
            this.createAndBindContextSubTree(child, newElement);
        }
    }

    private boolean bindOnly(ContextElement element, DtDictionaryObject dtObject) {
        if (element instanceof ContextValueNode && dtObject instanceof DtStructure) {
            ContextValueNode valueNode = (ContextValueNode)element;
            ServicesCreation.createStructureBinding((ContextValueNode)valueNode, (DtStructure)((DtStructure)dtObject));
            return true;
        }
        if (element instanceof ContextValueAttribute && dtObject instanceof DtStructureElement) {
            ContextValueAttribute valueAttribute = (ContextValueAttribute)element;
            ServicesCreation.createStructureBinding((ContextValueAttribute)valueAttribute, (DtStructureElement)((DtStructureElement)dtObject));
            return true;
        }
        return false;
    }

    private ContextElement createAndBind(ContextNode parent, String name, DevelopmentObjectEnum type, DtDictionaryObject dtObject) {
        ContextValueNode newElement = null;
        if (type == WebDynproDevelopmentObjectEnum.CONTEXTVALUENODE && dtObject instanceof DtStructure) {
            newElement = ServicesCreation.createChildNodeAsContextValueNode((ContextNode)parent, (String)name, (DtStructure)((DtStructure)dtObject));
        } else if (type == WebDynproDevelopmentObjectEnum.CONTEXTVALUEATTRIBUTE && dtObject instanceof DtStructureElement) {
            newElement = ServicesCreation.createAttributeAsContextValueAttribute((ContextNode)parent, (String)name, (DtStructureElement)((DtStructureElement)dtObject));
        }
        return newElement;
    }
}

