/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding;

import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.webdynpro.controllereditor.wizards.ControllerWizardPage;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.service.core.wizards.typeselection.DictionaryTreeContentProvider;
import com.sap.ide.webdynpro.service.core.wizards.typeselection.DictionaryTreeLabelProvider;
import com.sap.ide.webdynpro.service.core.wizards.typeselection.DictionaryTreeSorter;
import com.sap.ide.webdynpro.ui.tree.TreeExpandListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PageStructureSelection
extends ControllerWizardPage {
    private static final String PAGE_NAME;
    private static final String TITLE;
    private TreeViewer mStructureViewer;
    private ContextWizardData mData;
    private boolean mFirstTime = true;

    public PageStructureSelection(ContextWizardData data) {
        this(PAGE_NAME, TITLE, null);
        this.mData = data;
    }

    public PageStructureSelection(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(TextPool.getInstance().getText(2514));
        this.setPageComplete(false);
    }

    public void createControl(Composite composite) {
        Composite rootControl = new Composite(composite, 0);
        rootControl.setLayout((Layout)new FillLayout());
        this.setControl((Control)rootControl);
        this.mStructureViewer = new TreeViewer(rootControl, 2820);
        this.mStructureViewer.setContentProvider((IContentProvider)new DictionaryTreeContentProvider(true, false, false));
        this.mStructureViewer.setLabelProvider((IBaseLabelProvider)new DictionaryTreeLabelProvider());
        this.mStructureViewer.setSorter((ViewerSorter)new DictionaryTreeSorter());
        this.mStructureViewer.addTreeListener((ITreeViewerListener)new TreeExpandListener());
        this.mStructureViewer.setInput((Object)new DictionaryTreeContentProvider.DictionaryRoot(this.mData.getDictionaryRoot()));
        this.mStructureViewer.expandToLevel(2);
        this.mStructureViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (selection.getFirstElement() instanceof DtStructure) {
                        ContextValueNode node;
                        if (!PageStructureSelection.this.mData.isNewMode() && PageStructureSelection.this.mData.getSourceContextElement() instanceof ContextValueNode && ContextService.isStructureElementNameMismatch((ContextValueNode)(node = (ContextValueNode)PageStructureSelection.this.mData.getSourceContextElement()), (DtStructure)((DtStructure)selection.getFirstElement()))) {
                            PageStructureSelection.this.setErrorMessage(TextPool.getInstance().getText(2018, (Object)node.getName()));
                            return;
                        }
                        PageStructureSelection.this.mData.setSourceStructure((DtStructure)selection.getFirstElement());
                        PageStructureSelection.this.setErrorMessage(null);
                        PageStructureSelection.this.setDescription(TextPool.getInstance().getText(2514));
                    } else if (!PageStructureSelection.this.mFirstTime) {
                        PageStructureSelection.this.setErrorMessage(TextPool.getInstance().getText(2019));
                    }
                }
                PageStructureSelection.this.mFirstTime = false;
            }
        });
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.mData.getSourceStructure() != null;
    }

    static {
        TITLE = PAGE_NAME = TextPool.getInstance().getText(2318);
    }
}

