/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding;

import com.sap.ide.generationfwk.eclipse.progressmonitor.StatusLineProgressMonitor;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.context.ContextContentProvider;
import com.sap.ide.webdynpro.controllereditor.context.ContextLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.ControllerWizardPage;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding.DisabledStructureBindingImageProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding.MergeStructureContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding.MergeStructureLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding.StructureBindingPropertyProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding.StructureBindingWizardValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding.StructureSorter;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.CheckboxTreeAndList;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericListContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericListLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericTreeContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericTreeLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemCellModifier;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemCellValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemSorter;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListValidationService;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class PageStructureBinding
extends ControllerWizardPage {
    private static final String PAGE_NAME;
    private static final String TITLE;
    public static final String COLUMN_NAME = "Name";
    public static final String COLUMN_BOUND_ELEMENT = "Bound structure element";
    private static String[] mColumns;
    private ContextWizardData mData;
    private TreeListItemHelper mHelper = new TreeListItemHelper();
    private CheckboxTreeAndList mTreeList;
    private CellEditor mTextCellEditor;
    private TreeListItemCellValidator mRenameCellEditorValidator;
    private TreeListItemCellModifier mRenameCellModifier;
    private StructureBindingWizardValidator mStructureWizardValidator;
    private MergeStructureContentProvider mMergeStructureContentProvider;
    private ViewerSorter mTreeSorter;
    private ViewerSorter mListSorter = this.mTreeSorter = new StructureSorter();
    private ContextLabelProvider mSourceContextLabelProvider;
    private MergeStructureLabelProvider mMergeLabelProvider;
    private DisabledStructureBindingImageProvider mDisabledStateLabelProvider;
    private StructureBindingPropertyProvider mPropertyProvider;
    private ContextContentProvider mSourceContextContentProvider;
    private ContextContentProvider.ContextRoot mSourceContextRoot;
    private TreeListValidationService mValidation;
    private boolean mControlCreated = false;

    public PageStructureBinding(ContextWizardData data) {
        super(PAGE_NAME, TITLE, null);
        this.setDescription(TextPool.getInstance().getText(2513));
        this.mData = data;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite rootControl = new Composite(parent, 0);
        rootControl.setLayout((Layout)new FillLayout());
        this.setControl((Control)rootControl);
        this.createProviders();
        this.createValidators();
        this.mTreeList = new CheckboxTreeAndList(rootControl, this.mSourceContextRoot, new GenericTreeContentProvider(this.mHelper, this.mMergeStructureContentProvider), (ILabelProvider)new GenericTreeLabelProvider(this.mHelper, (ILabelProvider)this.mMergeLabelProvider, (ILabelProvider)this.mDisabledStateLabelProvider, this.mPropertyProvider, this.mValidation), new GenericListContentProvider(this.mHelper, (IStructuredContentProvider)this.mMergeStructureContentProvider), (ILabelProvider)new GenericListLabelProvider(this.mHelper, (ILabelProvider)this.mMergeLabelProvider, (ILabelProvider)this.mDisabledStateLabelProvider, this.mPropertyProvider, this.mValidation), new TreeListItemSorter(this.mTreeSorter), new TreeListItemSorter(this.mListSorter), mColumns, 0, -1, -1);
        Table table = this.mTreeList.getListTable();
        table.getColumn(0).setWidth(120);
        table.getColumn(1).setWidth(160);
        table.getColumn(0).setText(TextPool.getInstance().getText(2212));
        table.getColumn(1).setText(TextPool.getInstance().getText(2213));
        this.mTextCellEditor = new TextCellEditor((Composite)this.mTreeList.getListViewer().getTable());
        this.mControlCreated = true;
    }

    public boolean isPageComplete() {
        return this.mValidation != null && this.mValidation.validateForWizardPageCompleteness();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initializeWithProgress();
        }
        super.setVisible(visible);
    }

    private void initializeWithProgress() {
        if (this.getWizard().getPageCount() > 1) {
            IRunnableWithProgress initItems = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    PageStructureBinding.this.initializeItems(monitor);
                }
            };
            IRunnableWithProgress initUI = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    PageStructureBinding.this.initializeUI(monitor);
                }
            };
            try {
                this.getContainer().run(true, false, initItems);
                this.getContainer().run(false, false, initUI);
            }
            catch (InvocationTargetException e) {
                Plugin.internalError(this.getClass(), "initializeWithProgress()", e.getTargetException().getMessage(), e.getTargetException(), false);
            }
            catch (InterruptedException e) {}
        } else {
            BusyIndicator.showWhile((Display)this.mTreeList.getTreeViewer().getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    IProgressMonitor monitor = StatusLineProgressMonitor.getStatusLineProgressMonitor((boolean)false);
                    PageStructureBinding.this.initializeItems(monitor);
                    PageStructureBinding.this.initializeUI(monitor);
                }
            });
        }
    }

    public void initializeItems(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask(TextPool.getInstance().getText(2227), -1);
        }
        this.mHelper.clearData();
        if (this.mData.getHelper() == null) {
            this.mData.setHelper(this.mHelper);
        }
        this.buildTreeListItems(monitor);
        if (monitor != null) {
            monitor.done();
        }
    }

    private void initializeUI(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask(TextPool.getInstance().getText(2228), this.mHelper.getItems().size());
        }
        Object elementToSelect = null;
        elementToSelect = this.mData.isNewMode() ? this.mData.getSourceStructure() : this.mData.getSourceContextElement();
        this.mHelper.setTreeListEditable(this, new CellEditor[]{this.mTextCellEditor, this.mTextCellEditor, this.mTextCellEditor}, this.mRenameCellModifier, this.mRenameCellEditorValidator);
        this.mData.getHelper().initializeTreeList(this, this.mData.getHelper().getTopLevelItems(), elementToSelect, 2, monitor);
        if (monitor != null) {
            monitor.done();
        }
        this.setPageComplete(this.isPageComplete());
    }

    private void buildTreeListItems(IProgressMonitor monitor) {
        this.createProviders();
        this.setTarget();
        this.createValidators();
        this.mHelper.buildTreeListItems(this.mTreeList, this.mMergeStructureContentProvider, mColumns, this.mPropertyProvider, this.mSourceContextRoot, this.mValidation, monitor);
    }

    private void createValidators() {
        this.mRenameCellEditorValidator = new TreeListItemCellValidator();
        this.mRenameCellModifier = new StructureCellModifier();
        this.mStructureWizardValidator = new StructureBindingWizardValidator(this.mData);
        this.mValidation = new TreeListValidationService(this.mStructureWizardValidator, this.mHelper);
    }

    private void createProviders() {
        if (this.mControlCreated) {
            return;
        }
        ContextValueNode sourceContext = ((Controller)this.mData.getSourceContextElement().getMDO()).getContext();
        this.mSourceContextRoot = new ContextContentProvider.ContextRoot((ContextElement)sourceContext);
        this.mSourceContextContentProvider = new ContextContentProvider(this.mSourceContextRoot);
        this.mSourceContextLabelProvider = new ContextLabelProvider(this.mData.getControllerUsages(), false, false, false);
        this.mMergeStructureContentProvider = new MergeStructureContentProvider(this.mSourceContextRoot, this.mData.getSourceContextElement(), this.mSourceContextContentProvider, !this.mData.isNewMode());
        this.mMergeLabelProvider = new MergeStructureLabelProvider(this.mData.getControllerUsages());
        this.mDisabledStateLabelProvider = new DisabledStructureBindingImageProvider();
        this.mPropertyProvider = new StructureBindingPropertyProvider(this.mData.getSourceContextElement());
    }

    private void setTarget() {
        this.mMergeStructureContentProvider.setTarget(this.mData.getSourceStructure());
        this.mPropertyProvider.setTarget(this.mData.getSourceStructure(), this.mData.getContextElementName());
    }

    static {
        TITLE = PAGE_NAME = TextPool.getInstance().getText(2318);
        mColumns = new String[]{COLUMN_NAME, COLUMN_BOUND_ELEMENT};
    }

    private class StructureCellModifier
    extends TreeListItemCellModifier {
        private StructureCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (property != PageStructureBinding.COLUMN_NAME) {
                return false;
            }
            return super.canModify(element, property);
        }
    }
}

