/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding;

import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.webdynpro.controllereditor.context.ContextContentProvider;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class MergeStructureContentProvider
implements ITreeContentProvider {
    private ContextElement mSourceContextElement;
    private ContextContentProvider.ContextRoot mContextRoot;
    private ITreeContentProvider mContextContentProvider;
    private DtStructure mStructure;
    private boolean mInsertChildrenOnly = false;

    public MergeStructureContentProvider(ContextContentProvider.ContextRoot contextRoot, ContextElement sourceContextElement, ITreeContentProvider contextContentProvider, boolean insertChildrenOnly) {
        this.mContextRoot = contextRoot;
        this.mSourceContextElement = sourceContextElement;
        this.mContextContentProvider = contextContentProvider;
        this.mInsertChildrenOnly = insertChildrenOnly;
    }

    public Object[] getChildren(Object parentElement) {
        Vector<Object> children = new Vector<Object>();
        if (parentElement instanceof ContextElement) {
            children.addAll(Arrays.asList(this.mContextContentProvider.getChildren(parentElement)));
            if (parentElement == this.mSourceContextElement) {
                if (this.mInsertChildrenOnly) {
                    children.addAll(this.doMerge((ContextElement)parentElement, this.mStructure));
                } else {
                    children.add(this.mStructure);
                }
            }
        } else if (parentElement instanceof DtStructure) {
            DtStructure parentStructure = (DtStructure)parentElement;
            children.addAll(Arrays.asList(parentStructure.getStructureElements()));
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        Object parent = null;
        if (element instanceof ContextElement) {
            parent = this.mContextContentProvider.getParent(element);
        } else if (element instanceof DtStructure) {
            parent = element == this.mStructure ? this.mSourceContextElement : this.mStructure;
        } else if (element instanceof DtStructureElement) {
            parent = !this.mInsertChildrenOnly ? this.mStructure : this.mSourceContextElement;
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        Vector<Object> elements = new Vector<Object>();
        elements.addAll(Arrays.asList(this.mContextContentProvider.getElements((Object)this.mContextRoot)));
        return elements.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setTarget(DtStructure structure) {
        this.mStructure = structure;
    }

    private List doMerge(ContextElement parentElement, DtStructure structure) {
        Vector<DtStructureElement> results = new Vector<DtStructureElement>();
        if (parentElement instanceof ContextValueNode) {
            ContextValueNode valueNode = (ContextValueNode)parentElement;
            Set existingStructureRefs = this.getStructureElements(valueNode);
            DtStructureElement[] structureElements = structure.getStructureElements();
            int i = 0;
            while (i < structureElements.length) {
                DtStructureElement element = structureElements[i];
                if (!existingStructureRefs.contains(element) && !valueNode.hasAttribute(element.getName())) {
                    results.add(element);
                }
                ++i;
            }
        }
        return results;
    }

    private Set getStructureElements(ContextValueNode node) {
        HashSet<DevelopmentObject> structureElements = new HashSet<DevelopmentObject>();
        Object[] children = this.mContextContentProvider.getChildren((Object)node);
        int i = 0;
        while (i < children.length) {
            ContextValueAttribute att;
            ContextElement child = (ContextElement)children[i];
            if (child instanceof ContextValueAttribute && (att = (ContextValueAttribute)child).hasStructureElement()) {
                structureElements.add(att.getStructureElement());
            }
            ++i;
        }
        return structureElements;
    }
}

