/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.refactoring;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.refactoring.RefactoringRequest;
import com.sap.ide.metamodel.general.refactoring.RefactoringTask;
import com.sap.ide.metamodel.webdynpro.component.controller.CalculatedAttributeProvider;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextRecursionNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.service.controllereditor.context.ServicesCreation;
import com.sap.ide.webdynpro.service.controllereditor.procedure.RenameProcedureService;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RenameContextElementWizard
extends RenameWizard {
    private ContextElement mObjectToRename;
    private Controller mController;
    private List mCalculatedAttributeMethodsToRefactor = new ArrayList();
    private RenameProcedureService mRenameProcedureService;

    public RenameContextElementWizard(DevelopmentObject objectToRename, String newName) {
        super(objectToRename, newName);
        this.mObjectToRename = (ContextElement)objectToRename;
        this.mController = (Controller)objectToRename.getMDO();
        this.mRenameProcedureService = new RenameProcedureService(this.mController);
    }

    protected String verifyDevelopmentobjectName(String nameInput, String packageInput) {
        String message = null;
        if (this.mObjectToRename instanceof ContextAttribute && CheckLayerHelper.hasStructureBinding((ContextElement)CheckLayerHelper.getOriginContextElement((ContextElement)this.mObjectToRename, (ControllerUsage[])CheckLayerHelper.getOutgoingControllerUsages((ContextElement)this.mObjectToRename)))) {
            message = TextPool.getInstance().getText(2017);
        } else if (this.mObjectToRename instanceof ContextNode || this.mObjectToRename instanceof ContextRecursionNode) {
            message = ContextService.isValidContextNodeName((String)nameInput, (ContextNode)((ContextNode)this.mObjectToRename.getParent()));
        }
        return message;
    }

    protected IStatus doSpecialRefactoringPreparation(RefactoringRequest request, DevelopmentObject developmentObject, String newName, String newPackage, SourcePathIdentifier newIdentifier) {
        String pluginID = Plugin.getDefault().getDescriptor().getUniqueIdentifier();
        if (developmentObject instanceof ContextValueAttribute) {
            ContextValueAttribute attribute = (ContextValueAttribute)developmentObject;
            if (attribute.hasCalculatedAttributeProvider()) {
                String newProviderName = ServicesCreation.getUniqueCalculatedAttributeProviderName((Controller)this.mController, (ContextValueAttribute)attribute, null, (String)newName);
                this.refactorCalculatedAttributeProvider(request, attribute, newProviderName);
            }
        } else if (developmentObject instanceof ContextNode) {
            ContextNode node = (ContextNode)developmentObject;
            ContextAttribute[] attributes = node.getAttributes();
            int i = 0;
            while (i < attributes.length) {
                if (attributes[i] instanceof ContextValueAttribute && ((ContextValueAttribute)attributes[i]).hasCalculatedAttributeProvider()) {
                    String newProviderName = ServicesCreation.getUniqueCalculatedAttributeProviderName((Controller)this.mController, (ContextValueAttribute)((ContextValueAttribute)attributes[i]), (String)newName, null);
                    this.refactorCalculatedAttributeProvider(request, (ContextValueAttribute)attributes[i], newProviderName);
                }
                ++i;
            }
        }
        return new Status(0, pluginID, 0, "", null);
    }

    public boolean performFinish() {
        boolean status = super.performFinish();
        if (this.mCalculatedAttributeMethodsToRefactor.size() > 0) {
            this.mRenameProcedureService.applyRenameProcedureWrappers(this.mCalculatedAttributeMethodsToRefactor.toArray(new RenameProcedureService.RenameProcedureWrapper[this.mCalculatedAttributeMethodsToRefactor.size()]));
        }
        return status;
    }

    private void refactorCalculatedAttributeProvider(RefactoringRequest request, ContextValueAttribute attribute, String newProviderName) {
        RenameProcedureService.RenameProcedureWrapper wrapper;
        CalculatedAttributeProvider provider = attribute.getCalculatedAttributeProvider();
        RefactoringTask task = request.createRefactoringTask((DevelopmentObject)provider);
        task.setNewName(newProviderName);
        if (provider.hasAccessor()) {
            String oldGetterName = provider.getAccessor().getName();
            String newGetterName = "get" + ServicesCreation.toFirstCharCapitalized((String)newProviderName);
            task = request.createRefactoringTask((DevelopmentObject)provider.getAccessor());
            task.setNewName(newGetterName);
            wrapper = this.mRenameProcedureService.getProcedureWrapper(oldGetterName, newGetterName);
            if (wrapper != null) {
                this.mCalculatedAttributeMethodsToRefactor.add(wrapper);
            }
        }
        if (provider.hasMutator()) {
            String oldSetterName = provider.getMutator().getName();
            String newSetterName = "set" + ServicesCreation.toFirstCharCapitalized((String)newProviderName);
            task = request.createRefactoringTask((DevelopmentObject)provider.getMutator());
            task.setNewName(newSetterName);
            wrapper = this.mRenameProcedureService.getProcedureWrapper(oldSetterName, newSetterName);
            if (wrapper != null) {
                this.mCalculatedAttributeMethodsToRefactor.add(wrapper);
            }
        }
    }
}

