/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.refactoring;

import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.IItemValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListValidationService;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.ValidationResult;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import org.eclipse.core.runtime.IStatus;

public class RefactoringWizardValidator
implements IItemValidator {
    private ContextWizardData mData;
    private static final String CONTEXT_NAME = "Context";

    public RefactoringWizardValidator(ContextWizardData data) {
        this.mData = data;
    }

    public IStatus validateItem(TreeListItem item, TreeListItemHelper helper, String columnProperty, Object value) {
        Object element = item.getElement();
        String message = null;
        TextPool textPool = TextPool.getInstance();
        ContextElement sourceElement = this.mData.getSourceContextElement();
        String name = null;
        if (columnProperty == null && value == null && item.getProperties().isEmpty()) {
            return null;
        }
        if (columnProperty == null && value == null && !item.getProperties().isEmpty()) {
            columnProperty = "Name";
            name = (String)item.getProperties().getValue("Name");
        } else if (columnProperty == "Name") {
            name = (String)value;
        } else {
            return null;
        }
        if (!CheckServices.isValidIdentifier((String)name)) {
            message = CoreTextPool.getInstance().getText(2, (Object)name);
            return new ValidationResult(message, 4);
        }
        boolean isDuplicate = false;
        if (item.isEnabled() && item.isChecked()) {
            if (name.equalsIgnoreCase(CONTEXT_NAME) && !item.isTopLevelItem()) {
                isDuplicate = true;
            } else if (element instanceof ClipboardObject) {
                TreeListItem parentItem;
                ClipboardObject object = (ClipboardObject)element;
                if (object.getType() == WebDynproDevelopmentObjectEnum.CONTEXTVALUENODE || object.getType() == WebDynproDevelopmentObjectEnum.CONTEXTMODELNODE) {
                    if (TreeListValidationService.isDuplicateName(item, helper, columnProperty, name)) {
                        isDuplicate = true;
                    }
                } else if ((object.getType() == WebDynproDevelopmentObjectEnum.CONTEXTVALUEATTRIBUTE || object.getType() == WebDynproDevelopmentObjectEnum.CONTEXTMODELATTRIBUTE) && TreeListValidationService.isDuplicateName(item, parentItem = helper.get(item.getParent()), helper, columnProperty, name)) {
                    isDuplicate = true;
                }
            }
        }
        if (isDuplicate) {
            message = textPool.getText(2007, (Object)name);
            return new ValidationResult(message, 4);
        }
        return TreeListValidationService.OK_RESULT;
    }

    public boolean isEnabled(TreeListItem item, TreeListItemHelper helper) {
        if (item.isTopLevelItem()) {
            return false;
        }
        if (item.getElement() == this.mData.getSourceContextElement()) {
            return true;
        }
        return item.getElement() instanceof ClipboardObject;
    }

    public boolean isNode(TreeListItem item, TreeListItemHelper helper) {
        Object element = item.getElement();
        if (element instanceof ClipboardObject) {
            ClipboardObject object = (ClipboardObject)element;
            DevelopmentObjectEnum type = object.getType();
            return type == WebDynproDevelopmentObjectEnum.CONTEXTVALUENODE || type == WebDynproDevelopmentObjectEnum.CONTEXTMODELNODE || type == WebDynproDevelopmentObjectEnum.CONTEXTRECURSIONNODE;
        }
        return element instanceof AbstractContextNode;
    }

    public boolean isChecked(TreeListItem item, TreeListItemHelper helper) {
        return item.getElement() instanceof ContextElement;
    }
}

