/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.refactoring;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.service.controllereditor.context.paste.ContextPasteElementMapper;
import java.util.Iterator;
import java.util.List;

public class RefactoringHelper {
    public static ContextPasteElementMapper refactorItems(ContextWizardData data) {
        ContextPasteElementMapper mapper = null;
        List items = data.getHelper().getItems();
        Metamodel sourceMetamodel = data.getClipboard().getSourceMetamodel();
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            TreeListItem item = (TreeListItem)iter.next();
            if (!(item.getElement() instanceof ClipboardObject)) continue;
            ClipboardObject object = (ClipboardObject)item.getElement();
            DevelopmentObjectEnum type = object.getType();
            DevelopmentObject originalObject = sourceMetamodel.getObjectFromKey(object.getOriginalKey());
            if (mapper == null) {
                mapper = RefactoringHelper.createMapper(sourceMetamodel, object, originalObject);
            }
            object.setExcluded(!item.isChecked());
            if (!item.isChecked() || mapper == null) continue;
            String newName = (String)item.getProperties().getValue("Name");
            mapper.storeNameMapping(newName, object.getNewName());
            if ((type == WebDynproDevelopmentObjectEnum.CONTEXTMODELATTRIBUTE || type == WebDynproDevelopmentObjectEnum.CONTEXTVALUEATTRIBUTE) && object.getParent() == null && originalObject != null && originalObject.getParent() != null) {
                String oldParentNodesName = originalObject.getParent().getName();
                mapper.storeNameMapping(data.getSourceContextElement().getName(), oldParentNodesName);
            }
            object.setNewName(newName);
        }
        return mapper;
    }

    private static ContextPasteElementMapper createMapper(Metamodel sourceMetamodel, ClipboardObject object, DevelopmentObject originalObject) {
        if (originalObject != null) {
            DevelopmentObjectKey contextKey = ((Controller)((ContextElement)originalObject).getMDO()).getContext().getKey();
            return new ContextPasteElementMapper(contextKey, sourceMetamodel);
        }
        return null;
    }
}

