/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.refactoring;

import com.sap.ide.generationfwk.eclipse.progressmonitor.StatusLineProgressMonitor;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.context.ContextContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.ControllerWizardPage;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.context.mapping.DisabledContextElementImageProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.refactoring.ClipboardObjectSorter;
import com.sap.ide.webdynpro.controllereditor.wizards.context.refactoring.MergeRefactoringContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.refactoring.MergeRefactoringLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.refactoring.RefactoringPropertyProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.refactoring.RefactoringWizardValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.CheckboxTreeAndList;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericListContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericListLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericTreeContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericTreeLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.IPropertyProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemCellModifier;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemCellValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemSorter;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListValidationService;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class PageRefactoring
extends ControllerWizardPage {
    private static final String PAGE_NAME;
    private static final String TITLE;
    public static final String COLUMN_NAME = "Name";
    public static final String COLUMN_ORIGINAL_OBJECT = "Original object";
    private static String[] mColumns;
    private ContextWizardData mData;
    private ClipboardObject[] mClipboardObjects;
    private TreeListItemHelper mHelper = new TreeListItemHelper();
    private CheckboxTreeAndList mRefactoringTreeList;
    private ContextContentProvider.ContextRoot mSourceContextRoot;
    private ITreeContentProvider mSourceContextContentProvider;
    private MergeRefactoringContentProvider mRefactoringContentProvider;
    private MergeRefactoringLabelProvider mRefactoringLabelProvider;
    private ILabelProvider mDisabledLabelProvider = new DisabledContextElementImageProvider();
    private IPropertyProvider mPropertyProvider;
    private ViewerSorter mTreeSorter = new ClipboardObjectSorter();
    private ViewerSorter mListSorter = new ClipboardObjectSorter();
    private TreeListItemCellModifier mRenameCellModifier;
    private TreeListItemCellValidator mRenameCellValidator;
    private RefactoringWizardValidator mRefactoringValidator;
    private CellEditor mTextCellEditor;
    private CheckboxTreeAndList mTreelist;
    private ITreeContentProvider mContentProvider;
    private ILabelProvider mLabelProvider;
    private TreeListValidationService mValidation;
    private boolean mControlCreated = false;

    public PageRefactoring(ContextWizardData data) {
        super(PAGE_NAME, TITLE, null);
        this.setDescription(TextPool.getInstance().getText(2509));
        this.mData = data;
        this.mClipboardObjects = data.getClipboardObjects();
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        this.setControl((Control)root);
        this.createProviders();
        this.createValidators();
        this.mRefactoringTreeList = new CheckboxTreeAndList(root, this.mSourceContextRoot, new GenericTreeContentProvider(this.mHelper, this.mRefactoringContentProvider), (ILabelProvider)new GenericTreeLabelProvider(this.mHelper, (ILabelProvider)this.mRefactoringLabelProvider, this.mDisabledLabelProvider, this.mPropertyProvider, this.mValidation), new GenericListContentProvider(this.mHelper, (IStructuredContentProvider)this.mRefactoringContentProvider), (ILabelProvider)new GenericListLabelProvider(this.mHelper, (ILabelProvider)this.mRefactoringLabelProvider, this.mDisabledLabelProvider, this.mPropertyProvider, this.mValidation), new TreeListItemSorter(this.mTreeSorter), new TreeListItemSorter(this.mListSorter), mColumns, 0, -1, -1);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 300;
        data.widthHint = 170;
        this.mRefactoringTreeList.getTreeViewer().getControl().setLayoutData((Object)data);
        Table table = this.mRefactoringTreeList.getListTable();
        table.getColumn(0).setWidth(150);
        table.getColumn(1).setWidth(140);
        this.mTextCellEditor = new TextCellEditor((Composite)table);
        this.mControlCreated = true;
    }

    public boolean isPageComplete() {
        return this.mValidation != null && this.mValidation.validateForWizardPageCompleteness();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initializeWithProgress();
        }
        super.setVisible(visible);
    }

    private void initializeWithProgress() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                IProgressMonitor monitor = StatusLineProgressMonitor.getStatusLineProgressMonitor((boolean)false);
                PageRefactoring.this.initializeItems(monitor);
                PageRefactoring.this.initializeUI(monitor);
            }
        });
    }

    public void initializeItems(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask(TextPool.getInstance().getText(2227), -1);
        }
        this.mHelper.clearData();
        if (this.mData.getHelper() == null) {
            this.mData.setHelper(this.mHelper);
        }
        this.buildTreeListItems(monitor);
        if (monitor != null) {
            monitor.done();
        }
    }

    private void initializeUI(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask(TextPool.getInstance().getText(2228), this.mHelper.getItems().size());
        }
        this.mHelper.setTreeListEditable(this, new CellEditor[]{this.mTextCellEditor, this.mTextCellEditor, this.mTextCellEditor}, this.mRenameCellModifier, this.mRenameCellValidator);
        this.mData.getHelper().initializeTreeList(this, this.mData.getHelper().getTopLevelItems(), this.mData.getSourceContextElement(), 2, monitor);
        if (monitor != null) {
            monitor.done();
        }
        this.setPageComplete(this.isPageComplete());
    }

    private void buildTreeListItems(IProgressMonitor monitor) {
        this.createProviders();
        this.createValidators();
        this.mHelper.buildTreeListItems(this.mRefactoringTreeList, this.mRefactoringContentProvider, mColumns, this.mPropertyProvider, this.mSourceContextRoot, this.mValidation, monitor);
    }

    private void createProviders() {
        if (this.mControlCreated) {
            return;
        }
        ContextValueNode sourceContext = ((Controller)this.mData.getSourceContextElement().getMDO()).getContext();
        this.mSourceContextRoot = new ContextContentProvider.ContextRoot((ContextElement)sourceContext);
        this.mSourceContextContentProvider = new ContextContentProvider(this.mSourceContextRoot);
        this.mRefactoringContentProvider = new MergeRefactoringContentProvider(this.mClipboardObjects, this.mSourceContextRoot, this.mData.getSourceContextElement(), this.mSourceContextContentProvider);
        this.mRefactoringLabelProvider = new MergeRefactoringLabelProvider(this.mData.getControllerUsages());
        this.mPropertyProvider = new RefactoringPropertyProvider();
    }

    private void createValidators() {
        if (this.mControlCreated) {
            return;
        }
        this.mRefactoringValidator = new RefactoringWizardValidator(this.mData);
        this.mRenameCellModifier = new RefactoringCellModifier();
        this.mRenameCellValidator = new TreeListItemCellValidator();
        this.mValidation = new TreeListValidationService(this.mRefactoringValidator, this.mHelper);
    }

    static {
        TITLE = PAGE_NAME = TextPool.getInstance().getText(2309);
        mColumns = new String[]{COLUMN_NAME, COLUMN_ORIGINAL_OBJECT};
    }

    private class RefactoringCellModifier
    extends TreeListItemCellModifier {
        private RefactoringCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            TreeListItem item;
            if (property != PageRefactoring.COLUMN_NAME) {
                return false;
            }
            if (element instanceof TreeListItem && (item = (TreeListItem)element).getElement() == PageRefactoring.this.mData.getSourceContextElement()) {
                return false;
            }
            return super.canModify(element, property);
        }
    }
}

