/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.refactoring;

import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.webdynpro.controllereditor.context.ContextContentProvider;
import com.sap.ide.webdynpro.service.controllereditor.context.paste.ServicesRefactoring;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class MergeRefactoringContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private List mRootObjects;
    private ContextElement mSourceContextElement;
    private ContextContentProvider.ContextRoot mContextRoot;
    private ITreeContentProvider mContextContentProvider;

    public MergeRefactoringContentProvider(ClipboardObject[] clipboardObjects, ContextContentProvider.ContextRoot contextRoot, ContextElement sourceContextElement, ITreeContentProvider contextContentProvider) {
        this.mContextRoot = contextRoot;
        this.mSourceContextElement = sourceContextElement;
        this.mContextContentProvider = contextContentProvider;
        this.mRootObjects = Arrays.asList(clipboardObjects);
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (parentElement instanceof ContextElement) {
            children.addAll(Arrays.asList(this.mContextContentProvider.getChildren(parentElement)));
            if (parentElement == this.mSourceContextElement) {
                children.addAll(this.mRootObjects);
            }
        } else if (parentElement instanceof ClipboardObject) {
            ClipboardObject parentObject = (ClipboardObject)parentElement;
            ClipboardObject[] objects = parentObject.getChildren();
            int i = 0;
            while (i < objects.length) {
                ClipboardObject object = objects[i];
                if (ServicesRefactoring.isContextElementClipboardObject((ClipboardObject)object)) {
                    children.add(object);
                }
                ++i;
            }
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        Object parent = null;
        if (element instanceof ContextElement) {
            parent = this.mContextContentProvider.getParent(element);
        } else if (element instanceof ClipboardObject) {
            parent = this.mRootObjects.contains(element) ? this.mSourceContextElement : ((ClipboardObject)element).getParent();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        Vector<Object> elements = new Vector<Object>();
        elements.addAll(Arrays.asList(this.mContextContentProvider.getElements((Object)this.mContextRoot)));
        return elements.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

