/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.modelbinding;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelClassTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelEntityTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelPropertyTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelRelationRoleTreeProxy;
import com.sap.ide.webdynpro.controllereditor.wizards.context.modelbinding.ModelBindingHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.IPropertyProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import java.util.Hashtable;
import java.util.Map;

public class ModelBindingPropertyProvider
implements IPropertyProvider {
    private DevelopmentObject mTargetModelEntity;
    private Controller mSourceController;
    private ControllerUsage[] mSourceUsages;
    private ContextElement mSourceElement;
    private Map mFoundCandidatesForElement = new Hashtable();

    public ModelBindingPropertyProvider(ControllerUsage[] sourceUsages, ContextElement sourceElement) {
        this.mSourceUsages = sourceUsages;
        this.mSourceElement = sourceElement;
        if (this.mSourceUsages != null && this.mSourceUsages.length > 0) {
            this.mSourceController = (Controller)this.mSourceUsages[0].getMDO();
        }
    }

    public Object getValue(Object element, String name) {
        int index = -1;
        if (name == "Name") {
            index = 0;
        } else if (name == "Model class/property") {
            index = 1;
        } else if (name == "Model relation") {
            index = 2;
        }
        if (index > -1) {
            return this.getColumnValue(element, index);
        }
        return null;
    }

    public String getLabel(Object element, String name) {
        return this.getColumnText(this.getValue(element, name));
    }

    private Object getColumnValue(Object element, int columnIndex) {
        if (element instanceof TreeListItem) {
            TreeListItem item = (TreeListItem)element;
            return item.getProperties().getValue(columnIndex);
        }
        if (element instanceof ContextElement) {
            ContextElement contextElement = (ContextElement)element;
            DevelopmentObject target = null;
            switch (columnIndex) {
                case 0: {
                    return contextElement.getName();
                }
                case 1: {
                    DevelopmentObject modelEntity = null;
                    if (contextElement == this.mSourceElement && this.mTargetModelEntity != null) {
                        modelEntity = this.mTargetModelEntity;
                    } else if (contextElement instanceof ContextModelNode) {
                        target = this.getParentsCandidate(contextElement);
                        ContextModelNode modelNode = (ContextModelNode)contextElement;
                        modelEntity = ModelBindingHelper.findBindingCandidate(contextElement, this.mSourceElement, target);
                    } else if (contextElement instanceof ContextModelAttribute) {
                        target = this.getParentsCandidate(contextElement);
                        ContextModelAttribute attribute = (ContextModelAttribute)contextElement;
                        modelEntity = ModelBindingHelper.findBindingCandidate(contextElement, this.mSourceElement, target);
                    }
                    if (modelEntity instanceof ModelRelationRole) {
                        modelEntity = ((ModelRelationRole)modelEntity).getModelClass();
                    }
                    if (modelEntity != null) {
                        this.mFoundCandidatesForElement.put(contextElement, modelEntity);
                    }
                    return modelEntity;
                }
                case 2: {
                    DevelopmentObject role = null;
                    if (contextElement == this.mSourceElement && this.mTargetModelEntity != null) {
                        role = this.mTargetModelEntity;
                    } else if (contextElement instanceof ContextModelNode) {
                        target = this.getParentsCandidate(contextElement);
                        ContextModelNode modelNode = (ContextModelNode)contextElement;
                        role = ModelBindingHelper.findBindingCandidate(contextElement, this.mSourceElement, target);
                    }
                    if (!(role instanceof ModelRelationRole)) break;
                    this.mFoundCandidatesForElement.put(contextElement, role);
                    return role;
                }
            }
            return null;
        }
        if (element instanceof ModelEntityTreeProxy) {
            ModelEntityTreeProxy treeProxy = (ModelEntityTreeProxy)element;
            switch (columnIndex) {
                case 0: {
                    if (treeProxy.getParentProxy() instanceof ModelRelationRoleTreeProxy) {
                        return treeProxy.getParentProxy().getModelEntity().getName();
                    }
                    return treeProxy.getModelEntity().getName();
                }
                case 1: {
                    if (treeProxy instanceof ModelClassTreeProxy || treeProxy instanceof ModelPropertyTreeProxy) {
                        return treeProxy.getModelEntity();
                    }
                }
                case 2: {
                    if (!(treeProxy.getParentProxy() instanceof ModelRelationRoleTreeProxy)) break;
                    return treeProxy.getParentProxy().getModelEntity();
                }
            }
            return null;
        }
        return null;
    }

    private String getColumnText(Object value) {
        if (value instanceof DevelopmentObject) {
            return ((DevelopmentObject)value).getName();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    public void setTargetElement(DevelopmentObject targetModelEntity) {
        this.mTargetModelEntity = targetModelEntity;
    }

    private DevelopmentObject getParentsCandidate(ContextElement element) {
        Object candidate = null;
        DevelopmentObject parent = element.getParent();
        if (parent == null) {
            return null;
        }
        if (!(parent instanceof ContextElement)) {
            return null;
        }
        if (parent == this.mSourceElement) {
            return this.mTargetModelEntity;
        }
        candidate = this.mFoundCandidatesForElement.get(parent);
        if (candidate instanceof DevelopmentObject) {
            return candidate;
        }
        return null;
    }
}

