/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.modelbinding;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelClassTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelEntityTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelPropertyTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelRelationRoleTreeProxy;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.service.controllereditor.context.ServicesCreation;
import com.sap.ide.webdynpro.service.controllereditor.context.paste.ServicesRefactoring;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModelBindingHelper
extends ContextWizardHelper {
    private ContextWizardData mData;
    private Map mElementsToRename = new HashMap();
    private List mNewElements = new ArrayList();

    private ModelBindingHelper(ContextWizardData data) {
        this.mData = data;
    }

    public static ModelBindingHelper getInstance(ContextWizardData data) {
        return new ModelBindingHelper(data);
    }

    public TreeListItem getTreeListRoot(DevelopmentObject object, List items) {
        Object root = null;
        return this.mData.getHelper().get(object);
    }

    public void bindModel() {
        Object objectToBind;
        ContextValueNode context = ((Controller)this.mData.getSourceContextElement().getMDO()).getContext();
        TreeListItem rootItem = this.mData.getHelper().get(context);
        TreeListItem modelProxyRootItem = this.mData.getHelper().get(this.mData.getSourceContextElement());
        String name = (String)modelProxyRootItem.getProperties().getValue("Name");
        if (!name.equalsIgnoreCase(((DevelopmentObject)modelProxyRootItem.getElement()).getName())) {
            this.mElementsToRename.put(modelProxyRootItem.getElement(), name);
        }
        List children = rootItem.getChildren();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            TreeListItem child = this.mData.getHelper().get(iter.next());
            this.createAndBindSubTree(child, (ContextElement)context, true);
        }
        if (!ServicesRefactoring.renameElements((Map)this.mElementsToRename)) {
            return;
        }
        if (modelProxyRootItem.isChecked() && modelProxyRootItem.isEnabled() && (objectToBind = modelProxyRootItem.getProperties().getValue("Model class/property")) != null) {
            this.bindOnly((ContextElement)modelProxyRootItem.getElement(), (DevelopmentObject)objectToBind);
        }
        Iterator iter2 = children.iterator();
        while (iter2.hasNext()) {
            TreeListItem child = this.mData.getHelper().get(iter2.next());
            this.createAndBindSubTree(child, (ContextElement)context, false);
        }
    }

    private void createAndBindSubTree(TreeListItem item, ContextElement parent, boolean previewMode) {
        ContextElement newElement = null;
        if (item == null) {
            return;
        }
        if (item.getElement() instanceof ContextElement) {
            newElement = (ContextElement)item.getElement();
            if (item.isChecked() && item.isEnabled()) {
                String name;
                Object modelRef = item.getProperties().getValue("Model class/property");
                if (modelRef != null && !previewMode) {
                    Object relation = item.getProperties().getValue("Model relation");
                    if (relation != null) {
                        modelRef = relation;
                    }
                    this.bindOnly((ContextElement)item.getElement(), (DevelopmentObject)modelRef);
                }
                if (!(name = (String)item.getProperties().getValue("Name")).equalsIgnoreCase(((DevelopmentObject)item.getElement()).getName()) && previewMode) {
                    this.mElementsToRename.put(item.getElement(), name);
                }
            }
        } else if (item.isChecked() && item.isEnabled() && !previewMode) {
            newElement = this.createAndBindModelEntity(item.getElement(), (String)item.getProperties().getValue(0), parent);
        }
        List children = item.getChildren();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            this.createAndBindSubTree(this.mData.getHelper().get(iter.next()), newElement, previewMode);
        }
    }

    private ContextElement createAndBindModelEntity(Object modelProxy, String name, ContextElement parent) {
        ContextAttribute newElement = null;
        ContextModelNode parentModelNode = null;
        if (parent == null || !(parent instanceof ContextModelNode)) {
            return null;
        }
        parentModelNode = (ContextModelNode)parent;
        if (modelProxy instanceof ModelClassTreeProxy) {
            ModelClassTreeProxy classProxy = (ModelClassTreeProxy)modelProxy;
            ModelRelationRole role = classProxy.getParent().getModelRelationRole();
            if (role.equals(this.mData.getTargetModelEntity())) {
                return parentModelNode;
            }
            if (ContextService.isUniqueNodeWithinContext((String)name, (ContextNode)parentModelNode) != null) {
                newElement = ContextService.findContextNodeByName((String)name, (AbstractContextNode)parentModelNode);
            }
            if (newElement == null || !(newElement instanceof ContextModelNode)) {
                newElement = ServicesCreation.createChildNodeAsContextModelNode((ContextNode)parentModelNode, (String)name);
            }
            if (newElement != null) {
                if (role != null) {
                    this.bindOnly((ContextElement)newElement, (DevelopmentObject)role);
                } else {
                    this.bindOnly((ContextElement)newElement, (DevelopmentObject)classProxy.getModelClass());
                }
            }
        } else if (modelProxy instanceof ModelPropertyTreeProxy) {
            if (ContextService.isUniqueNodeWithinContext((String)name, (ContextNode)parentModelNode) != null) {
                newElement = ContextService.findContextAttributeByName((String)name, (ContextNode)parentModelNode);
            }
            if (newElement == null || !(newElement instanceof ContextModelAttribute)) {
                newElement = ServicesCreation.createAttributeAsContextModelAttribute((ContextNode)parentModelNode, (String)name);
            }
            if (newElement != null) {
                ModelPropertyTreeProxy propertyProxy = (ModelPropertyTreeProxy)modelProxy;
                this.bindOnly((ContextElement)newElement, (DevelopmentObject)propertyProxy.getModelProperty());
            }
        }
        return newElement;
    }

    private void bindOnly(ContextElement element, DevelopmentObject entityToBind) {
        if (element instanceof ContextModelNode) {
            ContextModelNode modelNode = (ContextModelNode)element;
            if (entityToBind instanceof ModelClass) {
                ModelClass modelClass = (ModelClass)entityToBind;
                ServicesCreation.createModelBinding((ContextModelNode)modelNode, (ModelClass)modelClass);
            } else if (entityToBind instanceof ModelRelationRole) {
                ModelRelationRole role = (ModelRelationRole)entityToBind;
                ServicesCreation.createModelBinding((ContextModelNode)modelNode, (ModelRelationRole)role);
            }
        } else if (element instanceof ContextModelAttribute) {
            ContextModelAttribute modelAttribute = (ContextModelAttribute)element;
            if (entityToBind instanceof Property) {
                Property property = (Property)entityToBind;
                ServicesCreation.createModelBinding((ContextModelAttribute)modelAttribute, (Property)property);
            }
        }
    }

    public boolean isContextRootNodeItem(TreeListItem item) {
        ContextElement element;
        return item.getElement() instanceof ContextElement && (element = (ContextElement)item.getElement()).getParent() != null && element.getParent().isMDO();
    }

    public static DevelopmentObject findBindingCandidate(ContextElement element, ContextElement sourceElement, DevelopmentObject targetEntity) {
        String name = element.getName();
        ModelClass targetModelClass = null;
        if (targetEntity instanceof ModelClass) {
            targetModelClass = (ModelClass)targetEntity;
        } else if (targetEntity instanceof ModelRelationRole) {
            ModelRelationRole targetRole = (ModelRelationRole)targetEntity;
            targetModelClass = targetRole.getModelClass();
        } else if (targetEntity instanceof ModelClassProperty) {
            ModelClassProperty targetProperty = (ModelClassProperty)targetEntity;
            targetModelClass = (ModelClass)targetProperty.getAppClass();
        } else {
            return null;
        }
        if (element == sourceElement) {
            return targetEntity;
        }
        if (element instanceof ContextNode) {
            ModelRelationRole foundRole = ContextWizardHelper.findReachableModelRole(name, targetModelClass);
            if (foundRole == null) {
                return ContextWizardHelper.findReachableModelClass(name, targetModelClass);
            }
            return foundRole;
        }
        if (element instanceof ContextModelAttribute) {
            return ContextWizardHelper.findReachableModelClassProperty(name, targetModelClass);
        }
        return null;
    }

    public static ContextElement findBindingCandidate(ModelEntityTreeProxy proxy, DevelopmentObject targetParent, ContextElement sourceParent) {
        AbstractContextNode candidate = null;
        String name = proxy.getModelEntity().getName();
        ContextValueNode sourceContext = ((Controller)sourceParent.getMDO()).getContext();
        if (proxy instanceof ModelClassTreeProxy) {
            if (proxy.getParentProxy() instanceof ModelRelationRoleTreeProxy) {
                name = proxy.getParentProxy().getModelEntity().getName();
            }
            if ((candidate = ((ContextNode)sourceParent).getChildNode(name)) != null && !(candidate instanceof ContextModelNode)) {
                candidate = null;
            }
        } else if (proxy instanceof ModelRelationRoleTreeProxy) {
            candidate = ((ContextNode)sourceParent).getChildNode(name);
            if (candidate != null && !(candidate instanceof ContextModelNode)) {
                candidate = null;
            }
        } else if (proxy instanceof ModelPropertyTreeProxy && (candidate = ContextService.findContextAttributeByName((String)name, (ContextNode)((ContextNode)sourceParent))) != null && !(candidate instanceof ContextModelAttribute)) {
            candidate = null;
        }
        return candidate;
    }
}

