/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.modelbinding;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.checklayer.model.ModelClassHelper;
import com.sap.ide.webdynpro.controllereditor.context.ContextContentProvider;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelClassTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelEntityTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelPropertyTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelRelationRoleTreeProxy;
import com.sap.ide.webdynpro.controllereditor.wizards.context.modelbinding.ModelBindingHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class MergeModelTreeContentProvider
implements ITreeContentProvider {
    private DevelopmentObject mTargetModelEntity;
    private ContextElement mSourceContextElement;
    private ContextContentProvider.ContextRoot mContextRoot;
    private ITreeContentProvider mContextContentProvider;
    private boolean mIsMergeMode;
    private Map mFoundCandidates = new Hashtable();

    public MergeModelTreeContentProvider(ContextContentProvider.ContextRoot contextRoot, ContextElement sourceContextElement, ITreeContentProvider contextContentProvider) {
        this.mContextRoot = contextRoot;
        this.mSourceContextElement = sourceContextElement;
        this.mContextContentProvider = contextContentProvider;
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        Object parent = parentElement;
        if (this.mIsMergeMode) {
            children.addAll(this.doMerge(parent));
        } else {
            if (parentElement instanceof ContextElement) {
                children.addAll(Arrays.asList(this.mContextContentProvider.getChildren(parentElement)));
                if (parentElement.equals(this.mSourceContextElement)) {
                    parent = this.proxyForModelEntity(this.mTargetModelEntity);
                }
            }
            if (parent instanceof ModelEntityTreeProxy) {
                children.addAll(this.childrenForProxy((ModelEntityTreeProxy)parent));
            }
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        ModelEntityTreeProxy proxy;
        Object parent = null;
        ModelRelationRoleTreeProxy roleProxy = null;
        if (element instanceof ModelClassTreeProxy) {
            roleProxy = ((ModelClassTreeProxy)element).getParent();
            if (roleProxy != null) {
                parent = roleProxy.getParent();
            }
        } else if (element instanceof ModelPropertyTreeProxy) {
            parent = ((ModelPropertyTreeProxy)element).getParent();
        } else if (element instanceof ContextElement) {
            parent = this.mContextContentProvider.getParent(element);
        }
        if (element instanceof ModelEntityTreeProxy && (proxy = (ModelEntityTreeProxy)element).getForeignParent() != null) {
            parent = proxy.getForeignParent();
        }
        if (parent != null && parent instanceof ModelEntityTreeProxy) {
            if (((ModelEntityTreeProxy)parent).getModelEntity() == this.mTargetModelEntity) {
                parent = this.mSourceContextElement;
            } else if (roleProxy != null && roleProxy.getParentProxy() != null && roleProxy.getParentProxy().getModelEntity() == this.mTargetModelEntity) {
                parent = this.mSourceContextElement;
            } else if (roleProxy != null && roleProxy.getParentProxy() != null && roleProxy.getParentProxy().getParentProxy() != null && roleProxy.getParentProxy().getParentProxy().getModelEntity() == this.mTargetModelEntity) {
                parent = this.mSourceContextElement;
            } else if (roleProxy != null && roleProxy.getModelEntity() == this.mTargetModelEntity) {
                parent = this.mSourceContextElement;
            }
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ContextAttribute || element instanceof ModelPropertyTreeProxy) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Object> elements = new ArrayList<Object>();
        ModelEntityTreeProxy parent = null;
        elements.addAll(Arrays.asList(this.mContextContentProvider.getElements((Object)this.mContextRoot)));
        if (elements.contains(this.mSourceContextElement) && this.mTargetModelEntity != null) {
            parent = this.proxyForModelEntity(this.mTargetModelEntity);
            elements.addAll(Arrays.asList(this.getChildren(parent)));
        }
        return elements.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setTargetModelEntity(DevelopmentObject targetModelEntity) {
        this.mTargetModelEntity = targetModelEntity;
    }

    public void setMergeMode(boolean mergeMode) {
        this.mIsMergeMode = mergeMode;
    }

    private ModelEntityTreeProxy proxyForModelEntity(DevelopmentObject modelEntity) {
        ModelEntityTreeProxy proxy = null;
        if (modelEntity instanceof ModelClass) {
            proxy = new ModelClassTreeProxy((ModelClass)modelEntity, null, null);
        } else if (modelEntity instanceof ModelRelationRole) {
            ModelRelationRole role = (ModelRelationRole)modelEntity;
            ModelRelationRoleTreeProxy roleProxy = new ModelRelationRoleTreeProxy(role, null, null);
            proxy = new ModelClassTreeProxy(role.getModelClass(), roleProxy, null);
        } else if (modelEntity instanceof ModelClassProperty) {
            ModelClassProperty property = (ModelClassProperty)modelEntity;
            ModelClass modelClass = (ModelClass)property.getAppClass();
            proxy = new ModelPropertyTreeProxy((Property)property, null);
        }
        return proxy;
    }

    private List childrenForProxy(ModelEntityTreeProxy parent) {
        ArrayList<ModelEntityTreeProxy> children = new ArrayList<ModelEntityTreeProxy>();
        if (parent instanceof ModelClassTreeProxy) {
            ModelClassTreeProxy classProxy = (ModelClassTreeProxy)parent;
            ModelClassProperty[] properties = ModelClassHelper.getProperties((ModelClass)classProxy.getModelClass());
            int i = 0;
            while (i < properties.length) {
                ModelPropertyTreeProxy childProperty = new ModelPropertyTreeProxy((Property)properties[i], classProxy);
                children.add(childProperty);
                ++i;
            }
            ModelRelationRole[] targetRoles = ModelClassHelper.getNavigableTargetModelRelationRoles((ModelClass)classProxy.getModelClass());
            int i2 = 0;
            while (i2 < targetRoles.length) {
                ModelRelationRoleTreeProxy roleProxy = new ModelRelationRoleTreeProxy(targetRoles[i2], classProxy, null);
                ModelClassTreeProxy childClassProxy = new ModelClassTreeProxy(targetRoles[i2].getModelClass(), roleProxy, null);
                if (!this.isRecursiveEntity(childClassProxy)) {
                    ArrayList<ModelClassTreeProxy> child = new ArrayList<ModelClassTreeProxy>();
                    child.add(childClassProxy);
                    roleProxy.setChildren(child);
                    children.add(childClassProxy);
                }
                ++i2;
            }
            classProxy.setChildren(children);
        }
        return children;
    }

    protected boolean isRecursiveEntity(ModelClassTreeProxy classProxy) {
        ModelEntityTreeProxy parent = classProxy.getParent();
        ModelClass parentModelEntity = null;
        while (parent != null) {
            if (parent instanceof ModelClassTreeProxy) {
                ModelClassTreeProxy parentClassProxy = (ModelClassTreeProxy)parent;
                parentModelEntity = parentClassProxy.getModelClass();
            } else if (parent instanceof ContextModelNode) {
                ContextModelNode modelNode = (ContextModelNode)parent;
                parentModelEntity = modelNode.getModelClass();
            }
            ModelClass elementModelEntity = classProxy.getModelClass();
            if (parentModelEntity != null && parentModelEntity == elementModelEntity) {
                return true;
            }
            if (!(parent instanceof ModelEntityTreeProxy)) continue;
            parent = ((ModelEntityTreeProxy)parent).getParentProxy();
        }
        return false;
    }

    private List doMerge(Object parent) {
        ArrayList<Object> results = new ArrayList<Object>();
        DevelopmentObject targetParent = null;
        if (parent instanceof ContextElement) {
            DevelopmentObject target;
            ContextNode parentNode;
            Object[] sourceChildren = this.mContextContentProvider.getChildren(parent);
            results.addAll(Arrays.asList(sourceChildren));
            if (parent instanceof ContextNode && this.isDescendantOfSourceElement((ContextElement)((ContextNode)parent)) && (targetParent = ModelBindingHelper.findBindingCandidate((ContextElement)(parentNode = (ContextNode)parent), this.mSourceContextElement, target = this.getParentsCandidate((ContextElement)parentNode))) != null) {
                this.mFoundCandidates.put(parentNode, targetParent);
                ModelEntityTreeProxy parentProxy = this.proxyForModelEntity(targetParent);
                List targetChildren = this.childrenForProxy(parentProxy);
                Iterator iter = targetChildren.iterator();
                while (iter.hasNext()) {
                    boolean foundInSource;
                    ModelEntityTreeProxy targetChildProxy = (ModelEntityTreeProxy)iter.next();
                    DevelopmentObject targetChild = targetChildProxy.getModelEntity();
                    boolean bl = foundInSource = ModelBindingHelper.findBindingCandidate(targetChildProxy, targetParent, (ContextElement)parentNode) != null;
                    if (foundInSource || !this.isHierarchyCorrect((ContextElement)parentNode, targetChild)) continue;
                    results.add(targetChildProxy);
                    targetChildProxy.setForeignParent(parentNode);
                }
            }
        } else if (parent instanceof ModelEntityTreeProxy) {
            results.addAll(this.childrenForProxy((ModelEntityTreeProxy)parent));
        }
        return results;
    }

    private boolean isHierarchyCorrect(ContextElement sourceParent, DevelopmentObject target) {
        if (sourceParent != this.mSourceContextElement && !(target.getParent() instanceof Model) && target.getParent() != null) {
            DevelopmentObject sourceParentObject = sourceParent.getParent();
            DevelopmentObject targetParent = target.getParent();
            if (targetParent != null && sourceParentObject instanceof ContextElement && !this.isHierarchyCorrect((ContextElement)sourceParentObject, targetParent)) {
                return false;
            }
        }
        return true;
    }

    private boolean isDescendantOfSourceElement(ContextElement element) {
        if (element == this.mSourceContextElement) {
            return true;
        }
        Object parent = this.getParent(element);
        if (parent instanceof ContextElement) {
            return this.isDescendantOfSourceElement((ContextElement)parent);
        }
        return false;
    }

    private DevelopmentObject getParentsCandidate(ContextElement element) {
        Object candidate = null;
        DevelopmentObject parent = element.getParent();
        if (parent == null) {
            return null;
        }
        if (!(parent instanceof ContextElement)) {
            return null;
        }
        if (parent == this.mSourceContextElement) {
            return this.mTargetModelEntity;
        }
        if (element == this.mSourceContextElement) {
            return this.mTargetModelEntity;
        }
        candidate = this.mFoundCandidates.get(parent);
        if (candidate instanceof DevelopmentObject) {
            return candidate;
        }
        return null;
    }
}

