/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.modelbinding;

import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelClassTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelPropertyTreeProxy;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelRelationRoleTreeProxy;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.IItemValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListValidationService;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.ValidationResult;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import org.eclipse.core.runtime.IStatus;

public class BindingWizardValidator
implements IItemValidator {
    private ContextWizardData mData;
    private TreeListItem mRootItem;
    private static final String CONTEXT_NAME = "Context";

    public BindingWizardValidator(ContextWizardData data) {
        this.mData = data;
    }

    public IStatus validateItem(TreeListItem item, TreeListItemHelper helper, String columnProperty, Object value) {
        Object element = item.getElement();
        TextPool textPool = TextPool.getInstance();
        ContextElement sourceRootElement = this.mData.getSourceContextElement();
        String message = null;
        ContextValueNode sourceContext = ((Controller)sourceRootElement.getMDO()).getContext();
        String name = null;
        if (columnProperty == null && value == null && item.getProperties().isEmpty()) {
            return null;
        }
        if (columnProperty == null && value == null && !item.getProperties().isEmpty()) {
            columnProperty = "Name";
            name = (String)item.getProperties().getValue("Name");
        } else if (columnProperty == "Name") {
            name = (String)value;
        } else {
            return null;
        }
        if ((element instanceof ContextAttribute || element instanceof ModelPropertyTreeProxy) && this.hasStructureBinding(item) && !name.equals((String)item.getProperties().getValue("Name"))) {
            message = textPool.getText(2017);
            return new ValidationResult(message, 4);
        }
        TreeListItem parentItem = helper.get(item.getParent());
        if (value != null && !CheckServices.isValidIdentifier((String)name)) {
            message = CoreTextPool.getInstance().getText(2, (Object)name);
            return new ValidationResult(message, 4);
        }
        boolean isDuplicate = false;
        if (item.isEnabled() && item.isChecked()) {
            if (name.equalsIgnoreCase(CONTEXT_NAME) && element instanceof ContextValueNode && !item.isTopLevelItem()) {
                isDuplicate = true;
            } else if (element instanceof ModelClassTreeProxy || element instanceof ContextNode) {
                if (TreeListValidationService.isDuplicateName(item, helper, columnProperty, name)) {
                    isDuplicate = true;
                }
            } else if ((element instanceof ModelPropertyTreeProxy || element instanceof ContextAttribute) && TreeListValidationService.isDuplicateName(item, parentItem, helper, columnProperty, name)) {
                isDuplicate = true;
            }
        }
        if (isDuplicate) {
            message = textPool.getText(2007, (Object)name);
            return new ValidationResult(message, 4);
        }
        if ((element instanceof ModelClassTreeProxy || element instanceof ModelRelationRoleTreeProxy) && !item.isTopLevelItem() && item.isChecked() && item.isEnabled() && ContextService.isUniqueNodeWithinContext((String)name, (ContextNode)sourceContext) != null) {
            message = textPool.getText(2003, (Object)name);
            return new ValidationResult(message, 4);
        }
        return TreeListValidationService.OK_RESULT;
    }

    public boolean isEnabled(TreeListItem item, TreeListItemHelper helper) {
        ContextElement sourceElement = this.mData.getSourceContextElement();
        TreeListItem sourceElementItem = helper.get(sourceElement);
        if (item.isTopLevelItem()) {
            return false;
        }
        if (item.getElement() == this.mData.getSourceContextElement()) {
            return true;
        }
        return !(this.mData.isMergeMode() ? item.getProperties().getValue("Model class/property") == null : item.getElement() instanceof ContextElement);
    }

    public boolean isNode(TreeListItem item, TreeListItemHelper helper) {
        return item.getElement() instanceof AbstractContextNode || item.getElement() instanceof ModelClassTreeProxy || item.getElement() instanceof ModelRelationRoleTreeProxy;
    }

    public boolean isChecked(TreeListItem item, TreeListItemHelper helper) {
        Object element = item.getElement();
        if (element instanceof ContextElement) {
            ContextElement contextElement = (ContextElement)element;
            if (contextElement instanceof ContextModelNode) {
                return CheckLayerHelper.getModelClass((ContextModelNode)((ContextModelNode)contextElement), (boolean)true) != null;
            }
            if (contextElement instanceof ContextModelAttribute) {
                return CheckLayerHelper.getReferencedProperty((ContextModelAttribute)((ContextModelAttribute)contextElement), (boolean)true) != null;
            }
        }
        return false;
    }

    private boolean hasStructureBinding(TreeListItem item) {
        Object itemElement = item.getElement();
        if (itemElement instanceof ModelClassTreeProxy) {
            ModelClassTreeProxy classProxy = (ModelClassTreeProxy)itemElement;
            return classProxy.getModelClass().hasStructure();
        }
        if (itemElement instanceof ModelPropertyTreeProxy) {
            ModelPropertyTreeProxy propertyProxy = (ModelPropertyTreeProxy)itemElement;
            ModelClassProperty property = (ModelClassProperty)propertyProxy.getModelProperty();
            return property.hasStructureElement();
        }
        if (itemElement instanceof ContextElement) {
            Object candidate = item.getProperties().getValue("Model class/property");
            if (candidate instanceof ModelClass) {
                return ((ModelClass)candidate).hasStructure();
            }
            if (candidate instanceof ModelClassProperty) {
                return ((ModelClassProperty)candidate).hasStructureElement();
            }
        }
        return false;
    }
}

