/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.mapping;

import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.context.ContextContentProvider;
import com.sap.ide.webdynpro.controllereditor.context.ContextElementSorter;
import com.sap.ide.webdynpro.controllereditor.context.ContextLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.ControllerWizardPage;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.context.mapping.DisabledContextElementImageProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.mapping.MappingPropertyProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.mapping.MappingWizardValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.context.mapping.MergeMappingLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.mapping.MergeMappingTreeContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.CheckboxTreeAndList;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericListContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericListLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericTreeContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.GenericTreeLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemCellModifier;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemCellValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemSorter;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListValidationService;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class PageContextMapping
extends ControllerWizardPage {
    private MergeMappingLabelProvider mMergeLabelProvider;
    private DisabledContextElementImageProvider mDisabledStateLabelProvider;
    private MappingPropertyProvider mPropertyProvider;
    private ContextContentProvider mSourceContextContentProvider;
    private ContextContentProvider.ContextRoot mSourceContextRoot;
    private static final String PAGE_NAME;
    private static final String TITLE;
    public static final String COLUMN_NAME = "Name";
    public static final String COLUMN_MAPPED_ELEMENT = "Mapped element";
    private static String[] mColumns;
    private ContextWizardData mData;
    private TreeListItemHelper mHelper = new TreeListItemHelper();
    private CheckboxTreeAndList mTreeList;
    private Composite mMappingTreeListControl;
    private Button mMergeCheckBox;
    private CellEditor mTextCellEditor;
    private TreeListItemCellValidator mRenameCellEditorValidator;
    private TreeListItemCellModifier mRenameCellModifier;
    private MappingWizardValidator mMappingWizardValidator;
    private MergeMappingTreeContentProvider mMergeMappingTreeContentProvider;
    private ViewerSorter mTreeSorter;
    private ViewerSorter mListSorter = this.mTreeSorter = new ContextElementSorter();
    private ContextLabelProvider mSourceContextLabelProvider;
    private ContextLabelProvider mTargetContextLabelProvider;
    private TreeListValidationService mValidation;
    private boolean mControlCreated = false;

    public PageContextMapping(ContextWizardData data) {
        super(PAGE_NAME, TITLE, null);
        this.setDescription(TextPool.getInstance().getText(2507));
        this.mData = data;
        data.setMergeMode(true);
    }

    public void createControl(Composite parent) {
        if (this.mData.getIsReverseMappingMode()) {
            this.setDescription(TextPool.getInstance().getText(2508));
        }
        Composite rootControl = new Composite(parent, 0);
        rootControl.setLayout((Layout)new GridLayout(1, false));
        this.createProviders();
        this.createValidators();
        this.mMappingTreeListControl = new Composite(rootControl, 0);
        this.mMappingTreeListControl.setLayout((Layout)new FillLayout());
        this.mTreeList = new CheckboxTreeAndList(this.mMappingTreeListControl, this.mSourceContextRoot, new GenericTreeContentProvider(this.mHelper, this.mMergeMappingTreeContentProvider), (ILabelProvider)new GenericTreeLabelProvider(this.mHelper, (ILabelProvider)this.mMergeLabelProvider, (ILabelProvider)this.mDisabledStateLabelProvider, this.mPropertyProvider, this.mValidation), new GenericListContentProvider(this.mHelper, (IStructuredContentProvider)this.mMergeMappingTreeContentProvider), (ILabelProvider)new GenericListLabelProvider(this.mHelper, (ILabelProvider)this.mMergeLabelProvider, (ILabelProvider)this.mDisabledStateLabelProvider, this.mPropertyProvider, this.mValidation), new TreeListItemSorter(this.mTreeSorter), new TreeListItemSorter(this.mListSorter), mColumns, 0, -1, -1);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        this.mMappingTreeListControl.setLayoutData((Object)gridData);
        this.mMergeCheckBox = new Button(rootControl, 32);
        this.mMergeCheckBox.setSelection(this.mData.isMergeMode());
        GridData checkBoxGridData = new GridData();
        checkBoxGridData.heightHint = 35;
        checkBoxGridData.horizontalIndent = 5;
        this.mMergeCheckBox.setLayoutData((Object)checkBoxGridData);
        this.mMergeCheckBox.setText(TextPool.getInstance().getText(2220));
        this.mMergeCheckBox.addSelectionListener((SelectionListener)new MergeCheckBoxSelectionListener());
        Table table = this.mTreeList.getListTable();
        table.getColumn(0).setWidth(120);
        table.getColumn(1).setWidth(160);
        table.getColumn(0).setText(TextPool.getInstance().getText(2212));
        table.getColumn(1).setText(TextPool.getInstance().getText(2214));
        this.mTextCellEditor = new TextCellEditor((Composite)this.mTreeList.getListViewer().getTable());
        this.setControl((Control)rootControl);
        this.mControlCreated = true;
    }

    public boolean isPageComplete() {
        return this.mValidation != null && this.mValidation.validateForWizardPageCompleteness();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initializeWithProgress();
        }
        super.setVisible(visible);
    }

    private void initializeWithProgress() {
        IRunnableWithProgress initItems = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                PageContextMapping.this.initializeItems(monitor);
            }
        };
        IRunnableWithProgress initUI = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                PageContextMapping.this.initializeUI(monitor);
            }
        };
        try {
            this.getContainer().run(true, false, initItems);
            this.getContainer().run(false, false, initUI);
        }
        catch (InvocationTargetException e) {
            Plugin.internalError(this.getClass(), "initializeWithProgress()", e.getTargetException().getMessage(), e.getTargetException(), false);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public void initializeItems(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask(TextPool.getInstance().getText(2227), -1);
        }
        this.mHelper.clearData();
        if (this.mData.getHelper() == null) {
            this.mData.setHelper(this.mHelper);
        }
        this.buildTreeListItems(monitor);
        if (monitor != null) {
            monitor.done();
        }
    }

    private void initializeUI(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask(TextPool.getInstance().getText(2228), this.mHelper.getItems().size());
        }
        this.mHelper.setTreeListEditable(this, new CellEditor[]{this.mTextCellEditor, this.mTextCellEditor, this.mTextCellEditor}, this.mRenameCellModifier, this.mRenameCellEditorValidator);
        this.mData.getHelper().initializeTreeList(this, this.mData.getHelper().getTopLevelItems(), this.mData.getSourceContextElement(), 2, monitor);
        if (monitor != null) {
            monitor.done();
        }
        this.setPageComplete(this.isPageComplete());
    }

    private void buildTreeListItems(IProgressMonitor monitor) {
        this.createProviders();
        this.setTarget();
        this.createValidators();
        this.mHelper.buildTreeListItems(this.mTreeList, this.mMergeMappingTreeContentProvider, mColumns, this.mPropertyProvider, this.mSourceContextRoot, this.mValidation, monitor);
    }

    private void createValidators() {
        this.mRenameCellEditorValidator = new TreeListItemCellValidator();
        this.mRenameCellModifier = new MappingCellModifier();
        this.mMappingWizardValidator = new MappingWizardValidator(this.mData);
        this.mValidation = new TreeListValidationService(this.mMappingWizardValidator, this.mHelper);
    }

    private void createProviders() {
        if (this.mControlCreated) {
            return;
        }
        ContextValueNode sourceContext = ((Controller)this.mData.getSourceContextElement().getMDO()).getContext();
        this.mSourceContextRoot = new ContextContentProvider.ContextRoot((ContextElement)sourceContext);
        this.mSourceContextContentProvider = new ContextContentProvider(this.mSourceContextRoot);
        this.mSourceContextLabelProvider = new ContextLabelProvider(this.mData.getControllerUsages(), this.mData.getIsReverseMappingMode(), false, false);
        this.mMergeMappingTreeContentProvider = new MergeMappingTreeContentProvider(this.mSourceContextRoot, this.mData.getSourceContextElement(), this.mSourceContextContentProvider, this.mData.getIsReverseMappingMode());
        this.mMergeLabelProvider = new MergeMappingLabelProvider((ILabelProvider)this.mSourceContextLabelProvider, (Controller)sourceContext.getMDO());
        this.mDisabledStateLabelProvider = new DisabledContextElementImageProvider();
        this.mPropertyProvider = new MappingPropertyProvider(this.mData.getControllerUsages(), this.mData.getSourceContextElement(), this.mData.getIsReverseMappingMode());
    }

    private void setTarget() {
        ContextValueNode targetContext = ((Controller)this.mData.getTargetContextElement().getMDO()).getContext();
        ContextContentProvider.ContextRoot targetContextRoot = new ContextContentProvider.ContextRoot((ContextElement)targetContext);
        ContextContentProvider targetContentProvider = new ContextContentProvider(targetContextRoot);
        this.mMergeMappingTreeContentProvider.setTargetProvider(targetContentProvider, this.mData.getTargetContextElement());
        this.mMergeMappingTreeContentProvider.setMergeMode(this.mData.isMergeMode());
        this.mTargetContextLabelProvider = new ContextLabelProvider(((Controller)targetContext.getMDO()).getOutgoingControllerUsages(), this.mData.getIsReverseMappingMode(), false, false);
        this.mMergeLabelProvider.setTargetProvider((ILabelProvider)this.mTargetContextLabelProvider);
        this.mPropertyProvider.setTarget(this.mData.getTargetContextElement(), this.mData.getSelectedControllerUsage());
    }

    static {
        TITLE = PAGE_NAME = TextPool.getInstance().getText(2308);
        mColumns = new String[]{COLUMN_NAME, COLUMN_MAPPED_ELEMENT};
    }

    private class MergeCheckBoxSelectionListener
    implements SelectionListener {
        private MergeCheckBoxSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            PageContextMapping.this.mData.setMergeMode(((Button)e.getSource()).getSelection());
            BusyIndicator.showWhile((Display)PageContextMapping.this.mTreeList.getTreeViewer().getControl().getDisplay(), (Runnable)new Runnable(this){
                private final /* synthetic */ MergeCheckBoxSelectionListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    MergeCheckBoxSelectionListener.access$500(this.this$1).initializeItems(null);
                    PageContextMapping.access$100(MergeCheckBoxSelectionListener.access$500(this.this$1), null);
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        static /* synthetic */ PageContextMapping access$500(MergeCheckBoxSelectionListener x0) {
            return x0.PageContextMapping.this;
        }
    }

    private class MappingCellModifier
    extends TreeListItemCellModifier {
        private MappingCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (property != PageContextMapping.COLUMN_NAME) {
                return false;
            }
            if (PageContextMapping.this.mData.getIsReverseMappingMode()) {
                return false;
            }
            if (element instanceof TreeListItem) {
                TreeListItem treeListItem = (TreeListItem)element;
            }
            return super.canModify(element, property);
        }
    }
}

