/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.mapping;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextRecursionNode;
import com.sap.ide.webdynpro.controllereditor.context.ContextContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.mapping.MappingHelper;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class MergeMappingTreeContentProvider
implements ITreeContentProvider {
    private TreeViewer mViewer;
    private ContextElement mTargetContextElement;
    private ContextElement mSourceContextElement;
    private ContextContentProvider.ContextRoot mContextRoot;
    private ITreeContentProvider mSourceContextContentProvider;
    private ITreeContentProvider mTargetContextContentProvider;
    private boolean mIsReverseMapping;
    private boolean mIsMergeMode = false;
    private Map mForeignParents = new Hashtable();

    public MergeMappingTreeContentProvider(ContextContentProvider.ContextRoot contextRoot, ContextElement sourceContextElement, ITreeContentProvider sourceContextContentProvider, boolean isReverseMapping) {
        this.mContextRoot = contextRoot;
        this.mSourceContextElement = sourceContextElement;
        this.mSourceContextContentProvider = sourceContextContentProvider;
        this.mIsReverseMapping = isReverseMapping;
    }

    public Object[] getChildren(Object parentElement) {
        Vector<Object> children = new Vector<Object>();
        if (this.mIsReverseMapping) {
            children.addAll(Arrays.asList(this.mSourceContextContentProvider.getChildren(parentElement)));
        } else {
            if (this.mIsMergeMode) {
                children.addAll(this.doMerge((ContextElement)parentElement));
            } else {
                children.addAll(Arrays.asList(this.mSourceContextContentProvider.getChildren(parentElement)));
                if (parentElement == this.mSourceContextElement) {
                    children.addAll(Arrays.asList(this.mTargetContextContentProvider.getChildren((Object)this.mTargetContextElement)));
                }
            }
            this.removeDisabledTargetElements(children);
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        Object parent = this.mSourceContextContentProvider.getParent(element);
        if (!this.mIsReverseMapping) {
            Object targetParent = this.mTargetContextContentProvider.getParent(element);
            if (parent == this.mTargetContextElement) {
                parent = this.mSourceContextElement;
            } else if (parent == null) {
                parent = targetParent;
            }
            if (this.mForeignParents.containsKey(element)) {
                parent = this.mForeignParents.get(element);
            }
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        Vector<Object> elements = new Vector<Object>();
        elements.addAll(Arrays.asList(this.mSourceContextContentProvider.getElements((Object)this.mContextRoot)));
        return elements.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.mForeignParents.clear();
    }

    public void setTargetProvider(ITreeContentProvider targetContextContentProvider, ContextElement targetContextElement) {
        this.mTargetContextElement = targetContextElement;
        this.mTargetContextContentProvider = targetContextContentProvider;
    }

    public void setMergeMode(boolean mergeMode) {
        this.mIsMergeMode = mergeMode;
    }

    private void removeDisabledTargetElements(List elements) {
        Vector<ContextElement> elementsToRemove = new Vector<ContextElement>();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            ContextElement element = (ContextElement)iter.next();
            if (element.getMDO() != this.mTargetContextElement.getMDO()) continue;
            if (element instanceof ContextRecursionNode) {
                elementsToRemove.add(element);
                continue;
            }
            if (!this.mIsReverseMapping || !element.getIsInputElement()) continue;
            elementsToRemove.add(element);
        }
        elements.removeAll(elementsToRemove);
    }

    private List doMerge(ContextElement parent) {
        Vector<Object> results = new Vector<Object>();
        ContextElement targetParent = null;
        if (parent.getMDO() == this.mContextRoot.getRoot().getMDO()) {
            ContextNode parentNode;
            Object[] sourceChildren = this.mSourceContextContentProvider.getChildren((Object)parent);
            results.addAll(Arrays.asList(sourceChildren));
            if (this.isDescendantOfSourceElement(parent) && parent instanceof ContextNode && (targetParent = MappingHelper.findMappingCandidate((ContextElement)(parentNode = (ContextNode)parent), this.mSourceContextElement, this.mTargetContextElement)) != null) {
                Object[] targetChildren = this.mTargetContextContentProvider.getChildren((Object)targetParent);
                int i = 0;
                while (i < targetChildren.length) {
                    boolean foundInSource;
                    ContextElement element = (ContextElement)targetChildren[i];
                    boolean foundInTarget = MappingHelper.findMappingCandidate(element, (ContextElement)parentNode, targetParent) != null;
                    boolean bl = foundInSource = MappingHelper.findMappingCandidate(element, targetParent, (ContextElement)parentNode) != null;
                    if (foundInTarget && !foundInSource && this.isHierarchyCorrect((ContextElement)parentNode, element)) {
                        results.add(element);
                        this.mForeignParents.put(element, parentNode);
                    }
                    ++i;
                }
            }
        } else {
            Object[] targetChildren = this.mTargetContextContentProvider.getChildren((Object)parent);
            results.addAll(Arrays.asList(targetChildren));
        }
        return results;
    }

    private boolean isHierarchyCorrect(ContextElement sourceParent, ContextElement target) {
        if (sourceParent != this.mSourceContextElement && target.getParent() != null) {
            if (!sourceParent.getName().equalsIgnoreCase(target.getParent().getName())) {
                return false;
            }
            DevelopmentObject sourceParentObject = sourceParent.getParent();
            DevelopmentObject targetParent = target.getParent();
            if (sourceParentObject != null && targetParent != null && sourceParentObject instanceof ContextElement && targetParent instanceof ContextElement && !this.isHierarchyCorrect((ContextElement)sourceParentObject, (ContextElement)targetParent)) {
                return false;
            }
        }
        return true;
    }

    private boolean isDescendantOfSourceElement(ContextElement element) {
        if (element == this.mSourceContextElement) {
            return true;
        }
        Object parent = this.getParent(element);
        if (parent instanceof ContextElement) {
            return this.isDescendantOfSourceElement((ContextElement)parent);
        }
        return false;
    }
}

