/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.mapping;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextRecursionNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.IItemValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItemHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListValidationService;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.ValidationResult;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import org.eclipse.core.runtime.IStatus;

public class MappingWizardValidator
implements IItemValidator {
    private ContextWizardData mData;

    public MappingWizardValidator(ContextWizardData data) {
        this.mData = data;
    }

    public IStatus validateItem(TreeListItem item, TreeListItemHelper helper, String columnProperty, Object value) {
        String CONTEXT_NAME = "Context";
        ContextElement element = (ContextElement)item.getElement();
        String message = null;
        TextPool textPool = TextPool.getInstance();
        TreeListItem parentItem = helper.get(item.getParent());
        Controller sourceController = (Controller)this.mData.getSourceContextElement().getMDO();
        String name = null;
        if (columnProperty == null && value == null && item.getProperties().isEmpty()) {
            return null;
        }
        if (columnProperty == null && value == null && !item.getProperties().isEmpty()) {
            columnProperty = "Name";
            name = (String)item.getProperties().getValue("Name");
        } else if (columnProperty == "Name") {
            name = (String)value;
        } else {
            return null;
        }
        if (element instanceof ContextAttribute && this.hasStructureBinding(item) && !name.equals((String)item.getProperties().getValue("Name"))) {
            message = textPool.getText(2017);
            return new ValidationResult(message, 4);
        }
        if (value != null && !CheckServices.isValidIdentifier((String)name)) {
            message = CoreTextPool.getInstance().getText(2, (Object)name);
            return new ValidationResult(message, 4);
        }
        if (this.mData.getIsReverseMappingMode() && item.isEnabled() && item.isChecked()) {
            DevelopmentObject targetType;
            DevelopmentObject sourceType;
            String typeMessage;
            Object candidate = item.getProperties().getValue("Mapped element");
            if (candidate == null) {
                message = textPool.getText(2014, (Object)name);
                return new ValidationResult(message, 4);
            }
            if (element instanceof ContextValueAttribute && candidate instanceof ContextValueAttribute && (typeMessage = CheckLayerHelper.isValidType((DevelopmentObject)(sourceType = CheckLayerHelper.getType((ContextAttribute)((ContextValueAttribute)element), (boolean)true)), (DevelopmentObject)(targetType = CheckLayerHelper.getType((ContextAttribute)((ContextValueAttribute)candidate), (boolean)false)))) != null) {
                return new ValidationResult(typeMessage, 4);
            }
        }
        if (element.equals(this.mData.getTargetContextElement())) {
            return null;
        }
        boolean isDuplicate = false;
        if (item.isEnabled() && item.isChecked()) {
            if (name.equalsIgnoreCase("Context") && element instanceof ContextValueNode && !item.isTopLevelItem()) {
                isDuplicate = true;
            } else if (!this.mData.getSourceContextElement().equals(element) && element instanceof ContextNode && item.isEnabled()) {
                if (TreeListValidationService.isDuplicateName(item, helper, columnProperty, name)) {
                    isDuplicate = true;
                }
            } else if (element instanceof ContextAttribute && item.isEnabled() && TreeListValidationService.isDuplicateName(item, parentItem, helper, columnProperty, name)) {
                isDuplicate = true;
            }
        }
        if (isDuplicate) {
            message = textPool.getText(2007, (Object)name);
            return new ValidationResult(message, 4);
        }
        if (element.getMDO() != sourceController && element instanceof ContextNode && !item.isTopLevelItem() && item.isChecked() && item.isEnabled() && ContextService.isUniqueNodeWithinContext((String)name, (ContextNode)sourceController.getContext()) != null) {
            message = textPool.getText(2003, (Object)name);
            return new ValidationResult(message, 4);
        }
        return TreeListValidationService.OK_RESULT;
    }

    public boolean isEnabled(TreeListItem item, TreeListItemHelper helper) {
        ContextElement element = (ContextElement)item.getElement();
        TreeListItem parentItem = helper.get(item.getParent());
        ContextElement sourceElement = this.mData.getSourceContextElement();
        TreeListItem sourceElementItem = helper.get(sourceElement);
        MainDevelopmentObject sourceMDO = sourceElement.getMDO();
        if (item.isTopLevelItem()) {
            return false;
        }
        if (element instanceof ContextRecursionNode) {
            return false;
        }
        if (element == this.mData.getSourceContextElement()) {
            return true;
        }
        if (this.mData.getIsReverseMappingMode()) {
            if (!element.getIsInputElement()) {
                return false;
            }
            if (item.getProperties().getValue("Mapped element") == null) {
                return false;
            }
            if (!helper.isDescendant(item, sourceElementItem)) {
                return false;
            }
        } else if (this.mData.isMergeMode()) {
            if (item.getProperties().getValue("Mapped element") == null) {
                return false;
            }
            if (!helper.isDescendant(item, sourceElementItem)) {
                return false;
            }
        } else if (element.getMDO() == sourceMDO) {
            return false;
        }
        return true;
    }

    public boolean isNode(TreeListItem item, TreeListItemHelper helper) {
        return item.getElement() instanceof AbstractContextNode;
    }

    public boolean isChecked(TreeListItem item, TreeListItemHelper helper) {
        ContextElement element = (ContextElement)item.getElement();
        ContextElement sourceElement = this.mData.getSourceContextElement();
        if (element.getMDO().equals(sourceElement.getMDO())) {
            return CheckLayerHelper.hasValidMapping((ContextElement)element, (ControllerUsage[])this.mData.getControllerUsages());
        }
        return false;
    }

    private boolean hasStructureBinding(TreeListItem item) {
        if (item.getElement() instanceof ContextElement) {
            ContextElement element = (ContextElement)item.getElement();
            if (element.getMDO() == this.mData.getSourceContextElement().getMDO()) {
                Object candidate = item.getProperties().getValue("Mapped element");
                if (candidate instanceof ContextElement) {
                    return CheckLayerHelper.hasStructureBinding((ContextElement)((ContextElement)candidate));
                }
            } else {
                return CheckLayerHelper.hasStructureBinding((ContextElement)element);
            }
        }
        return false;
    }
}

