/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.mapping;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.webdynpro.controllereditor.wizards.context.mapping.MappingHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.IPropertyProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;

public class MappingPropertyProvider
implements IPropertyProvider {
    private ControllerUsage mTargetUsage;
    private ContextElement mTargetElement;
    private MainDevelopmentObject mSourceMDO;
    private ControllerUsage[] mSourceUsages;
    private ContextElement mSourceElement;
    private boolean mIsReverseMapping = false;

    public MappingPropertyProvider(ControllerUsage[] sourceUsages, ContextElement sourceElement, boolean isReverseMapping) {
        this.mSourceUsages = sourceUsages;
        this.mSourceElement = sourceElement;
        this.mIsReverseMapping = isReverseMapping;
        if (this.mSourceUsages != null && this.mSourceUsages.length > 0) {
            this.mSourceMDO = this.mSourceUsages[0].getMDO();
        }
    }

    public Object getValue(Object element, String name) {
        int index = -1;
        if (name == "Name") {
            index = 0;
        } else if (name == "Mapped element") {
            index = 1;
        }
        if (index > -1) {
            return this.getColumnValue(element, index);
        }
        return null;
    }

    public String getLabel(Object element, String name) {
        return this.getColumnText(this.getValue(element, name));
    }

    private Object getColumnValue(Object element, int columnIndex) {
        if (element instanceof TreeListItem) {
            TreeListItem item = (TreeListItem)element;
            return item.getProperties().getValue(columnIndex);
        }
        if (element instanceof ContextElement) {
            ContextElement contextElement = (ContextElement)element;
            switch (columnIndex) {
                case 0: {
                    return contextElement.getName();
                }
                case 1: {
                    if (this.mIsReverseMapping) {
                        return MappingHelper.findMappingCandidate(contextElement, this.mSourceElement, this.mTargetElement);
                    }
                    if (contextElement == this.mSourceElement && this.mTargetElement != null) {
                        return this.mTargetElement;
                    }
                    if (contextElement.getMDO() == this.mSourceMDO) {
                        return MappingHelper.findMappingCandidate(contextElement, this.mSourceElement, this.mTargetElement);
                    }
                    return contextElement;
                }
            }
            return null;
        }
        return null;
    }

    private String getColumnText(Object value) {
        if (value instanceof DevelopmentObject) {
            return ((DevelopmentObject)value).getName();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    public void setTarget(ContextElement targetElement, ControllerUsage targetUsage) {
        this.mTargetElement = targetElement;
        this.mTargetUsage = targetUsage;
    }
}

